/*
 * $Id: Generator.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Generator.h"
#include "Behavioural/include/Stat_binary_tree.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Generator::Generator"
  Generator::Generator  (std::string filename)
  {
    log_begin(Configuration,FUNCTION);

    _filename = filename;
    _array_param = new std::map<std::string, Parameter_definition *>;
    _array_link  = new std::map<std::string, Link_definition *>;

    fromFile (filename);

    log_end(Configuration,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Generator::~Generator"
  Generator::~Generator () 
  {
    log_begin(Configuration,FUNCTION);

    for (std::map<std::string, Parameter_definition *>::iterator it = _array_param->begin();
         it != _array_param->end();
         ++it)
      {
        delete it->second;
      }

    delete _array_param;

    for (std::map<std::string, Link_definition *>::iterator it = _array_link->begin();
         it != _array_link->end();
         ++it)
      {
        delete it->second;
      }

    delete _array_link;
    
    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
