/*
 * $Id: Generator_fromFile.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Generator.h"
#include "Common/include/FromString.h"
#include <fstream>

namespace morpheo {
namespace behavioural {
namespace configuration {

  using namespace XMLUtils;

#undef  FUNCTION
#define FUNCTION "Generator::fromFile"
  void Generator::fromFile (std::string filename)
  {
    log_begin(Configuration,FUNCTION);

    msg_printf(INFORMATION,_("Read file \"%s\"."),filename.c_str());

    std::ifstream file (filename.c_str());

    // Test the file open
    if (!file)
      throw ERRORMORPHEO(FUNCTION,toString(_("Error opening \"%s\" file.\n"),filename.c_str()));

    XML_t * _xml = new FileXMLLight<char,ClassicReferenceCounter>(file);

    // Test root node : Root name, must not a singleton, have none attribute
    testNodeName   (_xml,"parameters");
    testSingleton  (_xml,false);
    testNoAttribute(_xml);

    XMLLightVector<XML_t> vect = _xml->getNodes(); 

//     std::cout << vect << std::endl;

    for (uint32_t i=0; i<vect.size(); ++i)
      {
        XML_t * xml = vect[i];

        std::string node_name = xml->getName();

        //--------------------------------------
        // Node : Parameter
        //--------------------------------------
        if (node_name == "parameter")
          {
            testSingleton  (xml,true);        
            
            // Take attributes of this tag
            
            attributes_t attributes = xml->getAttributes();
            
//          std::cout << "Node [" << name           << "]" << std::endl;
//          std::cout << "  * nb attributes : " << xml->getAttributes().size()  << std::endl;
            
            attribute_t value_name        = getAttribute(xml,attributes,"name"   );
            attribute_t value_default     = getAttribute(xml,attributes,"default");
            attribute_t value_level       = (xml->containsAttribute("level"      ))?getAttribute(xml,attributes,"level"      ):"3";
            attribute_t value_description = (xml->containsAttribute("description"))?getAttribute(xml,attributes,"description"):"";
            
            bool is_binary = not (xml->containsAttribute("min" ) or
                                  xml->containsAttribute("max" ) or
                                  xml->containsAttribute("step"));
            
            attribute_t value_min         = (not is_binary)?getAttribute(xml,attributes,"min" ):"0";
            attribute_t value_max         = (not is_binary)?getAttribute(xml,attributes,"max" ):"1";
            attribute_t value_step        = (not is_binary)?getAttribute(xml,attributes,"step"):"+ 1";
            
            testAttributesEmpty(xml,attributes);
            
            // Insert in array
            Parameter_definition * param = new Parameter_definition(value_name       ,
                                                                    value_min        ,
                                                                    value_max        ,
                                                                    value_step       ,
                                                                    value_default    ,
                                                                    value_level      ,
                                                                    value_description);
            
            insert(param);
          }
        else
        //--------------------------------------
        // Node : Link
        //--------------------------------------
        if (node_name == "link")
          {
            testSingleton  (xml,true);        
            
            // Take attributes of this tag
            
            attributes_t attributes = xml->getAttributes();
            
//          std::cout << "Node [" << name           << "]" << std::endl;
//          std::cout << "  * nb attributes : " << xml->getAttributes().size()  << std::endl;
            
            attribute_t value_name        = getAttribute(xml,attributes,"name");
            attribute_t value_src         = getAttribute(xml,attributes,"src" );
            attribute_t value_dest        = (xml->containsAttribute("dest"       ))?getAttribute(xml,attributes,"dest"       ):"";
            attribute_t value_description = (xml->containsAttribute("description"))?getAttribute(xml,attributes,"description"):"";
            
            testAttributesEmpty(xml,attributes);
            
            // Insert in array
            Link_definition * param = new Link_definition(value_name       ,
                                                          value_src        ,
                                                          value_dest       ,
                                                          value_description);
            
            insert(param);
          }
        //--------------------------------------
        // Node : Unknow
        //--------------------------------------
        else
          throw ERRORMORPHEO(FUNCTION,toString(_("Syntax error, node \"%s\" is unknow.\n"),node_name.c_str()));
      }
         
    delete _xml;

    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
