/*
 * $Id: Instance_link2array.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Instance.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Instance::link2array"
  std::vector<std::string> Instance::link2array (std::string str)
  {
    log_begin(Configuration,FUNCTION);

    std::vector<std::string> _return;

    size_t begin=0;
    size_t end  =0;
    
    do
      {
        end = str.find_first_of(".",begin); // "." is the separator
        
        _return.push_back(str.substr(begin, end-begin));
        
        begin = end+1; // next index
      }
    while (end!=std::string::npos);

    log_end(Configuration,FUNCTION);

    return _return;
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
