/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Core_Glue/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {


#undef  FUNCTION
#define FUNCTION "Core_Glue::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Core_Glue,FUNCTION);

    Parameters_test test ("Core_Glue");

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        if (_translate_ooo_engine_num_front_end [i][j] > _nb_front_end)
          test.error(_("Translation in ooo_engine of front_end id is an invalid id.\n"));

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_execute_loop[i]; ++j)
        if (_translate_ooo_engine_num_execute_loop [i][j] > _nb_execute_loop)
          test.error(_("Translation in ooo_engine of execute_loop id is an invalid id.\n"));

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_ooo_engine[i]; ++j)
        if (_translate_execute_loop_num_ooo_engine [i][j] > _nb_ooo_engine)
          test.error(_("Translation in execute_loop of ooo_engine id is an invalid id.\n"));

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_ooo_engine_nb_front_end[i]; ++j)
        {
          uint32_t num_front_end = _translate_ooo_engine_num_front_end [i][j];

          if (_front_end_nb_inst_branch_complete [num_front_end] != _ooo_engine_nb_inst_branch_complete [i])
            test.error(toString(_("front_end[%d].nb_inst_branch_complete must be equal at ooo_engine[%d].nb_inst_branch_complete.\n"),num_front_end,i));
        }

    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      for (uint32_t j=0; j<_execute_loop_nb_ooo_engine[i]; ++j)
        {
          Tcontext_t num_ooo_engine = _translate_execute_loop_num_ooo_engine [i][j];
          for (uint32_t k=0; k<_ooo_engine_nb_execute_loop[num_ooo_engine]; ++k)
            if (_translate_ooo_engine_num_execute_loop [num_ooo_engine][k] == i)
              if (_nb_inst_execute[num_ooo_engine][k] != _nb_write_unit [i])
            test.error(toString(_("ooo_engine[%d][%d].nb_inst_execute must be equal at execute_loop[%d].nb_write_unit.\n"),num_ooo_engine,k,i));
        }
    log_end(Core_Glue,FUNCTION);

    return test;
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
