/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Icache_Access/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace icache_access {


#undef  FUNCTION
#define FUNCTION "Icache_Access::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Icache_Access,FUNCTION);

    XML xml ("icache_access");

    xml.balise_open("icache_access");
    xml.singleton_begin("nb_front_end           "); xml.attribut("value",toString(_nb_front_end           )); xml.singleton_end();
    xml.singleton_begin("nb_icache_port         "); xml.attribut("value",toString(_nb_icache_port         )); xml.singleton_end();
    xml.singleton_begin("size_address           "); xml.attribut("value",toString(_size_address           )); xml.singleton_end();
    xml.singleton_begin("priority               "); xml.attribut("value",toString(_priority               )); xml.singleton_end();
    xml.singleton_begin("load_balancing         "); xml.attribut("value",toString(_load_balancing         )); xml.singleton_end();
    for (uint32_t i=0;i<_nb_front_end; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","front_end");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
	xml.singleton_begin("nb_context             "); xml.attribut("value",toString(_nb_context             [i])); xml.singleton_end();

	for (uint32_t j=0;j<_nb_context [i]; j++)
	  {
	    xml. balise_open_begin("component");
	    xml.  attribut("type","context");
	    xml.  attribut("id"  ,toString(j));
	    xml. balise_open_end();
	    xml.singleton_begin("nb_instruction         "); xml.attribut("value",toString(_nb_instruction         [i][j])); xml.singleton_end();
	    xml.singleton_begin("size_packet_id         "); xml.attribut("value",toString(_size_packet_id         [i][j])); xml.singleton_end();
	    xml.singleton_begin("table_routing          "); xml.attribut("value",toString(_table_routing          [i][j])); xml.singleton_end();
	    xml. balise_close();
	  }
        xml. balise_close();
      }

    xml.balise_close();

    log_end(Icache_Access,FUNCTION);
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Icache_Access::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::icache_access::Parameters & x)
  {
    log_begin(Icache_Access,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Icache_Access,FUNCTION);

    return output_stream;
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
