/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


  Parameters::Parameters (uint32_t size_queue         ,
			  uint32_t nb_context         ,
			  uint32_t nb_front_end       ,
			  uint32_t nb_ooo_engine      ,
			  uint32_t nb_packet          ,
			  uint32_t size_general_data  ,
			  uint32_t size_special_data  ,
			  uint32_t nb_general_register,
			  uint32_t nb_special_register,
			  uint32_t nb_gpr_write       ,
			  uint32_t nb_spr_write       ,
			  uint32_t size_store_queue   ,
			  uint32_t size_load_queue    ,
                          bool     is_toplevel)
  {
    log_printf(FUNC,Read_queue,"Parameters","Begin");

    _size_queue              = size_queue           ;
    _nb_context              = nb_context           ;
    _nb_front_end            = nb_front_end         ;
    _nb_ooo_engine           = nb_ooo_engine        ;
    _nb_packet               = nb_packet            ;
    _nb_general_register     = nb_general_register  ;
    _nb_special_register     = nb_special_register  ;
    _nb_gpr_write            = nb_gpr_write         ;
    _nb_spr_write            = nb_spr_write         ;
                             
    _nb_gpr_read             = 2                    ;
    _nb_spr_read             = 1                    ;

    _size_internal_queue     = (  log2(nb_context         ) //_context_id   
                                + log2(nb_front_end       ) //_front_end_id 
                                + log2(nb_ooo_engine      ) //_ooo_engine_id
                                + log2(nb_packet          ) //_rob_id       
                                + _size_operation           //_operation    
                                + _size_type                //_type         
                                + log2(size_store_queue   ) //_store_queue_ptr_write
                                + log2(size_load_queue    ) //_load_queue_ptr_write 
                                + 1                         //_has_immediat 
                                +  size_general_data        //_immediat     
                                + 1                         //_read_ra      
                                + log2(nb_general_register) //_num_reg_ra   
                                + 1                         //_read_rb      
                                + log2(nb_general_register) //_num_reg_rb   
                                + 1                         //_read_rc      
                                + log2(nb_special_register) //_num_reg_rc   
                                + 1                         //_write_rd     
                                + log2(nb_general_register) //_num_reg_rd   
                                + 1                         //_write_re     
                                + log2(nb_special_register) //_num_reg_re   
				);

    test();

    if (is_toplevel)
      {
        _size_general_data       = size_general_data    ;
        _size_special_data       = size_special_data    ;
        _size_store_queue_ptr    = log2(size_store_queue);
        _size_load_queue_ptr     = log2(size_load_queue );
        _size_context_id         = log2(_nb_context         );
        _size_front_end_id       = log2(_nb_front_end       );
        _size_ooo_engine_id      = log2(_nb_ooo_engine      );
        _size_rob_ptr            = log2(_nb_packet          );
        _size_general_register   = log2(_nb_general_register);
        _size_special_register   = log2(_nb_special_register);
        
        _have_port_context_id    = _size_context_id    > 0;
        _have_port_front_end_id  = _size_front_end_id  > 0;
        _have_port_ooo_engine_id = _size_ooo_engine_id > 0;
        _have_port_rob_ptr       = _size_rob_ptr       > 0;
        _have_port_load_queue_ptr= _size_load_queue_ptr> 0;
        
        copy();
      }

    log_printf(FUNC,Read_queue,"Parameters","End");
  };
  
//   Parameters::Parameters (Parameters & param):
//     _size_queue            (param._size_queue            ),
//     _nb_context            (param._nb_context            ),
//     _nb_front_end          (param._nb_front_end          ),
//     _nb_ooo_engine         (param._nb_ooo_engine         ),
//     _nb_packet             (param._nb_packet             ),
//     _size_general_data     (param._size_general_data     ),
//     _size_special_data     (param._size_special_data     ),
//     _nb_general_register   (param._nb_general_register   ),
//     _nb_special_register   (param._nb_special_register   ),
//     _nb_gpr_write          (param._nb_gpr_write          ),
//     _nb_spr_write          (param._nb_spr_write          ),
//     _size_store_queue      (param._size_store_queue      ),
//     _size_load_queue       (param._size_load_queue       ),

//     _nb_gpr_read           (param._nb_gpr_read           ),
//     _nb_spr_read           (param._nb_spr_read           ),
//     _size_context_id       (param._size_context_id       ),
//     _size_front_end_id     (param._size_front_end_id     ),
//     _size_ooo_engine_id    (param._size_ooo_engine_id    ),
//     _size_rob_id           (param._size_rob_id           ),
//     _size_general_register (param._size_general_register ),
//     _size_special_register (param._size_special_register ),

//     _have_port_context_id    (param._have_port_context_id   ),
//     _have_port_front_end_id  (param._have_port_front_end_id ),
//     _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
//     _have_port_rob_id        (param._have_port_rob_id       ),
//     _have_port_load_queue_ptr(param._have_port_load_queue_ptr),

//     _size_internal_queue     (param._size_internal_queue    )
//   {
//     log_printf(FUNC,Read_queue,"Parameters (copy)","Begin");
//     test();
//     log_printf(FUNC,Read_queue,"Parameters (copy)","End");
//   };

  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Read_queue,"~Parameters","Begin");
    log_printf(FUNC,Read_queue,"~Parameters","End");
  };

  void Parameters::copy (void) 
  {
    log_printf(FUNC,Read_queue,"copy","Begin");
    log_printf(FUNC,Read_queue,"copy","End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
