#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_branch_target_buffer_glue_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_branch_target_buffer_glue_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"
#include "Behavioural/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t   _max_nb_instruction;
  public : uint32_t   _size_buffer       ;
  public : uint32_t   _associativity     ;
//public : uint32_t   _size_address      ;
  public : uint32_t   _nb_inst_predict   ;
  public : uint32_t   _nb_inst_decod     ;
  public : uint32_t   _nb_inst_update    ;

  public : uint32_t   _size_bank         ;
  public : uint32_t   _size_victim       ;
  public : uint32_t   _size_victim_address;

  public : bool       _have_port_victim    ;
  public : bool       _is_full_associative ;

  public : Tgeneral_data_t _mask_bank ;
  public : Tgeneral_data_t _shift_bank;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t   max_nb_instruction,
			uint32_t   size_buffer       ,
			uint32_t   associativity     ,
			uint32_t   size_address      ,
			uint32_t   nb_inst_predict   ,
			uint32_t   nb_inst_decod     ,
			uint32_t   nb_inst_update    ,
                        bool       is_toplevel=false
                        );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_glue::Parameters & x);
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
