/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Parameters.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::Parameters"
  Parameters::Parameters (uint32_t   max_nb_instruction,
			  uint32_t   size_buffer       ,
			  uint32_t   associativity     ,
			  uint32_t   size_address      ,
			  uint32_t   nb_inst_predict   ,
			  uint32_t   nb_inst_decod     ,
			  uint32_t   nb_inst_update    ,
                          bool       is_toplevel)
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");

    _max_nb_instruction     = max_nb_instruction;
    _size_buffer            = size_buffer       ;
    _associativity          = associativity     ;
//  _size_address           = size_address      ;
    _nb_inst_predict        = nb_inst_predict   ;
    _nb_inst_decod          = nb_inst_decod     ;
    _nb_inst_update         = nb_inst_update    ;

    _size_bank              = size_buffer/associativity;
    _size_victim            = log2(associativity);
    _size_victim_address    = log2(_size_bank);

    _have_port_victim       = (_size_victim     > 0);
    _is_full_associative    = _size_bank == 1;

    _mask_bank              = gen_mask<Tgeneral_data_t> (_size_victim_address);
    _shift_bank             = log2(max_nb_instruction)+2;

    test();

    if (is_toplevel)
      {
        _size_instruction_address = size_address;

        copy();
      }

    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Branch_Target_Buffer_Glue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
