/*
 * $Id: Direction_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/include/Direction.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {



#undef  FUNCTION
#define FUNCTION "Direction::allocation"
  void Direction::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_printf(FUNC,Direction,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Direction"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("predict", IN, SOUTH, "Interface predict",_param->_nb_inst_predict);

      ALLOC1_VALACK_IN ( in_PREDICT_VAL        ,VAL);
      ALLOC1_VALACK_OUT(out_PREDICT_ACK        ,ACK);
      ALLOC1_SIGNAL_IN ( in_PREDICT_ADDRESS_SRC,"address_src",Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_PREDICT_STATIC     ,"static"     ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_PREDICT_LAST_TAKE  ,"last_take"  ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_PREDICT_HISTORY    ,"history"    ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_OUT(out_PREDICT_DIRECTION  ,"direction"  ,Tcontrol_t,1);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("update", IN, SOUTH, "Interface update",_param->_nb_inst_update);

      ALLOC1_VALACK_IN ( in_UPDATE_VAL      ,VAL);
      ALLOC1_VALACK_OUT(out_UPDATE_ACK      ,ACK);
      ALLOC1_SIGNAL_IN ( in_UPDATE_ADDRESS  ,"address"  ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_UPDATE_HISTORY  ,"history"  ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_IN ( in_UPDATE_DIRECTION,"direction",Tcontrol_t,1);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    std::string name;

    {
      name = _name+"_glue";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_glue = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::direction_glue::Direction_Glue
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_glue
	 ,_usage);
      
      _component->set_component (_component_glue->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }
    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;
    
    {
      src = _name+"_glue";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Instance : %s"),src.c_str());
      
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif

	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"predict_"+toString(i),
				     dest,"predict_"+toString(i));
#endif
	  
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_VAL"        ,
		              dest, "in_PREDICT_"+toString(i)+"_VAL"        );
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_ACK"        ,
		              dest,"out_PREDICT_"+toString(i)+"_ACK"        );
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_ADDRESS_SRC",
		              dest, "in_PREDICT_"+toString(i)+"_ADDRESS_SRC");
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_STATIC"     ,
		              dest, "in_PREDICT_"+toString(i)+"_STATIC"     );
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_LAST_TAKE"  ,
		              dest, "in_PREDICT_"+toString(i)+"_LAST_TAKE"  );
	  if (_param->_have_port_history)
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_HISTORY"    ,
		              dest,"out_PREDICT_"+toString(i)+"_HISTORY"    );
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_DIRECTION"  ,
		              dest,"out_PREDICT_"+toString(i)+"_DIRECTION"  );

// 	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_PREDICTOR_VAL"        ,dest,"out_PREDICT_"+toString(i)+"_PREDICTOR_VAL"        );
// 	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_PREDICTOR_ACK"        ,dest, "in_PREDICT_"+toString(i)+"_PREDICTOR_ACK"        );
// 	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_PREDICTOR_ADDRESS_SRC",dest,"out_PREDICT_"+toString(i)+"_PREDICTOR_ADDRESS_SRC");
// 	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_PREDICTOR_HISTORY"    ,dest, "in_PREDICT_"+toString(i)+"_PREDICTOR_HISTORY"    );
// 	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_PREDICTOR_DIRECTION"  ,dest, "in_PREDICT_"+toString(i)+"_PREDICTOR_DIRECTION"  );
	}
      
      for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"update_"+toString(i),
				     dest,"update_"+toString(i));
#endif

	  PORT_MAP(_component,src , "in_UPDATE_"+toString(i)+"_VAL"      ,
		              dest, "in_UPDATE_"+toString(i)+"_VAL"      );
	  PORT_MAP(_component,src ,"out_UPDATE_"+toString(i)+"_ACK"      ,
		              dest,"out_UPDATE_"+toString(i)+"_ACK"      );
	  PORT_MAP(_component,src , "in_UPDATE_"+toString(i)+"_ADDRESS"  ,
		              dest, "in_UPDATE_"+toString(i)+"_ADDRESS"  );
	  if (_param->_have_port_history)
	  PORT_MAP(_component,src , "in_UPDATE_"+toString(i)+"_HISTORY"  ,
		              dest, "in_UPDATE_"+toString(i)+"_HISTORY"  );
	  PORT_MAP(_component,src , "in_UPDATE_"+toString(i)+"_DIRECTION",
		              dest, "in_UPDATE_"+toString(i)+"_DIRECTION");
// 	  PORT_MAP(_component,src ,"out_UPDATE_"+toString(i)+"_PREDICTOR_VAL"      ,dest,"out_UPDATE_"+toString(i)+"_PREDICTOR_VAL"      );
// 	  PORT_MAP(_component,src , "in_UPDATE_"+toString(i)+"_PREDICTOR_ACK"      ,dest, "in_UPDATE_"+toString(i)+"_PREDICTOR_ACK"      );
// 	  PORT_MAP(_component,src ,"out_UPDATE_"+toString(i)+"_PREDICTOR_ADDRESS"  ,dest,"out_UPDATE_"+toString(i)+"_PREDICTOR_ADDRESS"  );
// 	  PORT_MAP(_component,src ,"out_UPDATE_"+toString(i)+"_PREDICTOR_HISTORY"  ,dest,"out_UPDATE_"+toString(i)+"_PREDICTOR_HISTORY"  );
// 	  PORT_MAP(_component,src ,"out_UPDATE_"+toString(i)+"_PREDICTOR_DIRECTION",dest,"out_UPDATE_"+toString(i)+"_PREDICTOR_DIRECTION");
      }
    }
    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
//      _component->test_map();

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Direction,FUNCTION,"End");
  };

}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
