#ifdef SYSTEMC
/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::genMealy_predict"
  void Update_Prediction_Table::genMealy_predict (void)
  {
    log_begin(Update_Prediction_Table,FUNCTION);
    log_function(Update_Prediction_Table,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) != 0)
      {

    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
      {
	Tcontext_t context = (_param->_have_port_context_id)?PORT_READ(in_PREDICT_CONTEXT_ID [i]):0;
	uint32_t   top     = reg_UFPT_TOP[context];

	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"PREDICT [%d] (genMealy)",i);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * context     : %d",context);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * top         : %d",top);
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * state       : %s",toString(reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._state).c_str());
	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * is accurate : %d",PORT_READ(in_PREDICT_BTB_IS_ACCURATE [i]));
// 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * need update : %d",reg_NB_ELT_NEED_UPDATE [context]);

        internal_PREDICT_UPDATE_PREDICTION_ID [i] = top;

        if (_param->_have_port_depth)
        PORT_WRITE(out_PREDICT_UPDATE_PREDICTION_ID [i], internal_PREDICT_UPDATE_PREDICTION_ID [i]);

        bool is_accurate = not _param->_not_accurate_block_predict or reg_IS_ACCURATE[context];

        // Ack if :
        //  * slot is empty
        //  * no previous miss
        //  * is_accurate
	internal_PREDICT_ACK [i] = ((reg_UPDATE_FETCH_PREDICTION_TABLE [context][top]._state == UPDATE_FETCH_PREDICTION_STATE_EMPTY) and
// 				    PORT_READ(in_PREDICT_BTB_IS_ACCURATE [i]) and
 				    (reg_EVENT_STATE [context] == EVENT_STATE_OK) and
                                    is_accurate);


 	log_printf(TRACE,Update_Prediction_Table,FUNCTION,"  * ACK         : %d",internal_PREDICT_ACK [i]);
	PORT_WRITE(out_PREDICT_ACK [i], internal_PREDICT_ACK [i]);
      }

      }//don't reset

    log_end(Update_Prediction_Table,FUNCTION);
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
