#ifdef STATISTICS
/*
 * $Id: Reexecute_unit_statistics_allocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Reexecute_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


#undef  FUNCTION
#define FUNCTION "Reexecute_unit::statistics_allocation"
  void Reexecute_unit::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_begin(Reexecute_unit,FUNCTION);

    _stat = new Stat (static_cast<std::string>(_name),
		      "Reexecute_unit",
		      param_statistics);

    _stat_bank_nb_inst     = new counter_t * [_param->_nb_bank];

    // bank/queue occupation
    {
      std::string sum_bank_nb_inst = "";
      for (uint32_t i=0; i<_param->_nb_bank; i++)
	{
	  _stat_bank_nb_inst [i] = _stat->create_variable("bank_nb_inst_"+toString(i));
	  
	  _stat->create_expr_average_by_cycle("average_occupation_bank_"+toString(i), "bank_nb_inst_"+toString(i), "", toString(_("Average instruction by cycle (bank %d)"),i));
	  _stat->create_expr_percent         ("percent_occupation_bank_"+toString(i), "average_occupation_bank_"+toString(i), toString(_param->_size_bank), toString(_("Percent occupation of bank (bank %d)"),i));
	  
	  if (i == 0)
	    sum_bank_nb_inst = "bank_nb_inst_"+toString(i);
	  else
	    sum_bank_nb_inst = "+ bank_nb_inst_"+toString(i) + " " +sum_bank_nb_inst;
	}
      
      _stat->create_expr_average_by_cycle("average_occupation_bank", sum_bank_nb_inst, "", _("Average instruction by cycle (all bank)"));
      _stat->create_expr_percent         ("percent_occupation_bank" , "average_occupation_bank", toString(_param->_size_queue), _("Percent occupation of reexecute_queue (all bank)"));
    }


    _stat_nb_inst_reexecute = _stat->create_variable("nb_inst_reexecute");
    _stat_nb_inst_commit    = _stat->create_variable("nb_inst_commit");
    _stat_nb_spr_access     = _stat->create_variable("nb_spr_access");

    _stat->create_expr_average_by_cycle("average_inst_commit"   , "nb_inst_commit"   , "", _("Average instruction commited by cycle"));
    _stat->create_expr_average_by_cycle("average_inst_reexecute", "nb_inst_reexecute", "", _("Average instruction reexecuted by cycle"));
    _stat->create_expr_average_by_cycle("average_spr_access"    , "nb_spr_access"    , "", _("Average spr access by cycle"));

    _stat->create_expr_percent         ("percent_use_interface_commit"    , "average_inst_commit"   , toString(_param->_nb_inst_commit   ), _("Percent usage of commit interface"));
    _stat->create_expr_percent         ("percent_use_interface_reexecute" , "average_inst_reexecute", toString(_param->_nb_inst_reexecute), _("Percent usage of reexecute interface"));
    _stat->create_expr_percent         ("percent_use_interface_spr"       , "average_spr_access"    , toString(_param->_nb_inst_reexecute), _("Percent usage of spr interface"));
    
    log_end(Reexecute_unit,FUNCTION);
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
