#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_stat_list_unit_Parameters_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_stat_list_unit_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t   _nb_front_end          ;
  public : uint32_t * _nb_context            ;//[nb_front_end]
  public : uint32_t   _nb_general_register   ;
  public : uint32_t   _nb_special_register   ;
  public : uint32_t   _nb_inst_insert        ;
  public : uint32_t   _nb_inst_retire        ;
  public : uint32_t   _nb_reg_free           ;
  public : uint32_t   _nb_bank               ;
  public : uint32_t   _size_counter          ;

//public : uint32_t   _size_general_register ;
//public : uint32_t   _size_special_register ;
		      
  public : uint32_t   _max_reader            ;
  public : uint32_t   _nb_gpr_use_init       ;
  public : uint32_t   _nb_spr_use_init       ;

  public : uint32_t   _nb_general_register_by_bank;
  public : uint32_t   _nb_special_register_by_bank;

  public : uint32_t   _nb_bank_by_port_free  ;

  public : uint32_t   _shift_gpr;
  public : uint32_t   _shift_spr;

  public : Tgeneral_address_t _mask_gpr;
  public : Tspecial_address_t _mask_spr;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t   nb_front_end          ,
			uint32_t * nb_context            ,
			uint32_t   nb_general_register   ,
			uint32_t   nb_special_register   ,
			uint32_t   nb_inst_insert        ,
			uint32_t   nb_inst_retire        ,
			uint32_t   nb_reg_free           ,
			uint32_t   nb_bank               ,
			uint32_t   size_counter          ,
                        bool       is_toplevel=false
                        );

//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::stat_list_unit::Parameters & x);
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
