#ifndef morpheo_behavioural_generic_priority_Priority_h
#define morpheo_behavioural_generic_priority_Priority_h

/*
 * $Id: Priority.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Priority/include/Types.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include <list>
#include <iostream>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace priority {


  class Priority 
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected: const std::string   _name          ;
  private  : Tpriority_t         _priority      ;
  private  : Tload_balancing_t   _load_balancing;
  private  : uint32_t            _nb_grp        ;
  private  : uint32_t          * _nb_elt        ;//[nb_grp]
  private  : uint32_t            _nb_grp_select ;
  private  : uint32_t            _max_nb_elt    ;

  private  : void (morpheo::behavioural::generic::priority::Priority::*reset_priority           ) (void);
  private  : void (morpheo::behavioural::generic::priority::Priority::*reset_load_balancing     ) (void);

  private  : void (morpheo::behavioural::generic::priority::Priority::*transition_priority      ) (void);
  private  : void (morpheo::behavioural::generic::priority::Priority::*transition_load_balancing) (void);

  private  : uint32_t            reg_GRP_PRIORITY;
  private  : std::list<select_t> _select;

    // -----[ method ]----------------------------------------------------
  public  :           Priority (std::string       name,
				Tpriority_t       priority      ,
				Tload_balancing_t load_balancing,
				uint32_t          nb_grp        ,
				uint32_t        * nb_elt        ,//[nb_grp]
				uint32_t          nb_grp_select
				);
  public  :           Priority (std::string       name,
				Tpriority_t       priority      ,
				uint32_t          nb_grp        ,
				uint32_t          nb_grp_select
				);

  public  :           Priority (std::string       name,
				Tpriority_t       priority      ,
				uint32_t          nb_grp        
				);

  public  :          ~Priority (void);

  public  : void     allocation                                     (void);
  public  : void     deallocation                                   (void);
					       
  public  : void     reset                                          (void);
  public  : void     transition                                     (void);

  public  : void     reset_priority_none                            (void);
  public  : void     reset_priority_static                          (void);
  public  : void     reset_priority_round_robin                     (void);

  public  : void     reset_load_balancing_none                      (void);
  public  : void     reset_load_balancing_priority_only             (void);
  public  : void     reset_load_balancing_balance                   (void);
  public  : void     reset_load_balancing_maximum_for_priority      (void);

  public  : void     transition_priority_none                       (void);
  public  : void     transition_priority_static                     (void);
  public  : void     transition_priority_round_robin                (void);

  public  : void     transition_load_balancing_none                 (void);
  public  : void     transition_load_balancing_priority_only        (void);
  public  : void     transition_load_balancing_balance              (void);
  public  : void     transition_load_balancing_maximum_for_priority (void);

  public  : std::list<select_t> * select (void);
  };

}; // end namespace priority
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
