/*
 * $Id: Priority.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Priority/include/Priority.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace priority {
  
#undef  FUNCTION
#define FUNCTION "Priority::Priority"
  Priority::Priority (std::string       name,
		      Tpriority_t       priority      ,
		      Tload_balancing_t load_balancing,
		      uint32_t          nb_grp        ,
		      uint32_t        * nb_elt        ,//[nb_grp]
		      uint32_t          nb_grp_select
		      ):
    _name              (name)
  {
    log_begin(Priority,FUNCTION);

    _priority       = priority      ;
    _load_balancing = load_balancing;
    _nb_grp         = nb_grp        ;
    _nb_elt         = nb_elt     ;
    _nb_grp_select  = nb_grp_select ;
    _max_nb_elt     = max<uint32_t>(_nb_elt,_nb_grp);

    allocation();

    log_end(Priority,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Priority::Priority"
  Priority::Priority (std::string       name,
		      Tpriority_t       priority      ,
		      uint32_t          nb_grp        ,
		      uint32_t          nb_grp_select
		      ):
    _name              (name)
  {
    log_begin(Priority,FUNCTION);

    _priority       = priority   ;
    _load_balancing = LOAD_BALANCING_MAXIMUM_FOR_PRIORITY;
    _nb_grp         = nb_grp     ;
//  _nb_elt         = nb_elt     ;
    _nb_grp_select  = nb_grp_select ;
    _max_nb_elt     = 1;

    allocation();

    log_end(Priority,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Priority::Priority"
  Priority::Priority (std::string       name,
		      Tpriority_t       priority      ,
		      uint32_t          nb_grp        
		      ):
    _name              (name)
  {
    log_begin(Priority,FUNCTION);

    _priority       = priority   ;
    _load_balancing = LOAD_BALANCING_MAXIMUM_FOR_PRIORITY;
    _nb_grp         = nb_grp     ;
//  _nb_elt         = nb_elt     ;
    _nb_grp_select  = nb_grp     ;
    _max_nb_elt     = 1;

    allocation();

    log_end(Priority,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Priority::~Priority"
  Priority::~Priority (void)
  {
    log_begin(Priority,FUNCTION);

    deallocation ();

    log_end(Priority,FUNCTION);
  };

}; // end namespace priority
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
