#ifndef morpheo_behavioural_generic_victim_Parameters_h
#define morpheo_behavioural_generic_victim_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/Victim/include/Types.h"

// #include "Behavioural/Generic/Victim/Victim_Random/include/Parameters.h"
// #include "Behavioural/Generic/Victim/Victim_Round_Robin/include/Parameters.h"
// #include "Behavioural/Generic/Victim/Victim_NLU/include/Parameters.h"
#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Parameters.h"
// #include "Behavioural/Generic/Victim/Victim_LRU/include/Parameters.h"
// #include "Behavioural/Generic/Victim/Victim_FIFO/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : Tvictim_t _victim_scheme    ; // Scheme to select the victim
  public : uint32_t  _nb_entity        ; // number of entity
  public : uint32_t  _nb_entry         ; // number of entry
  public : uint32_t  _nb_access        ; // number of port to select an entity
  public : bool      _table_global     ; // Have one table or one by entry

  public : uint32_t  _size_entity      ;
  public : uint32_t  _size_table       ; // Size of internal table
  public : uint32_t  _size_address     ;

  public : bool      _have_port_address;

//public : morpheo::behavioural::generic::victim::victim_random     ::Parameters * _param_victim_random     ;
//public : morpheo::behavioural::generic::victim::victim_round_robin::Parameters * _param_victim_round_robin;
//public : morpheo::behavioural::generic::victim::victim_nlu        ::Parameters * _param_victim_nlu        ;
  public : morpheo::behavioural::generic::victim::victim_pseudo_lru ::Parameters * _param_victim_pseudo_lru ;
//public : morpheo::behavioural::generic::victim::victim_lru        ::Parameters * _param_victim_lru        ;
//public : morpheo::behavioural::generic::victim::victim_fifo       ::Parameters * _param_victim_fifo       ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (Tvictim_t victim_scheme    ,
			uint32_t  nb_entity        ,
			uint32_t  nb_entry         ,
			uint32_t  nb_access        ,
			bool      table_global     );
//public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					      morpheo::behavioural::generic::victim::Parameters & x);
  };

}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
