#ifdef STATISTICS
#include "Behavioural/include/Stat_binary_tree.h"

namespace morpheo {
namespace behavioural {

  void Stat_binary_tree::change_type (counter_t   cst)
  {
    if (_data_type != NONE)
      throw (ERRORMORPHEO("Stat_binary_tree::change_type",_("To change type, data_type must be \'NONE\'.\n")));

    _data_type = CONSTANT;
    _data.cst  = cst;
  }

  void Stat_binary_tree::change_type (counter_t * var)
  {
    if (_data_type != NONE)
      throw (ERRORMORPHEO("Stat_binary_tree::change_type",_("To change type, data_type must be \'NONE\'.\n")));

    _data_type = VARIABLE;
    _data.var  = var;
  }

  void Stat_binary_tree::change_type (operator_t  op )
  {
    if (_data_type != NONE)
      throw (ERRORMORPHEO("Stat_binary_tree::change_type",_("To change type, data_type must be \'NONE\'.\n")));

    _data_type = ((op == inc) or (op == dec))?OPERATOR_UNARY:OPERATOR_BINARY;
    _data.op   = op;
  }
};
};
#endif
