/********************************************
 * files               : asm_011_sfleu.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/22
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                : test l.sfleu
 * warning             : instruction ok 
 *                         l.addi
 *                         l.and
 *                         l.bf
 *                         l.bnf
 *                         l.movhi
 *                         l.jal
 *                         l.jr
 *		           l.lwz
 *                         l.ori
 *                         l.sw
 ********************************************
 */
	.file	"asm_011_sfleu.s"
	.section .text
	.align	4

	.global _asm_011_sfleu
_asm_011_sfleu :	
	/* save context */
	l.addi	r1,r1,-8
	l.sw	0 (r1),r21
	l.sw	4 (r1),r22
	/* Return is KO (default)*/
	l.and   r11,r0,r0

	/* Listing of test
			|	R	I	I
	Op1	Op2	|	F1	F2	F3
	----------------+-------------------------------
	+	+=	|	1	0	1
	+	+>	|	1	0	1
	+	+<	|	0	0	0
	+	-	|	1	1	1
	-	-=	|	1	1	1
	-	->	|	1	1	1
	-	-<	|	0	0	1

	Op1 with :
	Value on 32 bits		(result F1)
	Value on 16 bits - extend 1	(result F2)
	                 - extend 0	(result F3)
	 */

	/*************************/
	/* F1 :	VALUE ON 32 BITS */
	/*************************/
	
	/* Op1 : + */
	l.movhi	r21,0x7ead
	l.ori   r21,r21,0xbeaf

	/* Op2 : += */
	l.movhi	r22,0x7ead
	l.ori   r22,r22,0xbeaf
	
	l.sfleu	r21,r22
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	1

	/* Op2 : +> */
	l.movhi	r22,0x7ead
	l.ori   r22,r22,0xbfaf

	l.sfleu	r21,r22
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	2
	
	/* Op2 : +< */
	l.movhi	r22,0x7ead
	l.ori   r22,r22,0xbdaf

	l.sfleu	r21,r22
	l.bf	_asm_011_sfleu_ko	/* if     set :	error */
	l.nop	3

	/* Op2 : - */
	l.movhi	r22,0xdead
	l.ori   r22,r22,0xbeaf

	l.sfleu	r21,r22
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	4
	
	/* Op1 : - */
	l.movhi	r21,0xdead
	l.ori   r21,r21,0xbeaf

	/* Op2 : -= */
		
	l.sfleu	r21,r22
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	5

	/* Op2 : -> */
	l.movhi	r22,0xdead
	l.ori   r22,r22,0xbfaf

	l.sfleu	r21,r22
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	6
	
	/* Op2 : -< */
	l.movhi	r22,0xdead
	l.ori   r22,r22,0xbdaf

	l.sfleu	r21,r22
	l.bf	_asm_011_sfleu_ko	/* if     set :	error */
	l.nop	7

	/************************************/
	/* F2 :	VALUE ON 16 BITS - extend 1 */
	/************************************/
	/* Op1 : + */
	l.movhi	r21,0xFFFF
	l.ori   r21,r21,0x7ead

	/* Op2 : += */
	l.sfleui	r21,0x7ead
	l.bf 	_asm_011_sfleu_ko	/* if     set :	error */
	l.nop	1

	/* Op2 : +> */
	l.sfleui	r21,0x7ebd
	l.bf 	_asm_011_sfleu_ko	/* if     set :	error */
	l.nop	2
	
	/* Op2 : +< */
	l.sfleui	r21,0x7e9d
	l.bf 	_asm_011_sfleu_ko	/* if     set :	error */
	l.nop	3

	/* Op2 : - */
	l.sfleui	r21,0xdead
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	4
	
	/* Op1 : - */
	l.movhi	r21,0xFFFF
	l.ori   r21,r21,0xdead

	/* Op2 : -= */
	l.sfleui	r21,0xdead
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	5

	/* Op2 : -> */
	l.sfleui	r21,0xdebd
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	6
	
	/* Op2 : -< */
	l.sfleui	r21,0xde9d
	l.bf	_asm_011_sfleu_ko	/* if     set :	error */
	l.nop	7
	
	/************************************/
	/* F3 :	VALUE ON 16 BITS - extend 0 */
	/************************************/
	/* Op1 : + */
	l.movhi	r21,0x0000
	l.ori   r21,r21,0x7ead

	/* Op2 : += */
	l.sfleui	r21,0x7ead
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	1

	/* Op2 : +> */
	l.sfleui	r21,0x7ebd
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	2
	
	/* Op2 : +< */
	l.sfleui	r21,0x7e9d
	l.bf	_asm_011_sfleu_ko	/* if     set :	error */
	l.nop	3

	/* Op2 : - */
	l.sfleui	r21,0xdead
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	4
	
	/* Op1 : - */
	l.movhi	r21,0x0000
	l.ori   r21,r21,0xdead

	/* Op2 : -= */
	l.sfleui	r21,0xdead
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	5

	/* Op2 : -> */
	l.sfleui	r21,0xdebd
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	6
	
	/* Op2 : -< */
	l.sfleui	r21,0xde9d
	l.bnf	_asm_011_sfleu_ko	/* if not set :	error */
	l.nop	7
					
_asm_011_sfleu_ok :	
	l.addi	r11,r0,1
_asm_011_sfleu_ko :	
	/* load context */
	l.lwz	r22,4 (r1)
	l.lwz	r21,0 (r1)
	l.jr	r9
	l.addi	r1,r1,8
