#ifndef morpheo_behavioural_core_icache_access_Icache_Access_h
#define morpheo_behavioural_core_icache_access_Icache_Access_h

/*
 * $Id: Icache_Access.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * TODO : 
 * To implement icache special instruction (prefetch, invalidate, lock), add port here
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Icache_Access/include/Parameters.h"
#include "Behavioural/Core/Icache_Access/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Generic/Priority/include/Priority.h"

#include <iostream>

namespace morpheo {
namespace behavioural {
namespace core {
namespace icache_access {

  class Icache_Access 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

  private   : counter_t                     ** _stat_nb_access;
  private   : counter_t                     ** _stat_nb_access_conflit;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                         *  in_CLOCK ;
  public    : SC_IN (Tcontrol_t)               *  in_NRESET;

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           )   ** out_ICACHE_REQ_VAL         ;//[nb_icache_port]
  public    : SC_IN (Tcontrol_t           )   **  in_ICACHE_REQ_ACK         ;//[nb_icache_port]
  public    : SC_OUT(Tcontext_t           )   ** out_ICACHE_REQ_THREAD_ID   ;//[nb_icache_port]
  public    : SC_OUT(Tpacket_t            )   ** out_ICACHE_REQ_PACKET_ID   ;//[nb_icache_port]
  public    : SC_OUT(Ticache_address_t    )   ** out_ICACHE_REQ_ADDRESS     ;//[nb_icache_port]
  public    : SC_OUT(Ticache_type_t       )   ** out_ICACHE_REQ_TYPE        ;//[nb_icache_port]
									    
    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
  public    : SC_IN (Tcontrol_t           )   **  in_ICACHE_RSP_VAL         ;//[nb_icache_port]
  public    : SC_OUT(Tcontrol_t           )   ** out_ICACHE_RSP_ACK         ;//[nb_icache_port]
  public    : SC_IN (Tcontext_t           )   **  in_ICACHE_RSP_THREAD_ID   ;//[nb_icache_port]
  public    : SC_IN (Tpacket_t            )   **  in_ICACHE_RSP_PACKET_ID   ;//[nb_icache_port]
  public    : SC_IN (Ticache_instruction_t)  ***  in_ICACHE_RSP_INSTRUCTION ;//[nb_icache_port][icache_nb_instruction]
  public    : SC_IN (Ticache_error_t      )   **  in_ICACHE_RSP_ERROR       ;//[nb_icache_port]

    // ~~~~~[ Interface "context_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           )  ***  in_CONTEXT_REQ_VAL        ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tcontrol_t           )  *** out_CONTEXT_REQ_ACK        ;//[nb_front_end][nb_context]
//public    : SC_IN (Tcontext_t           )  ***  in_CONTEXT_REQ_THREAD_ID  ;//[nb_front_end][nb_context]
  public    : SC_IN (Tpacket_t            )  ***  in_CONTEXT_REQ_PACKET_ID  ;//[nb_front_end][nb_context]
  public    : SC_IN (Ticache_address_t    )  ***  in_CONTEXT_REQ_ADDRESS    ;//[nb_front_end][nb_context]
  public    : SC_IN (Ticache_type_t       )  ***  in_CONTEXT_REQ_TYPE       ;//[nb_front_end][nb_context]

    // ~~~~~[ Interface "context_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           )  *** out_CONTEXT_RSP_VAL        ;//[nb_front_end][nb_context]
  public    : SC_IN (Tcontrol_t           )  ***  in_CONTEXT_RSP_ACK        ;//[nb_front_end][nb_context]
//public    : SC_OUT(Tcontext_t           )  *** out_CONTEXT_RSP_THREAD_ID  ;//[nb_front_end][nb_context]
  public    : SC_OUT(Tpacket_t            )  *** out_CONTEXT_RSP_PACKET_ID  ;//[nb_front_end][nb_context]
  public    : SC_OUT(Ticache_instruction_t) **** out_CONTEXT_RSP_INSTRUCTION;//[nb_front_end][nb_context][nb_instruction]
  public    : SC_OUT(Ticache_error_t      )  *** out_CONTEXT_RSP_ERROR      ;//[nb_front_end][nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : generic::priority::Priority      * _priority;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifdef STATISTICS
  private   : uint32_t                         * _internal_ICACHE_REQ_NB_ACCESS        ; //[nb_icache_port]
  private   : uint32_t                         * _internal_ICACHE_REQ_NB_ACCESS_CONFLIT; //[nb_icache_port]
#endif

#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Icache_Access);
#endif
  public  :          Icache_Access              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Icache_Access             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);
  public  : void        genMealy_req              (void);
  public  : void        genMealy_rsp              (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
