/*
 * $Id: Icache_Access_deallocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Icache_Access/include/Icache_Access.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace icache_access {


#undef  FUNCTION
#define FUNCTION "Icache_Access::deallocation"
  void Icache_Access::deallocation (void)
  {
    log_begin(Icache_Access,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL(out_ICACHE_REQ_VAL         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL( in_ICACHE_REQ_ACK         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,_param->_nb_icache_port,_param->_size_icache_thread_id);
        DELETE1_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,_param->_nb_icache_port,_param->_size_icache_packet_id);
        DELETE1_SIGNAL(out_ICACHE_REQ_ADDRESS     ,_param->_nb_icache_port,_param->_size_address);
        DELETE1_SIGNAL(out_ICACHE_REQ_TYPE        ,_param->_nb_icache_port,_param->_size_icache_type);
  
        DELETE1_SIGNAL( in_ICACHE_RSP_VAL         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL(out_ICACHE_RSP_ACK         ,_param->_nb_icache_port,1);
        DELETE1_SIGNAL( in_ICACHE_RSP_THREAD_ID   ,_param->_nb_icache_port,_param->_size_icache_thread_id);
        DELETE1_SIGNAL( in_ICACHE_RSP_PACKET_ID   ,_param->_nb_icache_port,_param->_size_icache_packet_id);
        DELETE1_SIGNAL( in_ICACHE_RSP_ERROR       ,_param->_nb_icache_port,_param->_size_icache_error);
        DELETE2_SIGNAL( in_ICACHE_RSP_INSTRUCTION ,_param->_nb_icache_port,_param->_icache_nb_instruction[it1],_param->_size_instruction);
        
        DELETE2_SIGNAL( in_CONTEXT_REQ_VAL        ,_param->_nb_front_end, _param->_nb_context[it1],1                                );
        DELETE2_SIGNAL(out_CONTEXT_REQ_ACK        ,_param->_nb_front_end, _param->_nb_context[it1],1                                );
//      DELETE2_SIGNAL( in_CONTEXT_REQ_THREAD_ID                                                  ,_param->_size_);
        DELETE2_SIGNAL( in_CONTEXT_REQ_PACKET_ID  ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_packet_id[it1][it2]);
        DELETE2_SIGNAL( in_CONTEXT_REQ_ADDRESS    ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_address            );
        DELETE2_SIGNAL( in_CONTEXT_REQ_TYPE       ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_icache_type        );
        					                                                  
        DELETE2_SIGNAL(out_CONTEXT_RSP_VAL        ,_param->_nb_front_end, _param->_nb_context[it1],1                                );
        DELETE2_SIGNAL( in_CONTEXT_RSP_ACK        ,_param->_nb_front_end, _param->_nb_context[it1],1                                );
//      DELETE2_SIGNAL(out_CONTEXT_RSP_THREAD_ID  ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_                   );
        DELETE2_SIGNAL(out_CONTEXT_RSP_PACKET_ID  ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_packet_id[it1][it2]);
        DELETE2_SIGNAL(out_CONTEXT_RSP_ERROR      ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_icache_error       );
        DELETE3_SIGNAL(out_CONTEXT_RSP_INSTRUCTION,_param->_nb_front_end, _param->_nb_context[it1],_param->_nb_instruction[it1][it2],_param->_size_instruction        );

        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifdef STATISTICS
        delete [] _internal_ICACHE_REQ_NB_ACCESS        ;
        delete [] _internal_ICACHE_REQ_NB_ACCESS_CONFLIT;
#endif
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _priority;

    delete _component;

    log_end(Icache_Access,FUNCTION);
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
