/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    XML xml ("update_prediction_table");

    xml.balise_open("update_prediction_table");
    xml.singleton_begin("nb_context             "); xml.attribut("value",toString(_nb_context             )); xml.singleton_end();
//  xml.singleton_begin("size_address           "); xml.attribut("value",toString(_size_address           )); xml.singleton_end();
    xml.singleton_begin("nb_inst_predict        "); xml.attribut("value",toString(_nb_inst_predict        )); xml.singleton_end();
    xml.singleton_begin("nb_inst_decod          "); xml.attribut("value",toString(_nb_inst_decod          )); xml.singleton_end();
    xml.singleton_begin("nb_inst_branch_complete"); xml.attribut("value",toString(_nb_inst_branch_complete)); xml.singleton_end();
    xml.singleton_begin("nb_inst_update         "); xml.attribut("value",toString(_nb_inst_update         )); xml.singleton_end();
    xml.singleton_begin("size_history           "); xml.attribut("value",toString(_size_history           )); xml.singleton_end();
    for (uint32_t i=0;i<_nb_context; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","context");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
	xml.  singleton_begin("size_upt_queue         "); xml.attribut("value",toString(_size_upt_queue         [i])); xml.singleton_end();
	xml.  singleton_begin("size_ufpt_queue        "); xml.attribut("value",toString(_size_ufpt_queue        [i])); xml.singleton_end();
	xml.  singleton_begin("size_ras_index         "); xml.attribut("value",toString(_size_ras_index         [i])); xml.singleton_end();
        xml. balise_close();
      }
    xml.balise_close();

    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters & x)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
