#ifdef SYSTEMC
/*
 * $Id: OOO_Engine_Glue_genMealy_spr.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/OOO_Engine_Glue.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/SPR.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace ooo_engine_glue {


#undef  FUNCTION
#define FUNCTION "OOO_Engine_Glue::genMealy_spr"
  void OOO_Engine_Glue::genMealy_spr (void)
  {
    log_begin(OOO_Engine_Glue,FUNCTION);

    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
        {
          special_register_unit::SR * sr = new special_register_unit::SR (i,j);
          
          sr->write(PORT_READ(in_SPR_SPECIAL_REGISTER_UNIT_SR [i][j]));

          PORT_WRITE(out_SPR_SR_IEE             [i][j],sr->iee);
          PORT_WRITE(out_SPR_SR_EPH             [i][j],sr->eph);
          PORT_WRITE(out_SPR_COMMIT_UNIT_SR_OVE [i][j],sr->ove);
          PORT_WRITE(out_SPR_RENAME_UNIT_SR     [i][j],sr->read());

          delete sr;
        }

    log_end(OOO_Engine_Glue,FUNCTION);
  };

}; // end namespace ooo_engine_glue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
