/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_Address_Translation_unit/include/Parameters.h"
#include "Common/include/Max.h"
namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_address_translation_unit {


#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::Parameters"
  Parameters::Parameters (uint32_t   nb_front_end       ,
			  uint32_t * nb_context         ,
			  uint32_t   nb_general_register,
			  uint32_t   nb_special_register,
			  uint32_t   nb_inst_insert     ,
			  uint32_t   nb_inst_retire     ,
                          bool       is_toplevel)
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");

    _nb_front_end           = nb_front_end       ;
    _nb_context             = nb_context         ;
    _nb_general_register    = nb_general_register;
    _nb_special_register    = nb_special_register;
    _nb_inst_insert         = nb_inst_insert     ;
    _nb_inst_retire         = nb_inst_retire     ;

    test();

    if (is_toplevel)
      {
        _size_front_end_id      = log2(nb_front_end       );
        _size_context_id        = log2(max<uint32_t>(nb_context, nb_front_end));
        _size_general_register  = log2(nb_general_register);
        _size_special_register  = log2(nb_special_register);
    
        _have_port_front_end_id = _size_front_end_id>0;
        _have_port_context_id   = _size_context_id  >0;
        
        copy();
      }

    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Register_Address_Translation_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Register_Address_Translation_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"Begin");
    log_printf(FUNC,Register_Address_Translation_unit,FUNCTION,"End");
  };

}; // end namespace register_address_translation_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
