#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {

  void RegisterFile::vhdl_port (Vhdl & vhdl)
  {
    vhdl.set_port ("in_CLOCK" , IN, 1);
    vhdl.set_port ("in_NRESET", IN, 1);

    for (uint32_t i = 0; i < _param._nb_port_read; i ++)
      {
	vhdl.set_port (" in_READ_VAL_"+toString(i)+"    ",IN ,std_logic(1)                    );
	vhdl.set_port ("out_READ_ACK_"+toString(i)+"    ",OUT,std_logic(1)                    );
	vhdl.set_port (" in_READ_ADDRESS_"+toString(i)+"",IN ,std_logic(static_cast<uint32_t>(log2(_param._nb_word))));
	vhdl.set_port ("out_READ_DATA_"+toString(i)+"   ",OUT,std_logic(_param._size_word    ));
      }

    for (uint32_t i = 0; i < _param._nb_port_write; i ++)
      {
	vhdl.set_port (" in_WRITE_VAL_"+toString(i)+"    ",IN ,std_logic(1)                    );
	vhdl.set_port ("out_WRITE_ACK_"+toString(i)+"    ",OUT,std_logic(1)                    );
	vhdl.set_port (" in_WRITE_ADDRESS_"+toString(i)+"",IN ,std_logic(static_cast<uint32_t>(log2(_param._nb_word))));
	vhdl.set_port (" in_WRITE_DATA_"+toString(i)+"   ",IN ,std_logic(_param._size_word    ));
      }
  };

}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
