#ifdef VHDL

/*
 * $Id: Vhdl_get_model.cpp 94 2008-12-15 11:04:03Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
  std::string Vhdl::get_model(uint32_t depth            ,
			 std::string   filename         ,
			 std::string   entity_name      ,
			 std::string   architecture_name)
  {
    log_printf(FUNC,Behavioural,"get_model","Begin");

    std::string        tab = morpheo::tab(depth);
    std::ostringstream text;

    text << tab << get_header       (depth,filename)                      << std::endl
	 << tab << get_library_ieee (depth)                               << std::endl
	 << tab << get_library_work (depth)                               << std::endl
	 << tab << get_entity       (depth,entity_name)                   << std::endl
	 << tab << get_architecture (depth,architecture_name,entity_name) << std::endl;
    
    log_printf(FUNC,Behavioural,"get_model","End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
