#ifdef VHDL
/*
 * $Id: Execute_queue_vhdl_declaration.cpp 96 2008-12-16 19:36:25Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::vhdl_declaration"
  void Execute_queue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    for (uint32_t i=0; i<_param->_size_queue; ++i)
      {
	if (_param->_have_port_context_id)
	  vhdl->set_signal("reg_CONTEXT_ID_"+toString(i),_param->_size_context_id);
	if (_param->_have_port_front_end_id)
	  vhdl->set_signal("reg_FRONT_END_ID_"+toString(i),_param->_size_front_end_id);
	if (_param->_have_port_ooo_engine_id)
	  vhdl->set_signal("reg_OOO_ENGINE_ID_"+toString(i),_param->_size_ooo_engine_id);
	if (_param->_have_port_rob_ptr)
	  vhdl->set_signal("reg_PACKET_ID_"+toString(i),_param->_size_rob_ptr);
	vhdl->set_signal("reg_FLAGS_"+toString(i),_param->_size_special_data);
	vhdl->set_signal("reg_EXCEPTION_"+toString(i),_param->_size_exception);
	vhdl->set_signal("reg_NO_SEQUENCE_"+toString(i),1);
	vhdl->set_signal("reg_ADDRESS_"+toString(i),_param->_size_instruction_address);
	vhdl->set_signal("reg_DATA_"+toString(i),_param->_size_general_data);
      }

    vhdl->set_signal("reg_CURRENT_STATE",_param->_size_queue+1);

    vhdl->set_signal("sig_NEXT_STATE",_param->_size_queue+1);

    for (uint32_t i=0; i<_param->_size_queue-1; ++i)
      {
	vhdl->set_signal("sig_WEN_"+toString(i),1);
	vhdl->set_signal("sig_SEL_"+toString(i),1);
      }
    vhdl->set_signal("sig_WEN_"+toString(_param->_size_queue - 1),1);

    vhdl->set_signal("sig_IN_ACK",1);
    vhdl->set_signal("sig_OUT_VAL",1);

   for (uint32_t i=0; i<_param->_size_queue+1; ++i)
      vhdl->set_constant("STATE_"+toString(i),_param->_size_queue+1,1<<i);

    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
//   signal reg_0             : std_logic_vector (15 downto 0);
//   signal reg_1             : std_logic_vector (15 downto 0);
//   signal reg_2             : std_logic_vector (15 downto 0);
//   signal reg_3             : std_logic_vector (15 downto 0);
//   signal reg_CURRENT_STATE : std_logic_vector (4 downto 0);

//   signal sig_NEXT_STATE    : std_logic_vector (4 downto 0);
//   signal sig_WEN0          : std_logic;
//   signal sig_SEL0          : std_logic;
//   signal sig_WEN1          : std_logic;
//   signal sig_SEL1          : std_logic;
//   signal sig_WEN2          : std_logic;
//   signal sig_SEL2          : std_logic;
//   signal sig_WEN3          : std_logic;
