#ifdef STATISTICS
/*
 * $Id: Update_Prediction_Table_statistics_allocation.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"
#include "Behavioural/include/Allocation.h"


namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::statistics_allocation"
  void Update_Prediction_Table::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    _stat = new Stat (static_cast<std::string>(_name),
		      "Update_Prediction_Table",
		      param_statistics);

    {
      ALLOC2(_stat_nb_branch_hit        ,counter_t *,_param->_nb_context,MAX_BRANCH_CONDITION);
      ALLOC2(_stat_nb_branch_miss       ,counter_t *,_param->_nb_context,MAX_BRANCH_CONDITION);
      ALLOC1(_stat_nb_branch_unused     ,counter_t *,_param->_nb_context);
      
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          std::string sum_miss        = "0";
          std::string sum_branchement = "0";

          for (uint32_t j=0; j<MAX_BRANCH_CONDITION; ++j)
            if (is_branch_condition_valid(j))
              {
                std::string nb_miss        = "nb_branch_miss_"+toString(i)+"_"+toString(j); 
                std::string nb_branchement = "+ nb_branch_hit_"+toString(i)+"_"+toString(j)+" nb_branch_miss_"+toString(i)+"_"+toString(j);
                _stat_nb_branch_hit  [i][j] = _stat->create_counter("nb_branch_hit_" +toString(i)+"_"+toString(j),"",toString(_("Branch hit  speculation, branch condition : %s (context %d)"),toString(static_cast<branch_condition_t>(j)).c_str(),i));
                _stat_nb_branch_miss [i][j] = _stat->create_counter(nb_miss,"",toString(_("Branch miss speculation, branch condition : %s (context %d)"),toString(static_cast<branch_condition_t>(j)).c_str(),i));

//                 _stat->create_expr_average("average_miss_"+toString(i)+"_"+toString(j),
//                                            "nb_branch_miss_"+toString(i)+"_"+toString(j),
//                                            nb_branchement,
//                                            "miss/branchement",
//                                            toString(_("Average miss by branchement, branch condition : %s (context %d)"),toString(static_cast<branch_condition_t>(j)).c_str(),i));

                _stat->create_expr_percent("percent_miss_"+toString(i)+"_"+toString(j),
                                           nb_miss,
                                           nb_branchement,
                                           toString(_("Percent miss by branchement, branch condition : %s (context %d)"),toString(static_cast<branch_condition_t>(j)).c_str(),i));

                sum_miss        = "+ "+nb_miss       +" "+ sum_miss;
                sum_branchement = "+ "+nb_branchement+" "+sum_branchement;
              }

//           _stat->create_expr_average("average_miss_"+toString(i),
//                                      sum_miss,
//                                      sum_branchement,
//                                      "miss/branchement",
//                                      toString(_("Average miss by branchement (context %d)"),i));

          _stat->create_expr_percent("percent_miss_"+toString(i),
                                     sum_miss,
                                     sum_branchement,
                                     toString(_("Percent miss by branchement (context %d)"),i));
          
          _stat_nb_branch_unused [i] = _stat->create_counter("nb_branch_unused_" +toString(i),"",toString(_("Branch unused (previous speculation) (context %d)"),i));
        }
    }

    {
      ALLOC1(_stat_ufpt_queue_nb_elt        ,counter_t *,_param->_nb_context);
     
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          _stat_ufpt_queue_nb_elt         [i] = _stat->create_counter("ufpt_queue_nb_elt_"+toString(i),"",toString(_("Branchement in Update Fetch Prediction Table (context %d)"),i));
          
          _stat->create_expr_average_by_cycle("average_occupation_ufpt_queue_"+toString(i),"ufpt_queue_nb_elt_"+toString(i), "", toString(_("Average instruction by cycle in Update Fetch Prediction Table (context %d)"),i));
          _stat->create_expr_percent         ("percent_occupation_ufpt_queue_"+toString(i), "average_occupation_ufpt_queue_"+toString(i), toString(_param->_size_ufpt_queue[i]), toString(_("Percent occupation of Update Fetch Prediction Table (context %d)"),i));
        }
    }

    {
      ALLOC1(_stat_upt_queue_nb_elt        ,counter_t *,_param->_nb_context);
     
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          _stat_upt_queue_nb_elt         [i] = _stat->create_counter("upt_queue_nb_elt_"+toString(i),"",toString(_("Average branchement by cycle in Update Prediction Table (context %d)"),i));
          
          _stat->create_expr_average_by_cycle("average_occupation_upt_queue_"+toString(i),"upt_queue_nb_elt_"+toString(i), "", toString(_("Average instruction by cycle in Update Prediction Table (context %d)"),i));
          _stat->create_expr_percent         ("percent_occupation_upt_queue_"+toString(i), "average_occupation_upt_queue_"+toString(i), toString(_param->_size_upt_queue[i]), toString(_("Percent occupation of Update Prediction Table (context %d)"),i));
        }
    }

    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
