/*
 * $Id: Execute_queue_allocation.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {

#undef  FUNCTION
#define FUNCTION "Execute_queue::allocation"
  void Execute_queue::allocation (void)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Execute_queue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // -----[ Interface "execute_queue_in" ]--------------------------------    
     {
       ALLOC_INTERFACE ("execute_queue_in", IN, WEST, "Input of execute_queue");
       
       ALLOC_VALACK_IN ( in_EXECUTE_QUEUE_IN_VAL,VAL);
       ALLOC_VALACK_OUT(out_EXECUTE_QUEUE_IN_ACK,ACK);
       if(_param->_have_port_context_id)
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_CONTEXT_ID   ,"context_id"   ,Tcontext_t        ,_param->_size_context_id       );
       if(_param->_have_port_front_end_id)
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_FRONT_END_ID ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id     );
       if(_param->_have_port_ooo_engine_id)
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id    );
       if(_param->_have_port_rob_ptr)
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_PACKET_ID    ,"packet_id"    ,Tpacket_t         ,_param->_size_rob_ptr        );
//     ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_OPERATION    ,"operation"    ,Toperation_t      ,_param->_size_operation        );
//     ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_TYPE         ,"type"         ,Ttype_t           ,_param->_size_type             );
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_FLAGS        ,"flags"        ,Tspecial_data_t   ,_param->_size_special_data     );
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_EXCEPTION    ,"exception"    ,Texception_t      ,_param->_size_exception        );
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_NO_SEQUENCE  ,"no_sequence"  ,Tcontrol_t        ,1                              );
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_ADDRESS      ,"address"      ,Taddress_t        ,_param->_size_instruction_address);
       ALLOC_SIGNAL_IN ( in_EXECUTE_QUEUE_IN_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_data     );
     }

    // -----[ Interface "execute_queue_out" ]-------------------------------
     {
       ALLOC_INTERFACE ("execute_queue_out", OUT, EAST, "Output of execute_queue");
       
       ALLOC_VALACK_OUT(out_EXECUTE_QUEUE_OUT_VAL,VAL);
       ALLOC_VALACK_IN ( in_EXECUTE_QUEUE_OUT_ACK,ACK);
       if(_param->_have_port_context_id)
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ,"context_id"   ,Tcontext_t     ,_param->_size_context_id   );
       if(_param->_have_port_front_end_id)
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_FRONT_END_ID ,"front_end_id" ,Tcontext_t     ,_param->_size_front_end_id );
       if(_param->_have_port_ooo_engine_id)
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t     ,_param->_size_ooo_engine_id);
       if(_param->_have_port_rob_ptr)
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_PACKET_ID    ,"packet_id"    ,Tpacket_t      ,_param->_size_rob_ptr    );
//     ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_OPERATION    ,"operation"    ,Toperation_t   ,_param->_size_operation    );
//     ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_TYPE         ,"type"         ,Ttype_t        ,_param->_size_type         );
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_FLAGS        ,"flags"        ,Tspecial_data_t,_param->_size_special_data );
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_EXCEPTION    ,"exception"    ,Texception_t   ,_param->_size_exception    );
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ,"no_sequence"  ,Tcontrol_t     ,1                          );
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_ADDRESS      ,"address"      ,Taddress_t     ,_param->_size_instruction_address);
       ALLOC_SIGNAL_OUT(out_EXECUTE_QUEUE_OUT_DATA         ,"data"         ,Tgeneral_data_t,_param->_size_general_data );
     }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

     _queue = new std::queue<execute_queue_entry_t *>;

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
