#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_rename_select_Rename_select_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_rename_select_Rename_select_h

/*
 * $Id: Rename_select.h 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Behavioural/Generic/Priority/include/Priority.h"

#include <list>
#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_select {


  class Rename_select 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "rename_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_VAL           ;//[nb_front_end][nb_inst_decod]
  public    : SC_OUT(Tcontrol_t        )  *** out_RENAME_IN_ACK           ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontext_t        )  ***  in_RENAME_IN_FRONT_END_ID  ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontext_t        )  ***  in_RENAME_IN_CONTEXT_ID    ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tdepth_t          )  ***  in_RENAME_IN_DEPTH         ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Ttype_t           )  ***  in_RENAME_IN_TYPE          ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Toperation_t      )  ***  in_RENAME_IN_OPERATION     ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_NO_EXECUTE    ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_IS_DELAY_SLOT ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Taddress_t        )  ***  in_RENAME_IN_ADDRESS       ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_HAS_IMMEDIAT  ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_data_t   )  ***  in_RENAME_IN_IMMEDIAT      ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_READ_RA       ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t)  ***  in_RENAME_IN_NUM_REG_RA    ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_READ_RB       ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t)  ***  in_RENAME_IN_NUM_REG_RB    ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_READ_RC       ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tspecial_address_t)  ***  in_RENAME_IN_NUM_REG_RC    ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_WRITE_RD      ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t)  ***  in_RENAME_IN_NUM_REG_RD    ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tcontrol_t        )  ***  in_RENAME_IN_WRITE_RE      ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Tspecial_address_t)  ***  in_RENAME_IN_NUM_REG_RE    ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Texception_t      )  ***  in_RENAME_IN_EXCEPTION_USE ;//[nb_front_end][nb_inst_decod]
  public    : SC_IN (Texception_t      )  ***  in_RENAME_IN_EXCEPTION     ;//[nb_front_end][nb_inst_decod]

    // ~~~~~[ Interface : "rename_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_VAL          ;//[nb_inst_rename]
  public    : SC_IN (Tcontrol_t        )   **  in_RENAME_OUT_ACK          ;//[nb_inst_rename]
  public    : SC_OUT(Tcontext_t        )   ** out_RENAME_OUT_FRONT_END_ID ;//[nb_inst_rename]
  public    : SC_OUT(Tcontext_t        )   ** out_RENAME_OUT_CONTEXT_ID   ;//[nb_inst_rename]
  public    : SC_OUT(Tdepth_t          )   ** out_RENAME_OUT_DEPTH        ;//[nb_inst_rename]
  public    : SC_OUT(Ttype_t           )   ** out_RENAME_OUT_TYPE         ;//[nb_inst_rename]
  public    : SC_OUT(Toperation_t      )   ** out_RENAME_OUT_OPERATION    ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_NO_EXECUTE   ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_IS_DELAY_SLOT;//[nb_inst_rename]
  public    : SC_OUT(Taddress_t        )   ** out_RENAME_OUT_ADDRESS      ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_HAS_IMMEDIAT ;//[nb_inst_rename]
  public    : SC_OUT(Tgeneral_data_t   )   ** out_RENAME_OUT_IMMEDIAT     ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_READ_RA      ;//[nb_inst_rename]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RA   ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_READ_RB      ;//[nb_inst_rename]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RB   ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_READ_RC      ;//[nb_inst_rename]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_OUT_NUM_REG_RC   ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_WRITE_RD     ;//[nb_inst_rename]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RD   ;//[nb_inst_rename]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_WRITE_RE     ;//[nb_inst_rename]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_OUT_NUM_REG_RE   ;//[nb_inst_rename]
  public    : SC_OUT(Texception_t      )   ** out_RENAME_OUT_EXCEPTION_USE;//[nb_inst_rename]
  public    : SC_OUT(Texception_t      )   ** out_RENAME_OUT_EXCEPTION    ;//[nb_inst_rename]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : generic::priority::Priority   * _priority;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Rename_select);
#endif
  public  :          Rename_select              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Rename_select             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy                  (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace rename_select
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
