#ifdef VHDL

/*
 * $Id: Vhdl_std_logic.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [Description ]
 * 
 */

#include <math.h>
#include "Behavioural/include/Vhdl.h"
#include "Common/include/ToBase2.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Vhdl::std_logic"
  std::string std_logic (uint32_t size)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string type;

    if (size == 1)
      type = "std_logic";
    else
      type = "std_logic_vector(" + toString(size-1) + " downto 0)";

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return type;
  };

#undef  FUNCTION
#define FUNCTION "Vhdl::std_logic_conv"
  std::string std_logic_conv (uint32_t size, std::string value)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string conv;

    if (size == 1)
      conv = "'"+toString(value)+"'";
    else
      conv = "conv_std_logic_vector("+value+","+toString(size)+")";

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return conv;
  };

  std::string std_logic_conv (uint32_t size, uint32_t value)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    std::string _return = std_logic_conv(size,toString(value));
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return _return;
  };

#undef  FUNCTION
#define FUNCTION "Vhdl::std_logic_cst"
  std::string std_logic_cst (uint32_t size, uint32_t value)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string conv;

    if (size == 1)
      conv = "'"+toString(value&1)+"'";
    else
      conv = "\""+toBase2<uint32_t>(value,size)+"\"";

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return conv;
  };

#undef  FUNCTION
#define FUNCTION "Vhdl::std_logic_range"
  std::string std_logic_range (uint32_t size, uint32_t max, uint32_t min)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    std::string type;

      {
        if (size < 2)
          type = "";
        else
          {
            if (max == min)
              {
                type = "("+toString(max)+")";
              }
            else
              {
                type = "("+toString(max)+" downto "+toString(min)+")";
              }
          }
      }

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return type;
  };

  std::string std_logic_range (uint32_t max, uint32_t min)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    std::string type;

      {
        if (max == min)
          {
            type = "("+toString(max)+")";
          }
        else
          {
            if (max == 0)
              type = "";
            else
              type = "("+toString(max)+" downto "+toString(min)+")";
          }
      }

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return type;
  };

  std::string std_logic_range (uint32_t size)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    std::string _return = std_logic_range(size,size-1,0);
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return _return;
  }

#undef  FUNCTION
#define FUNCTION "Vhdl::_std_logic_range"
  std::string _std_logic_range (uint32_t size, uint32_t max, uint32_t min)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    std::string type=_std_logic_range(max,min);
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return type;
  };

  std::string _std_logic_range (uint32_t max, uint32_t min)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    std::string type = "("+toString(max)+" downto "+toString(min)+")";
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return type;
  };

  std::string _std_logic_range (uint32_t size)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    std::string _return = _std_logic_range(size,size-1,0);
    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return _return;
  }

#undef  FUNCTION
#define FUNCTION "Vhdl::std_logic_others"
  std::string std_logic_others (uint32_t size, bool cst  )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string _return;

    if (size < 2)
      _return = "'"+toString(cst)+"'";
    else
      _return = "(others => '"+toString(cst)+"')";

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return _return;
  }

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
