/*
 * $Id: Prediction_unit_allocation.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/include/Prediction_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {

#undef  FUNCTION
#define FUNCTION "Prediction_unit::allocation"
  void Prediction_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Prediction_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Prediction_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      {
	ALLOC1_INTERFACE("predict",IN,SOUTH,"Interface with ifetch unit",_param->_nb_context);
	
	ALLOC1_VALACK_IN ( in_PREDICT_VAL                        ,VAL);
	ALLOC1_VALACK_OUT(out_PREDICT_ACK                        ,ACK);
	ALLOC1_SIGNAL_IN ( in_PREDICT_PC_PREVIOUS                ,"pc_previous"                ,Taddress_t         ,_param->_size_address);
	ALLOC1_SIGNAL_IN ( in_PREDICT_PC_CURRENT                 ,"pc_current"                 ,Taddress_t         ,_param->_size_address);
	ALLOC1_SIGNAL_IN ( in_PREDICT_PC_CURRENT_IS_DS_TAKE      ,"pc_current_is_ds_take"      ,Tcontrol_t         ,1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_PC_NEXT                    ,"pc_next"                    ,Taddress_t         ,_param->_size_address);
	ALLOC1_SIGNAL_OUT(out_PREDICT_PC_NEXT_IS_DS_TAKE         ,"pc_next_is_ds_take"         ,Tcontrol_t         ,1);
	ALLOC1_SIGNAL_OUT(out_PREDICT_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t ,_param->_size_inst_ifetch_ptr);
	ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state);
	ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth);
      }
      {
	ALLOC2_INTERFACE("predict",IN,SOUTH,"Interface with ifetch unit",_param->_nb_context,_param->_nb_instruction[it1]);
	_ALLOC2_SIGNAL_OUT(out_PREDICT_INSTRUCTION_ENABLE         ,"instruction_enable"         ,Tcontrol_t         ,1,_param->_nb_context,_param->_nb_instruction[it1]);
      }
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
    {
      {
	ALLOC2_INTERFACE("decod",IN,SOUTH,"Interface with decod unit",_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	
	_ALLOC2_VALACK_IN ( in_DECOD_VAL                        ,VAL,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_VALACK_OUT(out_DECOD_ACK                        ,ACK,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_CONTEXT_ID                 ,"context_id"                 ,Tcontext_t         ,_param->_size_context_id      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_MATCH_INST_IFETCH_PTR      ,"match_inst_ifetch_ptr"      ,Tcontrol_t         ,1                             ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state    ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_CONDITION           ,"branch_condition"           ,Tbranch_condition_t,_param->_size_branch_condition,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_BRANCH_DIRECTION           ,"branch_direction"           ,Tcontrol_t         ,1                             ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_ADDRESS_SRC                ,"address_src"                ,Taddress_t         ,_param->_size_address         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
	_ALLOC2_SIGNAL_IN ( in_DECOD_ADDRESS_DEST               ,"address_dest"               ,Taddress_t         ,_param->_size_address         ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1]);
      }
    }

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("branch_complete", IN,SOUTH, "branch_complete", _param->_nb_inst_branch_complete);
      
      ALLOC1_VALACK_IN ( in_BRANCH_COMPLETE_VAL            ,VAL);
      ALLOC1_VALACK_OUT(out_BRANCH_COMPLETE_ACK            ,ACK);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_CONTEXT_ID     ,"context_id"     ,Tcontext_t,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_DEPTH          ,"depth"          ,Tdepth_t  ,_param->_size_depth);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_ADDRESS        ,"address"        ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_BRANCH_COMPLETE_FLAG           ,"flag"           ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_MISS_PREDICTION,"miss_prediction",Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_TAKE           ,"take"           ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_ADDRESS_SRC    ,"address_src"    ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_BRANCH_COMPLETE_ADDRESS_DEST   ,"address_dest"   ,Taddress_t,_param->_size_address);
    }

    // ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("branch_event", IN,SOUTH, "branch_event", _param->_nb_context);
      
      ALLOC1_VALACK_OUT(out_BRANCH_EVENT_VAL              ,VAL);
      ALLOC1_VALACK_IN ( in_BRANCH_EVENT_ACK              ,ACK);
//    ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_CONTEXT_ID       ,"context_id"      ,Tcontext_t,_param->_size_context_id);
//    ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_DEPTH            ,"depth"           ,Tdepth_t  ,_param->_size_depth);
//    ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_MISS_PREDICTION  ,"miss_prediction" ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_ADDRESS_SRC      ,"address_src"     ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_ADDRESS_DEST_VAL ,"address_dest_val",Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_BRANCH_EVENT_ADDRESS_DEST     ,"address_dest"    ,Taddress_t,_param->_size_address);
    }

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
    {
      ALLOC1_INTERFACE("depth",OUT,SOUTH,"Interface with depth",_param->_nb_context);

      ALLOC1_SIGNAL_OUT(out_DEPTH_CURRENT      ,"current"      ,Tdepth_t,_param->_size_depth);
      ALLOC1_SIGNAL_OUT(out_DEPTH_MIN          ,"min"          ,Tdepth_t,_param->_size_depth);
      ALLOC1_SIGNAL_OUT(out_DEPTH_MAX          ,"max"          ,Tdepth_t,_param->_size_depth+1);
    }

    // ~~~~~[ Interface : "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("event", IN,SOUTH,"event", _param->_nb_context);

      ALLOC1_VALACK_IN ( in_EVENT_VAL    ,VAL);
      ALLOC1_VALACK_OUT(out_EVENT_ACK    ,ACK);
      ALLOC1_SIGNAL_IN ( in_EVENT_TYPE   ,"type" ,Tevent_type_t ,_param->_size_event_type );
      ALLOC1_SIGNAL_IN ( in_EVENT_DEPTH  ,"depth",Tdepth_t      ,_param->_size_depth      );
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    std::string name;

    {
      name = _name+"_branch_target_buffer";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_btb = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::Branch_Target_Buffer
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_btb
	 ,_usage);
      
      _component->set_component (_component_btb->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }

    {
      name = _name+"_direction";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_dir = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::Direction
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_dir
	 ,_usage);
      
      _component->set_component (_component_dir->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }
    
    {
      name = _name+"_return_address_stack";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_ras = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::return_address_stack::Return_Address_Stack
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_ras
	 ,_usage);
      
      _component->set_component (_component_ras->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }
    
    {
      name = _name+"_update_prediction_table";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_upt = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Update_Prediction_Table
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_upt
	 ,_usage);
      
      _component->set_component (_component_upt->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }

    {
      name = _name+"_prediction_unit_glue";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_glue = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue::Prediction_unit_Glue
        (name.c_str()
#ifdef STATISTICS
         ,param_statistics
#endif
         ,_param->_param_glue
	 ,_usage);
      
      _component->set_component (_component_glue->_component
#ifdef POSITION
                                 , 50, 50, 10, 10
#endif
                                 );
    }
    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;

    // ===================================================================
    // =====[ branch_target_buffer ]======================================
    // ===================================================================
    {
      src = _name+"_branch_target_buffer";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Instance : %s"),src.c_str());
           
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_branch_predict; i++)
	{
	  dest = _name+"_prediction_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"predict_"+toString(i),
				     dest,"predict_btb_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_VAL"         ,
			           dest,"out_PREDICT_BTB_"+toString(i)+"_VAL"         ); 
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_ACK"         ,
		                   dest, "in_PREDICT_BTB_"+toString(i)+"_ACK"         ); 
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_CONTEXT_ID"  ,
		                   dest,"out_PREDICT_BTB_"+toString(i)+"_CONTEXT_ID"  );
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_ADDRESS"     ,
		                   dest,"out_PREDICT_BTB_"+toString(i)+"_ADDRESS"     );
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_HIT"         ,
		                   dest, "in_PREDICT_BTB_"+toString(i)+"_HIT"         ); 
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_ADDRESS_SRC" ,
		                   dest, "in_PREDICT_BTB_"+toString(i)+"_ADDRESS_SRC" ); 
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_ADDRESS_DEST",
		                   dest, "in_PREDICT_BTB_"+toString(i)+"_ADDRESS_DEST"); 
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_CONDITION"   ,
		                   dest, "in_PREDICT_BTB_"+toString(i)+"_CONDITION"   ); 
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_IS_ACCURATE" ,
		                   dest, "in_PREDICT_BTB_"+toString(i)+"_IS_ACCURATE" );

	  dest = _name+"_direction";
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_LAST_TAKE" ,
		                   dest, "in_PREDICT_"+toString(i)+"_LAST_TAKE" );
	}

      for (uint32_t i=0; i<_param->_nb_inst_branch_decod; i++)
	{
	  dest = _name+"_prediction_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"decod_"+toString(i),
				     dest,"decod_btb_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_VAL"            ,
			           dest,"out_DECOD_BTB_"+toString(i)+"_VAL"            );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"    +toString(i)+"_ACK"            ,
			           dest, "in_DECOD_BTB_"+toString(i)+"_ACK"            );
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_CONTEXT_ID"     ,
			           dest,"out_DECOD_BTB_"+toString(i)+"_CONTEXT_ID"     );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_ADDRESS_SRC"    ,
			           dest,"out_DECOD_BTB_"+toString(i)+"_ADDRESS_SRC"    );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_ADDRESS_DEST"   ,
			           dest,"out_DECOD_BTB_"+toString(i)+"_ADDRESS_DEST"   );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_CONDITION"      ,
			           dest,"out_DECOD_BTB_"+toString(i)+"_CONDITION"      );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_LAST_TAKE"      ,
			           dest,"out_DECOD_BTB_"+toString(i)+"_LAST_TAKE"      );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_MISS_PREDICTION",
			           dest,"out_DECOD_BTB_"+toString(i)+"_MISS_PREDICTION");
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_IS_ACCURATE"    ,
			           dest,"out_DECOD_BTB_"+toString(i)+"_IS_ACCURATE"    );
	}

      for (uint32_t i=0; i<_param->_nb_inst_branch_update; i++)
	{
	  dest = _name+"_prediction_unit_glue";

	  COMPONENT_MAP(_component,src , "in_UPDATE_"    +toString(i)+"_VAL",
			           dest,"out_UPDATE_BTB_"+toString(i)+"_VAL");
	  COMPONENT_MAP(_component,src ,"out_UPDATE_"    +toString(i)+"_ACK",
			           dest, "in_UPDATE_BTB_"+toString(i)+"_ACK");

	  dest = _name+"_update_prediction_table";
#ifdef POSITION
	  _component->interface_map (src ,"update_"+toString(i),
				     dest,"update_"+toString(i));
#endif

	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_CONTEXT_ID"     ,
			           dest,"out_UPDATE_"+toString(i)+    "_CONTEXT_ID"     );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_ADDRESS_SRC"    ,
			           dest,"out_UPDATE_"+toString(i)+"_BTB_ADDRESS_SRC"    );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_ADDRESS_DEST"   ,
			           dest,"out_UPDATE_"+toString(i)+"_BTB_ADDRESS_DEST"   );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_CONDITION"      ,
			           dest,"out_UPDATE_"+toString(i)+"_BTB_CONDITION"      );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_LAST_TAKE"      ,
			           dest,"out_UPDATE_"+toString(i)+    "_DIRECTION_GOOD" );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_MISS_PREDICTION",
			           dest,"out_UPDATE_"+toString(i)+    "_MISS_PREDICTION");
	}
    }

    // ===================================================================
    // =====[ direction ]=================================================
    // ===================================================================
    {
      src = _name+"_direction";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Instance : %s"),src.c_str());
           
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_branch_predict; i++)
	{
	  dest = _name+"_prediction_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"predict_"+toString(i),
				     dest,"predict_dir_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_VAL"        ,
			           dest,"out_PREDICT_DIR_"+toString(i)+"_VAL"        );
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_ACK"        ,
			           dest, "in_PREDICT_DIR_"+toString(i)+"_ACK"        );
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_ADDRESS_SRC",
			           dest,"out_PREDICT_DIR_"+toString(i)+"_ADDRESS_SRC");
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_STATIC"     ,
			           dest,"out_PREDICT_DIR_"+toString(i)+"_STATIC"     );
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_DIRECTION"  ,
			           dest, "in_PREDICT_DIR_"+toString(i)+"_DIRECTION"  );

	  dest = _name+"_update_prediction_table";
	  if (_param->_have_port_history)
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_HISTORY"  ,
			           dest, "in_PREDICT_"    +toString(i)+"_HISTORY"  );
	  //out_PREDICT_DIR_LAST_TAKE - component_map branch_target_buffer
	}

      for (uint32_t i=0; i<_param->_nb_inst_branch_update; i++)
	{
	  dest = _name+"_prediction_unit_glue";

	  COMPONENT_MAP(_component,src , "in_UPDATE_"    +toString(i)+"_VAL",
			           dest,"out_UPDATE_DIR_"+toString(i)+"_VAL");
	  COMPONENT_MAP(_component,src ,"out_UPDATE_"    +toString(i)+"_ACK",
			           dest, "in_UPDATE_DIR_"+toString(i)+"_ACK");

	  dest = _name+"_update_prediction_table";
#ifdef POSITION
	  _component->interface_map (src ,"update_"+toString(i),
				     dest,"update_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_ADDRESS"  ,
			           dest,"out_UPDATE_"+toString(i)+"_BTB_ADDRESS_SRC");
	  if (_param->_have_port_history)
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_HISTORY"  ,
			           dest,"out_UPDATE_"+toString(i)+"_DIR_HISTORY"  );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_DIRECTION",
			           dest,"out_UPDATE_"+toString(i)+    "_DIRECTION_GOOD");
	  
	}
    }

    // ===================================================================
    // =====[ return_address_stack ]======================================
    // ===================================================================
    {
      src = _name+"_return_address_stack";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Instance : %s"),src.c_str());

           
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_branch_predict; i++)
	{
	  dest = _name+"_prediction_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"predict_"+toString(i),
				     dest,"predict_dir_"+toString(i));
#endif
	  
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_VAL"         ,
		                   dest,"out_PREDICT_RAS_"+toString(i)+"_VAL"         );
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_ACK"         ,
		                   dest, "in_PREDICT_RAS_"+toString(i)+"_ACK"         );
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_CONTEXT_ID"  ,
		                   dest,"out_PREDICT_RAS_"+toString(i)+"_CONTEXT_ID"  );
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_HIT"         ,
		                   dest, "in_PREDICT_RAS_"+toString(i)+"_HIT"         ); 
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_PUSH"        ,
		                   dest,"out_PREDICT_RAS_"+toString(i)+"_PUSH"        );
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_ADDRESS_PUSH",
		                   dest,"out_PREDICT_RAS_"+toString(i)+"_ADDRESS_PUSH");
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_ADDRESS_POP" ,
		                   dest, "in_PREDICT_RAS_"+toString(i)+"_ADDRESS_POP" );

	  dest = _name+"_update_prediction_table";
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_INDEX",
		                   dest, "in_PREDICT_"    +toString(i)+"_RAS_INDEX");
	}
      
      for (uint32_t i=0; i<_param->_nb_inst_branch_decod; i++)
	{
	  dest = _name+"_prediction_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"decod_"+toString(i),
				     dest,"decod_ras_"+toString(i));
#endif
	  
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_VAL"            ,
			           dest,"out_DECOD_RAS_"+toString(i)+"_VAL"            );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"    +toString(i)+"_ACK"            ,
			           dest, "in_DECOD_RAS_"+toString(i)+"_ACK"            );
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_CONTEXT_ID"     ,
			           dest,"out_DECOD_RAS_"+toString(i)+"_CONTEXT_ID"     ); 
	  COMPONENT_MAP(_component,src ,"out_DECOD_"    +toString(i)+"_HIT"            ,
			           dest, "in_DECOD_RAS_"+toString(i)+"_HIT"            ); 
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_PUSH"           ,
			           dest,"out_DECOD_RAS_"+toString(i)+"_PUSH"           );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_ADDRESS_PUSH"   ,
			           dest,"out_DECOD_RAS_"+toString(i)+"_ADDRESS_PUSH"   );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"    +toString(i)+"_ADDRESS_POP"    ,
			           dest, "in_DECOD_RAS_"+toString(i)+"_ADDRESS_POP"    );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_MISS_PREDICTION",
			           dest,"out_DECOD_RAS_"+toString(i)+"_MISS_PREDICTION");

	  dest = _name+"_update_prediction_table";
	  COMPONENT_MAP(_component,src ,"out_DECOD_"    +toString(i)+"_INDEX"          ,
			           dest, "in_DECOD_"    +toString(i)+"_RAS_INDEX"      ); 
	}

      for (uint32_t i=0; i<_param->_nb_inst_branch_update; i++)
	{
	  dest = _name+"_prediction_unit_glue";

	  COMPONENT_MAP(_component,src , "in_UPDATE_"    +toString(i)+"_VAL",
			           dest,"out_UPDATE_RAS_"+toString(i)+"_VAL");
	  COMPONENT_MAP(_component,src ,"out_UPDATE_"    +toString(i)+"_ACK",
			           dest, "in_UPDATE_RAS_"+toString(i)+"_ACK");

	  dest = _name+"_update_prediction_table";
#ifdef POSITION
	  _component->interface_map (src ,"update_"+toString(i),
				     dest,"update_"+toString(i));
#endif

	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_CONTEXT_ID"       ,
			           dest,"out_UPDATE_"+toString(i)+    "_CONTEXT_ID"       );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_PUSH"             ,
			           dest,"out_UPDATE_"+toString(i)+"_RAS_PUSH"             );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_FLUSH"            ,
			           dest,"out_UPDATE_"+toString(i)+"_RAS_FLUSH"            );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_ADDRESS"          ,
			           dest,"out_UPDATE_"+toString(i)+"_RAS_ADDRESS"          );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_INDEX"            ,
			           dest,"out_UPDATE_"+toString(i)+"_RAS_INDEX"            );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_MISS_PREDICTION"  ,
			           dest,"out_UPDATE_"+toString(i)+    "_MISS_PREDICTION"  );
	  COMPONENT_MAP(_component,src , "in_UPDATE_"+toString(i)+    "_PREDICTION_IFETCH",
			           dest,"out_UPDATE_"+toString(i)+"_RAS_PREDICTION_IFETCH");
	}
    }

    // ===================================================================
    // =====[ update_prediction_table ]===================================
    // ===================================================================
    {
      src = _name+"_update_prediction_table";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Instance : %s"),src.c_str());
           
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif
        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_inst_branch_predict; i++)
	{
	  dest = _name+"_prediction_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"predict_"+toString(i),
				     dest,"predict_dir_"+toString(i));
#endif
      
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_VAL"             ,
			           dest,"out_PREDICT_UPT_"+toString(i)+"_VAL"             );
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+"_ACK"             ,
		                   dest, "in_PREDICT_UPT_"+toString(i)+"_ACK"             );
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_CONTEXT_ID"      ,
		                   dest,"out_PREDICT_UPT_"+toString(i)+"_CONTEXT_ID"      );
	  if (_param->_have_port_depth)
	  COMPONENT_MAP(_component,src ,"out_PREDICT_"    +toString(i)+       "_UPDATE_PREDICTION_ID",
		                   dest, "in_PREDICT_UPT_"+toString(i)+"_BRANCH_UPDATE_PREDICTION_ID");
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_BTB_ADDRESS_SRC" ,
		                   dest,"out_PREDICT_UPT_"+toString(i)+"_BTB_ADDRESS_SRC" );
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_BTB_ADDRESS_DEST",
			           dest,"out_PREDICT_UPT_"+toString(i)+"_BTB_ADDRESS_DEST");
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_BTB_CONDITION"   ,
		                   dest,"out_PREDICT_UPT_"+toString(i)+"_BTB_CONDITION"   );
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_BTB_LAST_TAKE"   ,
		                   dest,"out_PREDICT_UPT_"+toString(i)+"_BTB_LAST_TAKE"   );
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_BTB_IS_ACCURATE" ,
		                   dest,"out_PREDICT_UPT_"+toString(i)+"_BTB_IS_ACCURATE" );
	  COMPONENT_MAP(_component,src , "in_PREDICT_"    +toString(i)+"_RAS_ADDRESS"     ,
		                   dest,"out_PREDICT_UPT_"+toString(i)+"_RAS_ADDRESS"     );

	  //out_PREDICT_HISTORY   - component_map direction
	  // in_PREDICT_RAS_INDEX - component_map return_address_stack
	}

      for (uint32_t i=0; i<_param->_nb_inst_branch_decod; i++)
	{
	  dest = _name+"_prediction_unit_glue";
	  
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_VAL"                 ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_VAL"                 );
	  COMPONENT_MAP(_component,src ,"out_DECOD_"    +toString(i)+"_ACK"                 ,
			           dest, "in_DECOD_UPT_"+toString(i)+"_ACK"                 );
	  if (_param->_have_port_context_id)
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_CONTEXT_ID"          ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_CONTEXT_ID"          );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_BTB_ADDRESS_SRC"     ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_BTB_ADDRESS_SRC"     );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_BTB_ADDRESS_DEST"    ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_BTB_ADDRESS_DEST"    );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_BTB_CONDITION"       ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_BTB_CONDITION"       );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_BTB_LAST_TAKE"       ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_BTB_LAST_TAKE"       );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_RAS_ADDRESS"         ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_RAS_ADDRESS"         );
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_MISS_IFETCH"         ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_MISS_IFETCH"         ); 
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_MISS_DECOD"          ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_MISS_DECOD"          ); 
	  if (_param->_have_port_depth)
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_UPDATE_PREDICTION_ID",
			           dest,"out_DECOD_UPT_"+toString(i)+"_UPDATE_PREDICTION_ID");
	  COMPONENT_MAP(_component,src , "in_DECOD_"    +toString(i)+"_IS_ACCURATE"         ,
			           dest,"out_DECOD_UPT_"+toString(i)+"_IS_ACCURATE"         );
	  
	  //out_DECOD_UPT_RAS_INDEX - component_map return_address_stack
	}

      for (uint32_t i=0; i<_param->_nb_inst_branch_update; i++)
	{
	  dest = _name+"_prediction_unit_glue";

#ifdef POSITION
	  _component->interface_map (src ,"update_"+toString(i),
				     dest,"update_upt_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src ,"out_UPDATE_"    +toString(i)+"_VAL",
			           dest, "in_UPDATE_UPT_"+toString(i)+"_VAL");
	  COMPONENT_MAP(_component,src , "in_UPDATE_"    +toString(i)+"_ACK",
			           dest,"out_UPDATE_UPT_"+toString(i)+"_ACK");

	  COMPONENT_MAP(_component,src ,"out_UPDATE_"    +toString(i)+"_BTB_VAL",
			           dest, "in_UPDATE_UPT_"+toString(i)+"_BTB_VAL");
	  COMPONENT_MAP(_component,src ,"out_UPDATE_"    +toString(i)+"_DIR_VAL",
			           dest, "in_UPDATE_UPT_"+toString(i)+"_DIR_VAL");
	  COMPONENT_MAP(_component,src ,"out_UPDATE_"    +toString(i)+"_RAS_VAL",
			           dest, "in_UPDATE_UPT_"+toString(i)+"_RAS_VAL");

	  //in_UPDATE_UPT_CONTEXT_ID            - component_map branch_target_buffer
	  //in_UPDATE_UPT_MISS_PREDICTION       - component_map branch_target_buffer
	  //in_UPDATE_UPT_DIRECTION_GOOD        - component_map branch_target_buffer
	  //in_UPDATE_UPT_BTB_ADDRESS_SRC       - component_map branch_target_buffer
	  //in_UPDATE_UPT_BTB_ADDRESS_DEST      - component_map branch_target_buffer
	  //in_UPDATE_UPT_BTB_CONDITION         - component_map branch_target_buffer
	  //in_UPDATE_UPT_DIR_HISTORY           - component_map direction
	  //in_UPDATE_UPT_RAS_ADDRESS           - component_map return_address_stack
	  //in_UPDATE_UPT_RAS_PUSH              - component_map return_address_stack
	  //in_UPDATE_UPT_RAS_FLUSH             - component_map return_address_stack
	  //in_UPDATE_UPT_RAS_INDEX             - component_map return_address_stack
	  //in_UPDATE_UPT_RAS_PREDICTION_IFETCH - component_map return_address_stack
	}

      for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"complete_"+toString(i),
				     dest,"complete_"+toString(i));
#endif

	  PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"            ,
		              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"            );
	  PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK"            ,
		              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK"            );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID"     ,
		              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID"     );
	  if (_param->_have_port_depth)
	  PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"          ,
		              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"          );
	  PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"        ,
		              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"        );
	  PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_FLAG"           ,
		              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_FLAG"           );
	  PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_MISS_PREDICTION",
		              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_MISS_PREDICTION");
	  PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_TAKE"           ,
		              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_TAKE"           );
	  PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_SRC"    ,
		              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_SRC"    );
	  PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_DEST"   ,
		              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_DEST"   );
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"branch_event_"+toString(i),
				     dest,"branch_event_"+toString(i));
#endif

	  PORT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_VAL"             ,dest,"out_BRANCH_EVENT_"+toString(i)+"_VAL"             );
	  PORT_MAP(_component,src , "in_BRANCH_EVENT_"+toString(i)+"_ACK"             ,dest, "in_BRANCH_EVENT_"+toString(i)+"_ACK"             );
	  PORT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_SRC"     ,dest,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_SRC"     );
	  PORT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST_VAL",dest,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST_VAL");
	  PORT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST"    ,dest,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST"    );
	}

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;

#ifdef POSITION
	  _component->interface_map (src ,"event_"+toString(i),
				     dest,"event_"+toString(i));
#endif

	  PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_VAL"  ,dest, "in_EVENT_"+toString(i)+"_VAL"  );
	  PORT_MAP(_component,src ,"out_EVENT_"+toString(i)+"_ACK"  ,dest,"out_EVENT_"+toString(i)+"_ACK"  );
	  PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_TYPE" ,dest, "in_EVENT_"+toString(i)+"_TYPE" );
	  if (_param->_have_port_depth)
	  PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_DEPTH",dest, "in_EVENT_"+toString(i)+"_DEPTH");
        }

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"depth_"+toString(i),
				     dest,"depth_"+toString(i));
#endif
	  
	  if (_param->_have_port_depth)
            {
	  PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_CURRENT",
                              dest,"out_DEPTH_"+toString(i)+"_CURRENT");
	  PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_MIN",
                              dest,"out_DEPTH_"+toString(i)+"_MIN");
            }
	  PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_MAX",
                              dest,"out_DEPTH_"+toString(i)+"_MAX");
	}

//       for (uint32_t i=0; i<_param->_nb_context; i++)
// 	{
// 	  dest = _name+"_prediction_unit_glue";
	  
// #ifdef POSITION
// 	  _component->interface_map (src ,"depth_"+toString(i),
// 				     dest,"depth_"+toString(i));
// #endif
	  
// 	  COMPONENT_MAP(_component,src ,"out_DEPTH_"+toString(i)+    "_NB_BRANCH",
// 			           dest, "in_DEPTH_"+toString(i)+"_UPT_NB_BRANCH");

// 	  if (_param->_have_port_depth)
// 	  COMPONENT_MAP(_component,src ,"out_DEPTH_"+toString(i)+    "_TAIL"     ,
// 		                   dest, "in_DEPTH_"+toString(i)+"_UPT_TAIL"     );
// 	}
    }

    // ===================================================================
    // =====[ prediction_unit_glue ]======================================
    // ===================================================================
    {
      src = _name+"_prediction_unit_glue";
      log_printf(INFO,Prediction_unit,FUNCTION,_("Instance : %s"),src.c_str());
           
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"",
                                   dest,"");
#endif

        PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
        PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      for (uint32_t i=0; i<_param->_nb_context; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"predict_"+toString(i),
				     dest,"predict_"+toString(i));
#endif
	  
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_VAL"                        ,
		              dest, "in_PREDICT_"+toString(i)+"_VAL"                        );
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_ACK"                        ,
		              dest,"out_PREDICT_"+toString(i)+"_ACK"                        );
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_PC_PREVIOUS"                ,
		              dest, "in_PREDICT_"+toString(i)+"_PC_PREVIOUS"                );
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_PC_CURRENT"                 ,
		              dest, "in_PREDICT_"+toString(i)+"_PC_CURRENT"                 );
	  PORT_MAP(_component,src , "in_PREDICT_"+toString(i)+"_PC_CURRENT_IS_DS_TAKE"      ,
		              dest, "in_PREDICT_"+toString(i)+"_PC_CURRENT_IS_DS_TAKE"      );
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_PC_NEXT"                    ,
		              dest,"out_PREDICT_"+toString(i)+"_PC_NEXT"                    );
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_PC_NEXT_IS_DS_TAKE"         ,
		              dest,"out_PREDICT_"+toString(i)+"_PC_NEXT_IS_DS_TAKE"         );
	  if (_param->_have_port_inst_ifetch_ptr)
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_INST_IFETCH_PTR"            ,
		              dest,"out_PREDICT_"+toString(i)+"_INST_IFETCH_PTR"            );
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_BRANCH_STATE"               ,
		              dest,"out_PREDICT_"+toString(i)+"_BRANCH_STATE"               );
	  if (_param->_have_port_depth)
	  PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_BRANCH_UPDATE_PREDICTION_ID",
		              dest,"out_PREDICT_"+toString(i)+"_BRANCH_UPDATE_PREDICTION_ID");
	  
	  for (uint32_t j=0; j<_param->_nb_instruction[i]; j++)
	    {
	      dest = _name;
#ifdef POSITION
	      _component->interface_map (src ,"predict_"+toString(i)+"_"+toString(j),
					 dest,"predict_"+toString(i)+"_"+toString(j));
#endif
	      
	      PORT_MAP(_component,src ,"out_PREDICT_"+toString(i)+"_"+toString(j)+"_INSTRUCTION_ENABLE",
		                  dest,"out_PREDICT_"+toString(i)+"_"+toString(j)+"_INSTRUCTION_ENABLE");
	    }
	}

      for (uint32_t i=0; i<_param->_nb_decod_unit; i++)
	for (uint32_t j=0; j<_param->_nb_inst_decod[i]; j++)
	  {
	    dest = _name;
#ifdef POSITION
	    _component->interface_map (src ,"decod_"+toString(i),
				       dest,"decod_"+toString(i));
#endif
	    
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_VAL"                        ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_VAL"                        );
	    PORT_MAP(_component,src ,"out_DECOD_"+toString(i)+"_"+toString(j)+"_ACK"                        ,
		                dest,"out_DECOD_"+toString(i)+"_"+toString(j)+"_ACK"                        );
	    if (_param->_have_port_context_id)
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"                 ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"                 );
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_MATCH_INST_IFETCH_PTR"      ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_MATCH_INST_IFETCH_PTR"      );
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_STATE"               ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_STATE"               );
	    if (_param->_have_port_depth)
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_UPDATE_PREDICTION_ID",
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_UPDATE_PREDICTION_ID");
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_CONDITION"           ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_CONDITION"           );
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_DIRECTION"           ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_BRANCH_DIRECTION"           );
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_ADDRESS_SRC"                ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_ADDRESS_SRC"                );
	    PORT_MAP(_component,src , "in_DECOD_"+toString(i)+"_"+toString(j)+"_ADDRESS_DEST"               ,
		                dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_ADDRESS_DEST"               );
	  }

//       for (uint32_t i=0; i<_param->_nb_context; i++)
// 	{
// 	  dest = _name;
// #ifdef POSITION
// 	  _component->interface_map (src ,"depth_"+toString(i),
// 				     dest,"depth_"+toString(i));
// #endif
	  
// 	  PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_NB_BRANCH",dest,"out_DEPTH_"+toString(i)+"_NB_BRANCH");
// 	  if (_param->_have_port_depth)
// 	  PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_TAIL"     ,dest,"out_DEPTH_"+toString(i)+"_TAIL"     );
// 	}
    }

    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if DEBUG_Prediction_unit == true
    _component->test_map();
#endif

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Prediction_unit,FUNCTION,"End");
  };

}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
