#ifdef VHDL

/*
 * $Id: Vhdl_set_body_component_port_map.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_body_component_port_map"
  void Vhdl::set_body_component_port_map (std::list<std::string> & list_port_map      ,
					  std::string              name_port          ,
					  uint32_t                 size_port          ,
					  std::string              name_signal        ,
					  uint32_t                 size_signal        )
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    if (size_port > size_signal)
      throw (ErrorMorpheo ("<Vhdl::set_body_component_port_map> size of port '"+name_port+"' ("+toString(size_port)+") is greater than size of signal '"+name_signal+"' ("+toString(size_signal)+")."));

    std::string str_size = "";

    // test if size is different (possible if multi write
    if (size_port != size_signal)
      str_size = std_logic_range(size_port);
    
    set_list(list_port_map, name_port + "\t=>" + name_signal+str_size);
      
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
