/*
 * $Id: Core_Glue_allocation.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Core_Glue/include/Core_Glue.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace core_glue {



#undef  FUNCTION
#define FUNCTION "Core_Glue::allocation"
  void Core_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Core_Glue,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Core_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
    {
      ALLOC2_INTERFACE("rename",SOUTH,OUT,_("Request between the decod unit and the rename unit"),_param->_nb_front_end,_param->_nb_inst_decod[it1]);

      _ALLOC2_SIGNAL_OUT(out_RENAME_FRONT_END_ID                       ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
    }

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE("branch_complete_front_end",SOUTH,OUT,_("Branch complete : request between commit unit and prediction unit"),_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
    
      _ALLOC2_SIGNAL_OUT(out_BRANCH_COMPLETE_FRONT_END_VAL             ,"VAL"                  ,Tcontrol_t        ,1                                ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_FRONT_END_ACK             ,"ACK"                  ,Tcontrol_t        ,1                                ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_OUT(out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id         ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_OUT(out_BRANCH_COMPLETE_FRONT_END_DEPTH           ,"DEPTH"                ,Tdepth_t          ,_param->_size_depth              ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_OUT(out_BRANCH_COMPLETE_FRONT_END_ADDRESS         ,"ADDRESS"              ,Taddress_t        ,_param->_size_instruction_address,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_OUT(out_BRANCH_COMPLETE_FRONT_END_FLAG            ,"FLAG"                 ,Tcontrol_t        ,1                                ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION ,"MISS_PREDICTION"      ,Tcontrol_t        ,1                                ,_param->_nb_front_end,_param->_front_end_nb_inst_branch_complete[it1]);
    }
    {
      ALLOC2_INTERFACE("branch_complete_ooo_engine",SOUTH,IN ,_("Branch complete : request between commit unit and prediction unit"),_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);

      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_OOO_ENGINE_VAL            ,"VAL"                  ,Tcontrol_t        ,1                                ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_OUT(out_BRANCH_COMPLETE_OOO_ENGINE_ACK            ,"ACK"                  ,Tcontrol_t        ,1                                ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id       ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id         ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          ,"DEPTH"                ,Tdepth_t          ,_param->_size_depth              ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        ,"ADDRESS"              ,Taddress_t        ,_param->_size_instruction_address,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_IN ( in_BRANCH_COMPLETE_OOO_ENGINE_FLAG           ,"FLAG"                 ,Tcontrol_t        ,1                                ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
      _ALLOC2_SIGNAL_OUT(out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION,"MISS_PREDICTION"      ,Tcontrol_t        ,1                                ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_inst_branch_complete[it1]);
    }

    // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("commit_event_front_end",SOUTH,OUT,_("Commit event : request between commit unit and context state"),_param->_nb_front_end);

      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_VAL                ,"VAL"                  ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_FRONT_END_ACK                ,"ACK"                  ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_CONTEXT_ID         ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_DEPTH              ,"DEPTH"                ,Tdepth_t          ,_param->_size_depth);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_TYPE               ,"TYPE"                 ,Tevent_type_t     ,_param->_size_event_type);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT      ,"IS_DELAY_SLOT"        ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_ADDRESS            ,"ADDRESS"              ,Taddress_t        ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR       ,"ADDRESS_EPCR"         ,Taddress_t        ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL   ,"ADDRESS_EEAR_VAL"     ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR       ,"ADDRESS_EEAR"         ,Tgeneral_data_t   ,_param->_size_general_data);
    }

    {
      ALLOC1_INTERFACE("commit_event_ooo_engine",SOUTH,IN ,_("Commit event : request between commit unit and context state"),_param->_nb_ooo_engine);

      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_VAL               ,"VAL"                  ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_OUT(out_COMMIT_EVENT_OOO_ENGINE_ACK               ,"ACK"                  ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID      ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID        ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_DEPTH             ,"DEPTH"                ,Tdepth_t          ,_param->_size_depth);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_TYPE              ,"TYPE"                 ,Tevent_type_t     ,_param->_size_event_type);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT     ,"IS_DELAY_SLOT"        ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS           ,"ADDRESS"              ,Taddress_t        ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR      ,"ADDRESS_EPCR"         ,Taddress_t        ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL  ,"ADDRESS_EEAR_VAL"     ,Tcontrol_t        ,1);
      ALLOC1_SIGNAL_IN ( in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR      ,"ADDRESS_EEAR"         ,Tgeneral_data_t   ,_param->_size_general_data);
    }

    // ~~~~~[ Interface : "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE("issue_ooo_engine",SOUTH,IN ,_("Issue : request between rename unit and execute loop"),_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);

      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_VAL                      ,"VAL"                  ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_OOO_ENGINE_ACK                      ,"ACK"                  ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_FRONT_END_ID             ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id    ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_CONTEXT_ID               ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id      ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_PACKET_ID                ,"PACKET_ID"            ,Tpacket_t         ,_param->_size_rob_ptr         ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_TYPE                     ,"TYPE"                 ,Ttype_t           ,_param->_size_type            ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_OPERATION                ,"OPERATION"            ,Toperation_t      ,_param->_size_operation       ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    ,"STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_size_store_queue_ptr ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     ,"LOAD_QUEUE_PTR_WRITE" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr  ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             ,"HAS_IMMEDIAT"         ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_IMMEDIAT                 ,"IMMEDIAT"             ,Tgeneral_data_t   ,_param->_size_general_data    ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_READ_RA                  ,"READ_RA"              ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_NUM_REG_RA               ,"NUM_REG_RA"           ,Tgeneral_address_t,_param->_size_general_register,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_READ_RB                  ,"READ_RB"              ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_NUM_REG_RB               ,"NUM_REG_RB"           ,Tgeneral_address_t,_param->_size_general_register,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_READ_RC                  ,"READ_RC"              ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_NUM_REG_RC               ,"NUM_REG_RC"           ,Tspecial_address_t,_param->_size_special_register,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_WRITE_RD                 ,"WRITE_RD"             ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_NUM_REG_RD               ,"NUM_REG_RD"           ,Tgeneral_address_t,_param->_size_general_register,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_WRITE_RE                 ,"WRITE_RE"             ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_NUM_REG_RE               ,"NUM_REG_RE"           ,Tspecial_address_t,_param->_size_special_register,_param->_nb_ooo_engine,_param->_nb_inst_issue[it1]);
    }

    {
      ALLOC2_INTERFACE("issue_execute_loop",SOUTH,OUT,_("Issue : request between rename unit and execute loop"),_param->_nb_execute_loop,_param->_nb_read_unit[it1]);

      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_VAL                    ,"VAL"                  ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_ISSUE_EXECUTE_LOOP_ACK                    ,"ACK"                  ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id      ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID          ,"OOO_ENGINE_ID"        ,Tcontext_t        ,_param->_size_ooo_engine_id   ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_PACKET_ID              ,"PACKET_ID"            ,Tpacket_t         ,_param->_size_rob_ptr         ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_OPERATION              ,"OPERATION"            ,Toperation_t      ,_param->_size_operation       ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_TYPE                   ,"TYPE"                 ,Ttype_t           ,_param->_size_type            ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  ,"STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_size_store_queue_ptr ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   ,"LOAD_QUEUE_PTR_WRITE" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr  ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           ,"HAS_IMMEDIAT"         ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_IMMEDIAT               ,"IMMEDIAT"             ,Tgeneral_data_t   ,_param->_size_general_data    ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_READ_RA                ,"READ_RA"              ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             ,"NUM_REG_RA"           ,Tgeneral_address_t,_param->_size_general_register,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_READ_RB                ,"READ_RB"              ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             ,"NUM_REG_RB"           ,Tgeneral_address_t,_param->_size_general_register,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_READ_RC                ,"READ_RC"              ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             ,"NUM_REG_RC"           ,Tspecial_address_t,_param->_size_special_register,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_WRITE_RD               ,"WRITE_RD"             ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             ,"NUM_REG_RD"           ,Tgeneral_address_t,_param->_size_general_register,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_WRITE_RE               ,"WRITE_RE"             ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             ,"NUM_REG_RE"           ,Tspecial_address_t,_param->_size_special_register,_param->_nb_execute_loop,_param->_nb_read_unit[it1]);
    }

    // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC3_INTERFACE("execute_ooo_engine",SOUTH,OUT,_("Execute : request between execute loop and commit unit"),_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);

      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_VAL                    ,"VAL"                  ,Tcontrol_t        ,1                         ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_IN ( in_EXECUTE_OOO_ENGINE_ACK                    ,"ACK"                  ,Tcontrol_t        ,1                         ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_FRONT_END_ID           ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_CONTEXT_ID             ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id  ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_PACKET_ID              ,"PACKET_ID"            ,Tpacket_t         ,_param->_size_rob_ptr     ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//    _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_TYPE                   ,"TYPE"                 ,Ttype_t           ,_param->_size_type        ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
//    _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_OPERATION              ,"OPERATION"            ,Toperation_t      ,_param->_size_operation   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_FLAGS                  ,"FLAGS"                ,Tspecial_data_t   ,_param->_size_special_data,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_EXCEPTION              ,"EXCEPTION"            ,Texception_t      ,_param->_size_exception   ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_NO_SEQUENCE            ,"NO_SEQUENCE"          ,Tcontrol_t        ,1                         ,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_ADDRESS                ,"ADDRESS"              ,Taddress_t        ,_param->_size_instruction_address,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_EXECUTE_OOO_ENGINE_DATA                   ,"DATA"                 ,Tgeneral_data_t   ,_param->_size_general_data,_param->_nb_ooo_engine,_param->_ooo_engine_nb_execute_loop[it1],_param->_nb_inst_execute[it1][it2]);
    }

    {
      ALLOC2_INTERFACE("execute_execute_loop",SOUTH,IN ,_("Execute : request between execute loop and commit unit"),_param->_nb_execute_loop,_param->_nb_write_unit[it1]);

      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_VAL                  ,"VAL"                  ,Tcontrol_t        ,1                          ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_OUT(out_EXECUTE_EXECUTE_LOOP_ACK                  ,"ACK"                  ,Tcontrol_t        ,1                          ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID           ,"CONTEXT_ID"           ,Tcontext_t        ,_param->_size_context_id   ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID         ,"FRONT_END_ID"         ,Tcontext_t        ,_param->_size_front_end_id ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID        ,"OOO_ENGINE_ID"        ,Tcontext_t        ,_param->_size_ooo_engine_id,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_PACKET_ID            ,"PACKET_ID"            ,Tpacket_t         ,_param->_size_rob_ptr      ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//    _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_TYPE                 ,"TYPE"                 ,Ttype_t           ,_param->_size_type         ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
//    _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_OPERATION            ,"OPERATION"            ,Toperation_t      ,_param->_size_operation    ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_FLAGS                ,"FLAGS"                ,Tspecial_data_t   ,_param->_size_special_data ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_EXCEPTION            ,"EXCEPTION"            ,Texception_t      ,_param->_size_exception    ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE          ,"NO_SEQUENCE"          ,Tcontrol_t        ,1                          ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_ADDRESS              ,"ADDRESS"              ,Taddress_t        ,_param->_size_instruction_address,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_EXECUTE_LOOP_DATA                 ,"DATA"                 ,Tgeneral_data_t   ,_param->_size_general_data ,_param->_nb_execute_loop,_param->_nb_write_unit[it1]);
    }

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE("insert_ooo_engine",SOUTH,IN ,_("Insert"),_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
      
      _ALLOC2_SIGNAL_IN ( in_INSERT_OOO_ENGINE_VAL       ,"VAL"       ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_OOO_ENGINE_ACK       ,"ACK"       ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_OOO_ENGINE_RD_USE    ,"RD_USE"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_OOO_ENGINE_RD_NUM_REG,"RD_NUM_REG",Tgeneral_address_t,_param->_size_general_register,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_OOO_ENGINE_RE_USE    ,"RE_USE"    ,Tcontrol_t        ,1                             ,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_OOO_ENGINE_RE_NUM_REG,"RE_NUM_REG",Tspecial_address_t,_param->_size_special_register,_param->_nb_ooo_engine,_param->_nb_inst_insert[it1]);
    }
    
    {
      ALLOC3_INTERFACE("insert_execute_loop",SOUTH,IN ,_("Insert"),_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
      
      _ALLOC3_SIGNAL_OUT(out_INSERT_EXECUTE_LOOP_VAL       ,"VAL"       ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
      _ALLOC3_SIGNAL_IN ( in_INSERT_EXECUTE_LOOP_ACK       ,"ACK"       ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_INSERT_EXECUTE_LOOP_RD_USE    ,"RD_USE"    ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_INSERT_EXECUTE_LOOP_RD_NUM_REG,"RD_NUM_REG",Tgeneral_address_t,_param->_size_general_register,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_INSERT_EXECUTE_LOOP_RE_USE    ,"RE_USE"    ,Tcontrol_t        ,1                             ,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
      _ALLOC3_SIGNAL_OUT(out_INSERT_EXECUTE_LOOP_RE_NUM_REG,"RE_NUM_REG",Tspecial_address_t,_param->_size_special_register,_param->_nb_execute_loop,_param->_execute_loop_nb_ooo_engine[it1],_param->_execute_loop_nb_inst_insert[it1][it2]);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _priority  = new generic::priority::Priority * [_param->_nb_execute_loop];

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      _priority [i] = new generic::priority::Priority (_name+"_priority_"+toString(i),
                                                       _param->_dispatch_priority      ,
                                                       _param->_dispatch_load_balancing,
                                                       _param->_execute_loop_nb_ooo_engine [i],
                                                       _param->_execute_loop_nb_inst_issue [i],
                                                       _param->_execute_loop_nb_ooo_engine [i]
                                                       );


#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Core_Glue,FUNCTION);
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
