#ifdef VHDL
/*
 * $Id: Reservation_station_vhdl_declaration.cpp 97 2008-12-19 15:34:00Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {


#undef  FUNCTION
#define FUNCTION "Reservation_station::vhdl_declaration"
  void Reservation_station::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");

    vhdl->set_type ("Tcontrol        ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(1));
    if (_param->_have_port_context_id)            
    vhdl->set_type ("Tcontext_id     ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_context_id));
    if (_param->_have_port_front_end_id)          
    vhdl->set_type ("Tfront_end_id   ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_front_end_id));
    if (_param->_have_port_ooo_engine_id)         
    vhdl->set_type ("Tooo_engine_id  ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_ooo_engine_id));
    if (_param->_have_port_rob_ptr)	          
    vhdl->set_type ("Trob_id         ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_rob_ptr));
    vhdl->set_type ("Toperation      ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_operation));
    vhdl->set_type ("Ttype           ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_type));
    vhdl->set_type ("Tgeneral_data   ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_general_data));
    vhdl->set_type ("Tspecial_data   ","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_special_data));    
    vhdl->set_type ("Tgeneral_address","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_general_register));
    vhdl->set_type ("Tspecial_address","array (" + toString(_param->_size_queue-1) + " downto 0) of " + std_logic(_param->_size_special_register));    

    vhdl->set_signal("reg_VAL                     ","Tcontrol");
    if (_param->_have_port_context_id)            
    vhdl->set_signal("reg_CONTEXT_ID              ","Tcontext_id");
    if (_param->_have_port_front_end_id)          
    vhdl->set_signal("reg_FRONT_END_ID            ","Tfront_end_id");
    if (_param->_have_port_ooo_engine_id)         
    vhdl->set_signal("reg_OOO_ENGINE_ID           ","Tooo_engine_id");
    if (_param->_have_port_rob_ptr)	          
    vhdl->set_signal("reg_ROB_ID                  ","Trob_id");
    vhdl->set_signal("reg_OPERATION               ","Toperation");
    vhdl->set_signal("reg_TYPE                    ","Ttype");
    vhdl->set_signal("reg_HAS_IMMEDIAT            ","Tcontrol");
    vhdl->set_signal("reg_IMMEDIAT                ","Tgeneral_data");
    vhdl->set_signal("reg_NUM_REG_RA              ","Tgeneral_address");
    vhdl->set_signal("reg_DATA_RA_VAL             ","Tcontrol");
    vhdl->set_signal("reg_DATA_RA                 ","Tgeneral_data");
    vhdl->set_signal("reg_NUM_REG_RB              ","Tgeneral_address");
    vhdl->set_signal("reg_DATA_RB_VAL             ","Tcontrol");
    vhdl->set_signal("reg_DATA_RB                 ","Tgeneral_data");
    vhdl->set_signal("reg_NUM_REG_RC              ","Tspecial_address");
    vhdl->set_signal("reg_DATA_RC_VAL             ","Tcontrol");
    vhdl->set_signal("reg_DATA_RC                 ","Tspecial_data");
    vhdl->set_signal("reg_WRITE_RD                ","Tcontrol");
    vhdl->set_signal("reg_NUM_REG_RD              ","Tgeneral_address");
    vhdl->set_signal("reg_WRITE_RE                ","Tcontrol");
    vhdl->set_signal("reg_NUM_REG_RE              ","Tspecial_address");

    if (_param->_size_queue == 1)
      vhdl->set_alias(" internal_FULL               ",1,"internal_INSERT_SLOT","");
    else
      vhdl->set_alias(" internal_FULL               ",1,"internal_INSERT_SLOT","("+toString(log2(_param->_size_queue))+")");
//  vhdl->set_signal("internal_EMPTY              ",1);

    vhdl->set_signal("internal_INSERT_TRANSACTION ",1);
    vhdl->set_signal("internal_INSERT_SLOT        ",log2(_param->_size_queue)+1);

    
    for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
      {
	vhdl->set_signal("internal_RETIRE_TRANSACTION_"+toString(i),1);
	vhdl->set_signal("internal_RETIRE_SLOT_"+toString(i)+"      ",log2(_param->_size_queue)+1);
      }
    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
