#ifndef morpheo_behavioural_core_multi_front_end_front_end_front_end_glue_Front_end_Glue_h
#define morpheo_behavioural_core_multi_front_end_front_end_front_end_glue_Front_end_Glue_h

/*
 * $Id: Front_end_Glue.h 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Front_end_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace front_end_glue {


  class Front_end_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                        *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)              *  in_NRESET       ;

    // ~~~~~[ Interface : "ifetch" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontext_t           ) *** out_IFETCH_DECOD_UNIT_CONTEXT_ID                     ;//[nb_decod_unit][nb_decod_unit_context]

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontext_t           ) *** out_DECOD_CONTEXT_ID                                 ;//[nb_decod_unit][nb_inst_decod]
  public    : SC_IN (Tcontext_t           ) ***  in_DECOD_DECOD_UNIT_CONTEXT_ID                      ;//[nb_decod_unit][nb_inst_decod]
    
    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           )  **  in_BRANCH_COMPLETE_VAL                              ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t           )  ** out_BRANCH_COMPLETE_ACK                              ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t           )  ** out_BRANCH_COMPLETE_MISS_PREDICTION                  ;//[nb_inst_branch_complete]
                                            
  public    : SC_OUT(Tcontrol_t           )  ** out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL              ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t           )  **  in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK              ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t           )  **  in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION  ;//[nb_inst_branch_complete]
                                            
  public    : SC_OUT(Tcontrol_t           )  ** out_BRANCH_COMPLETE_CONTEXT_STATE_VAL                ;//[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t           )  **  in_BRANCH_COMPLETE_CONTEXT_STATE_ACK                ;//[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t           )  ** out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION    ;//[nb_inst_branch_complete]

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_VAL                                         ;//[nb_context]
  public    : SC_IN (Tcontrol_t           )  **  in_EVENT_ACK                                         ;//[nb_context]
  public    : SC_OUT(Taddress_t           )  ** out_EVENT_ADDRESS                                     ;//[nb_context]
  public    : SC_OUT(Taddress_t           )  ** out_EVENT_ADDRESS_NEXT                                ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_ADDRESS_NEXT_VAL                            ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_IS_DS_TAKE                                  ;//[nb_context]
                                            
  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_IFETCH_UNIT_VAL                             ;//[nb_context]
  public    : SC_IN (Tcontrol_t           )  **  in_EVENT_IFETCH_UNIT_ACK                             ;//[nb_context]
  public    : SC_OUT(Taddress_t           )  ** out_EVENT_IFETCH_UNIT_ADDRESS                         ;//[nb_context]
  public    : SC_OUT(Taddress_t           )  ** out_EVENT_IFETCH_UNIT_ADDRESS_NEXT                    ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_IFETCH_UNIT_ADDRESS_NEXT_VAL                ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_IFETCH_UNIT_IS_DS_TAKE                      ;//[nb_context]

  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_PREDICTION_UNIT_VAL                         ;//[nb_context]
  public    : SC_IN (Tcontrol_t           )  **  in_EVENT_PREDICTION_UNIT_ACK                         ;//[nb_context]
  public    : SC_OUT(Tevent_type_t        )  ** out_EVENT_PREDICTION_UNIT_TYPE                        ;//[nb_context]
  public    : SC_OUT(Tdepth_t             )  ** out_EVENT_PREDICTION_UNIT_DEPTH                       ;//[nb_context]
                                            
  public    : SC_IN (Tcontrol_t           )  **  in_EVENT_CONTEXT_STATE_VAL                           ;//[nb_context]
  public    : SC_OUT(Tcontrol_t           )  ** out_EVENT_CONTEXT_STATE_ACK                           ;//[nb_context]
  public    : SC_IN (Taddress_t           )  **  in_EVENT_CONTEXT_STATE_ADDRESS                       ;//[nb_context]
  public    : SC_IN (Taddress_t           )  **  in_EVENT_CONTEXT_STATE_ADDRESS_NEXT                  ;//[nb_context]
  public    : SC_IN (Tcontrol_t           )  **  in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL              ;//[nb_context]
  public    : SC_IN (Tcontrol_t           )  **  in_EVENT_CONTEXT_STATE_IS_DS_TAKE                    ;//[nb_context]
  public    : SC_IN (Tevent_type_t        )  **  in_EVENT_CONTEXT_STATE_TYPE                          ;//[nb_context]
  public    : SC_IN (Tdepth_t             )  **  in_EVENT_CONTEXT_STATE_DEPTH                         ;//[nb_context]

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
  public    : SC_OUT(Tdepth_t             )  ** out_DEPTH_MIN                                         ;//[nb_context]
  public    : SC_OUT(Tdepth_t             )  ** out_DEPTH_MAX                                         ;//[nb_context]
                                            
  public    : SC_IN (Tdepth_t             )  **  in_DEPTH_PREDICTION_UNIT_CURRENT                     ;//[nb_context]
  public    : SC_IN (Tdepth_t             )  **  in_DEPTH_PREDICTION_UNIT_MIN                         ;//[nb_context]
  public    : SC_IN (Tdepth_t             )  **  in_DEPTH_PREDICTION_UNIT_MAX                         ;//[nb_context]
                                            
//public    : SC_OUT(Tdepth_t             ) *** out_DEPTH_DECOD_UNIT_CURRENT                          ;//[nb_decod_unit][nb_decod_unit_context]
  public    : SC_OUT(Tdepth_t             ) *** out_DEPTH_DECOD_UNIT_MIN                              ;//[nb_decod_unit][nb_decod_unit_context]
  public    : SC_OUT(Tdepth_t             ) *** out_DEPTH_DECOD_UNIT_MAX                              ;//[nb_decod_unit][nb_decod_unit_context]
                                            
  public    : SC_OUT(Tdepth_t             )  ** out_DEPTH_CONTEXT_STATE_MIN                           ;//[nb_context]

    // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tdepth_t             ) *** out_CONTEXT_DECOD_UNIT_DEPTH                          ;//[nb_decod_unit][nb_decod_unit_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Front_end_Glue);
#endif
  public  :          Front_end_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Front_end_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);
  public  : void        genMealy_decod            (void);
  public  : void        genMealy_branch_complete  (void);
  public  : void        genMealy_event            (void);
  public  : void        genMealy_depth            (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace front_end_glue
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
