#ifdef VHDL
/*
 * $Id: Execute_queue_vhdl_declaration.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::vhdl_declaration"
  void Execute_queue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    vhdl->set_alias  ("internal_QUEUE_INSERT_VAL     ",1," in_EXECUTE_QUEUE_IN_VAL",std_logic_range(1));
    vhdl->set_alias  ("internal_QUEUE_INSERT_ACK     ",1,"out_EXECUTE_QUEUE_IN_ACK",std_logic_range(1));
    vhdl->set_signal ("internal_QUEUE_INSERT_DATA    ",_param->_size_internal_queue);
    vhdl->set_signal ("internal_QUEUE_RETIRE_DATA    ",_param->_size_internal_queue);
    vhdl->set_alias  ("internal_QUEUE_RETIRE_VAL     ",1,"out_EXECUTE_QUEUE_OUT_VAL",std_logic_range(1));
    vhdl->set_alias  ("internal_QUEUE_RETIRE_ACK     ",1," in_EXECUTE_QUEUE_OUT_ACK",std_logic_range(1));

    uint32_t min = 0;
    uint32_t max, size;

    if(_param->_have_port_context_id   )
      {
        size = _param->_size_context_id;
        max = min-1+size;
        vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_CONTEXT_ID           ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min = max+1;
      }
    if(_param->_have_port_front_end_id   )
      {
        size = _param->_size_front_end_id;
        max = min-1+size;
        vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_FRONT_END_ID         ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min = max+1;
      }
    if(_param->_have_port_ooo_engine_id   )
      {
        size = _param->_size_ooo_engine_id;
        max = min-1+size;
        vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID        ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min = max+1;
      }
    if(_param->_have_port_rob_ptr)
      {
        size = _param->_size_rob_ptr;
        max = min-1+size;
        vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_PACKET_ID            ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min = max+1;
      }

//  size = _param->_size_operation;
//  max = min-1+size;
//  vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_OPERATION            ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
//  min = max+1;
//
//  size = _param->_size_type;
//  max = min-1+size;
//  vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_TYPE                 ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
//  min = max+1;

    size = _param->_size_special_data;
    max = min-1+size;
    vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_FLAGS                ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_exception;    
    max = min-1+size;
    vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_EXCEPTION            ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_NO_SEQUENCE          ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_instruction_address;
    max = min-1+size;
    vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_ADDRESS              ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_general_data;
    max = min-1+size;
    vhdl->set_alias ("internal_EXECUTE_QUEUE_OUT_DATA                 ",std_logic(size),"internal_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;


//     for (uint32_t i=0; i<_param->_size_queue; ++i)
//       {
//      if (_param->_have_port_context_id)
//      vhdl->set_signal("reg_CONTEXT_ID_"+toString(i),_param->_size_context_id);
//      if (_param->_have_port_front_end_id)
//      vhdl->set_signal("reg_FRONT_END_ID_"+toString(i),_param->_size_front_end_id);
//      if (_param->_have_port_ooo_engine_id)
//      vhdl->set_signal("reg_OOO_ENGINE_ID_"+toString(i),_param->_size_ooo_engine_id);
//      if (_param->_have_port_rob_ptr)
//      vhdl->set_signal("reg_PACKET_ID_"+toString(i),_param->_size_rob_ptr);
//      vhdl->set_signal("reg_FLAGS_"+toString(i),_param->_size_special_data);
//      vhdl->set_signal("reg_EXCEPTION_"+toString(i),_param->_size_exception);
//      vhdl->set_signal("reg_NO_SEQUENCE_"+toString(i),1);
//      vhdl->set_signal("reg_ADDRESS_"+toString(i),_param->_size_instruction_address);
//      vhdl->set_signal("reg_DATA_"+toString(i),_param->_size_general_data);
//       }

//     vhdl->set_signal("reg_CURRENT_STATE",_param->_size_queue+1);

//     vhdl->set_signal("sig_NEXT_STATE",_param->_size_queue+1);

//     for (uint32_t i=0; i<_param->_size_queue-1; ++i)
//       {
//      vhdl->set_signal("sig_WEN_"+toString(i),1);
//      vhdl->set_signal("sig_SEL_"+toString(i),1);
//       }
//     vhdl->set_signal("sig_WEN_"+toString(_param->_size_queue - 1),1);

//     vhdl->set_signal("sig_IN_ACK",1);
//     vhdl->set_signal("sig_OUT_VAL",1);

//    for (uint32_t i=0; i<_param->_size_queue+1; ++i)
//       vhdl->set_constant("STATE_"+toString(i),_param->_size_queue+1,1<<i);

    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
