/*
 * $Id: test.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

class rob_entry_t
{
public:  bool       val;
public : Taddress_t address;
};



void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Commit_unit * _Commit_unit = new Commit_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL( in_INSERT_VAL                     ," in_INSERT_VAL                     ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL(out_INSERT_ACK                     ,"out_INSERT_ACK                     ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_FRONT_END_ID            ," in_INSERT_FRONT_END_ID            ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_CONTEXT_ID              ," in_INSERT_CONTEXT_ID              ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL(out_INSERT_PACKET_ID               ,"out_INSERT_PACKET_ID               ",Tpacket_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
//ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_ID          ," in_INSERT_RENAME_UNIT_ID          ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_DEPTH                   ," in_INSERT_DEPTH                   ",Tdepth_t          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_TYPE                    ," in_INSERT_TYPE                    ",Ttype_t           ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_OPERATION               ," in_INSERT_OPERATION               ",Toperation_t      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NO_EXECUTE              ," in_INSERT_NO_EXECUTE              ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_IS_DELAY_SLOT           ," in_INSERT_IS_DELAY_SLOT           ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_ADDRESS                 ," in_INSERT_ADDRESS                 ",Taddress_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_EXCEPTION               ," in_INSERT_EXCEPTION               ",Texception_t      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_EXCEPTION_USE           ," in_INSERT_EXCEPTION_USE           ",Texception_t      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_STORE_QUEUE_PTR_WRITE   ," in_INSERT_STORE_QUEUE_PTR_WRITE   ",Tlsq_ptr_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_LOAD_QUEUE_PTR_WRITE    ," in_INSERT_LOAD_QUEUE_PTR_WRITE    ",Tlsq_ptr_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_READ_RA                 ," in_INSERT_READ_RA                 ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RA_LOG          ," in_INSERT_NUM_REG_RA_LOG          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RA_PHY          ," in_INSERT_NUM_REG_RA_PHY          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_READ_RB                 ," in_INSERT_READ_RB                 ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RB_LOG          ," in_INSERT_NUM_REG_RB_LOG          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RB_PHY          ," in_INSERT_NUM_REG_RB_PHY          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_READ_RC                 ," in_INSERT_READ_RC                 ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RC_LOG          ," in_INSERT_NUM_REG_RC_LOG          ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RC_PHY          ," in_INSERT_NUM_REG_RC_PHY          ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_WRITE_RD                ," in_INSERT_WRITE_RD                ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RD_LOG          ," in_INSERT_NUM_REG_RD_LOG          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RD_PHY_OLD      ," in_INSERT_NUM_REG_RD_PHY_OLD      ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RD_PHY_NEW      ," in_INSERT_NUM_REG_RD_PHY_NEW      ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_WRITE_RE                ," in_INSERT_WRITE_RE                ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RE_LOG          ," in_INSERT_NUM_REG_RE_LOG          ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RE_PHY_OLD      ," in_INSERT_NUM_REG_RE_PHY_OLD      ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL( in_INSERT_NUM_REG_RE_PHY_NEW      ," in_INSERT_NUM_REG_RE_PHY_NEW      ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_VAL                     ,"out_RETIRE_VAL                     ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL( in_RETIRE_ACK                     ," in_RETIRE_ACK                     ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_FRONT_END_ID            ,"out_RETIRE_FRONT_END_ID            ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_CONTEXT_ID              ,"out_RETIRE_CONTEXT_ID              ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_ID          ,"out_RETIRE_RENAME_UNIT_ID          ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_EVENT_STATE             ,"out_RETIRE_EVENT_STATE             ",Tevent_state_t    ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_USE_STORE_QUEUE         ,"out_RETIRE_USE_STORE_QUEUE         ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_USE_LOAD_QUEUE          ,"out_RETIRE_USE_LOAD_QUEUE          ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_STORE_QUEUE_PTR_WRITE   ,"out_RETIRE_STORE_QUEUE_PTR_WRITE   ",Tlsq_ptr_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_LOAD_QUEUE_PTR_WRITE    ,"out_RETIRE_LOAD_QUEUE_PTR_WRITE    ",Tlsq_ptr_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_READ_RA                 ,"out_RETIRE_READ_RA                 ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RA_PHY          ,"out_RETIRE_NUM_REG_RA_PHY          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_READ_RB                 ,"out_RETIRE_READ_RB                 ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RB_PHY          ,"out_RETIRE_NUM_REG_RB_PHY          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_READ_RC                 ,"out_RETIRE_READ_RC                 ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RC_PHY          ,"out_RETIRE_NUM_REG_RC_PHY          ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_WRITE_RD                ,"out_RETIRE_WRITE_RD                ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RD_LOG          ,"out_RETIRE_NUM_REG_RD_LOG          ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RD_PHY_OLD      ,"out_RETIRE_NUM_REG_RD_PHY_OLD      ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RD_PHY_NEW      ,"out_RETIRE_NUM_REG_RD_PHY_NEW      ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_WRITE_RE                ,"out_RETIRE_WRITE_RE                ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RE_LOG          ,"out_RETIRE_NUM_REG_RE_LOG          ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RE_PHY_OLD      ,"out_RETIRE_NUM_REG_RE_PHY_OLD      ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC2_SC_SIGNAL(out_RETIRE_NUM_REG_RE_PHY_NEW      ,"out_RETIRE_NUM_REG_RE_PHY_NEW      ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  ALLOC1_SC_SIGNAL( in_COMMIT_VAL                     ," in_COMMIT_VAL               ",Tcontrol_t        ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_ACK                     ,"out_COMMIT_ACK               ",Tcontrol_t        ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_WEN                     ," in_COMMIT_WEN               ",Tcontrol_t        ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_PACKET_ID               ," in_COMMIT_PACKET_ID         ",Tpacket_t         ,_param->_nb_inst_commit);
//ALLOC1_SC_SIGNAL( in_COMMIT_OPERATION               ," in_COMMIT_OPERATION         ",Toperation_t      ,_param->_nb_inst_commit);
//ALLOC1_SC_SIGNAL( in_COMMIT_TYPE                    ," in_COMMIT_TYPE              ",Ttype_t           ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_FLAGS                   ," in_COMMIT_FLAGS             ",Tspecial_data_t   ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_EXCEPTION               ," in_COMMIT_EXCEPTION         ",Texception_t      ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_NO_SEQUENCE             ," in_COMMIT_NO_SEQUENCE       ",Tcontrol_t        ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL( in_COMMIT_ADDRESS                 ," in_COMMIT_ADDRESS           ",Taddress_t        ,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_COMMIT_NUM_REG_RD              ,"out_COMMIT_NUM_REG_RD        ",Tgeneral_address_t,_param->_nb_inst_commit);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_VAL                  ,"out_REEXECUTE_VAL                  ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_ACK                  ," in_REEXECUTE_ACK                  ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_CONTEXT_ID           ,"out_REEXECUTE_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_FRONT_END_ID         ,"out_REEXECUTE_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_PACKET_ID            ,"out_REEXECUTE_PACKET_ID            ",Tpacket_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_OPERATION            ,"out_REEXECUTE_OPERATION            ",Toperation_t      ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_TYPE                 ,"out_REEXECUTE_TYPE                 ",Ttype_t           ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_WRITE,"out_REEXECUTE_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_VAL            ,"out_BRANCH_COMPLETE_VAL            ",Tcontrol_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ACK            ," in_BRANCH_COMPLETE_ACK            ",Tcontrol_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_ID     ,"out_BRANCH_COMPLETE_CONTEXT_ID     ",Tcontext_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ID   ,"out_BRANCH_COMPLETE_FRONT_END_ID   ",Tcontext_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_DEPTH          ,"out_BRANCH_COMPLETE_DEPTH          ",Tdepth_t          ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS        ,"out_BRANCH_COMPLETE_ADDRESS        ",Taddress_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_NO_SEQUENCE    ,"out_BRANCH_COMPLETE_NO_SEQUENCE    ",Tcontrol_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION," in_BRANCH_COMPLETE_MISS_PREDICTION",Tcontrol_t        ,_param->_nb_inst_branch_complete);
  ALLOC_SC_SIGNAL (out_UPDATE_VAL                      ,"out_UPDATE_VAL                      ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_UPDATE_ACK                      ," in_UPDATE_ACK                      ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_UPDATE_CONTEXT_ID               ,"out_UPDATE_CONTEXT_ID               ",Tcontext_t        );
  ALLOC_SC_SIGNAL (out_UPDATE_FRONT_END_ID             ,"out_UPDATE_FRONT_END_ID             ",Tcontext_t        );
  ALLOC_SC_SIGNAL (out_UPDATE_DEPTH                    ,"out_UPDATE_DEPTH                    ",Tdepth_t          );
  ALLOC_SC_SIGNAL (out_UPDATE_TYPE                     ,"out_UPDATE_TYPE                     ",Tevent_type_t     );
  ALLOC_SC_SIGNAL (out_UPDATE_IS_DELAY_SLOT            ,"out_UPDATE_IS_DELAY_SLOT            ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_UPDATE_ADDRESS                  ,"out_UPDATE_ADDRESS                  ",Taddress_t        );
  ALLOC_SC_SIGNAL (out_UPDATE_ADDRESS_EPCR             ,"out_UPDATE_ADDRESS_EPCR             ",Taddress_t        );
  ALLOC_SC_SIGNAL (out_UPDATE_ADDRESS_EEAR_VAL         ,"out_UPDATE_ADDRESS_EEAR_VAL         ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_UPDATE_ADDRESS_EEAR             ,"out_UPDATE_ADDRESS_EEAR             ",Tgeneral_data_t   );

  ALLOC2_SC_SIGNAL( in_EVENT_VAL             ," in_EVENT_VAL             ",Tcontrol_t,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_EVENT_ACK             ,"out_EVENT_ACK             ",Tcontrol_t,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_EVENT_ADDRESS         ," in_EVENT_ADDRESS         ",Taddress_t,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT    ," in_EVENT_ADDRESS_NEXT    ",Taddress_t,_param->_nb_front_end,_param->_nb_context[it1]); 
  ALLOC2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL," in_EVENT_ADDRESS_NEXT_VAL",Tcontrol_t,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_EVENT_IS_DS_TAKE      ," in_EVENT_IS_DS_TAKE      ",Tcontrol_t,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL(out_NB_INST_COMMIT_ALL             ,"out_NB_INST_COMMIT_ALL             ",Tcounter_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_NB_INST_COMMIT_MEM             ,"out_NB_INST_COMMIT_MEM             ",Tcounter_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_DEPTH_MIN                      ," in_DEPTH_MIN                      ",Tdepth_t          ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_DEPTH_MAX                      ," in_DEPTH_MAX                      ",Tdepth_t          ,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL( in_SPR_READ_SR_OVE                ," in_SPR_READ_SR_OVE                ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL(out_SPR_WRITE_VAL                  ,"out_SPR_WRITE_VAL                  ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_WRITE_ACK                  ," in_SPR_WRITE_ACK                  ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_WRITE_SR_F_VAL             ,"out_SPR_WRITE_SR_F_VAL             ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_WRITE_SR_F                 ,"out_SPR_WRITE_SR_F                 ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_WRITE_SR_CY_VAL            ,"out_SPR_WRITE_SR_CY_VAL            ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_WRITE_SR_CY                ,"out_SPR_WRITE_SR_CY                ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_WRITE_SR_OV_VAL            ,"out_SPR_WRITE_SR_OV_VAL            ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_WRITE_SR_OV                ,"out_SPR_WRITE_SR_OV                ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);

  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Commit_unit.\n"),name.c_str());

  (*(_Commit_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Commit_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_VAL                     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_INSERT_ACK                     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_FRONT_END_ID            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_CONTEXT_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_rob_ptr  )
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_INSERT_PACKET_ID               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
//INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_RENAME_UNIT_ID          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_depth)
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_DEPTH                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_TYPE                    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_OPERATION               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_IS_DELAY_SLOT           ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NO_EXECUTE              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_ADDRESS                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_EXCEPTION               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_EXCEPTION_USE           ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_STORE_QUEUE_PTR_WRITE   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_LOAD_QUEUE_PTR_WRITE    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_READ_RA                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RA_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RA_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_READ_RB                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RB_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RB_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_READ_RC                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RC_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RC_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_WRITE_RD                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RD_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RD_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RD_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_WRITE_RE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RE_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RE_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_INSERT_NUM_REG_RE_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_VAL                     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_RETIRE_ACK                     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_FRONT_END_ID            ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_CONTEXT_ID              ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_RENAME_UNIT_ID          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_EVENT_STATE             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_USE_STORE_QUEUE         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_USE_LOAD_QUEUE          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_STORE_QUEUE_PTR_WRITE   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_LOAD_QUEUE_PTR_WRITE    ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_READ_RA                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RA_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_READ_RB                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RB_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_READ_RC                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RC_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_WRITE_RD                ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RD_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RD_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RD_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_WRITE_RE                ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RE_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RE_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_RETIRE_NUM_REG_RE_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_VAL               ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_COMMIT_ACK               ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_WEN               ,_param->_nb_inst_commit);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_PACKET_ID         ,_param->_nb_inst_commit);
//INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_OPERATION         ,_param->_nb_inst_commit);
//INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_TYPE              ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_FLAGS             ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_EXCEPTION         ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_NO_SEQUENCE       ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_COMMIT_ADDRESS           ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_COMMIT_NUM_REG_RD        ,_param->_nb_inst_commit);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_REEXECUTE_VAL                  ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_REEXECUTE_ACK                  ,_param->_nb_inst_reexecute);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_REEXECUTE_CONTEXT_ID           ,_param->_nb_inst_reexecute);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_REEXECUTE_FRONT_END_ID         ,_param->_nb_inst_reexecute);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_REEXECUTE_PACKET_ID            ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_REEXECUTE_OPERATION            ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_REEXECUTE_TYPE                 ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_REEXECUTE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_BRANCH_COMPLETE_FRONT_END_ID   ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Commit_unit,out_BRANCH_COMPLETE_NO_SEQUENCE    ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Commit_unit, in_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_VAL                      );
  INSTANCE_SC_SIGNAL (_Commit_unit, in_UPDATE_ACK                      );
  if (_param->_have_port_context_id)
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_CONTEXT_ID               );
  if (_param->_have_port_front_end_id)
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_FRONT_END_ID             );
  if (_param->_have_port_depth)
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_DEPTH                    );
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_TYPE                     );
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_IS_DELAY_SLOT            );
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_ADDRESS                  );
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_ADDRESS_EPCR             );
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_ADDRESS_EEAR_VAL         );
  INSTANCE_SC_SIGNAL (_Commit_unit,out_UPDATE_ADDRESS_EEAR             );

  INSTANCE2_SC_SIGNAL(_Commit_unit, in_EVENT_VAL                       ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_EVENT_ACK                       ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_EVENT_ADDRESS                   ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_EVENT_ADDRESS_NEXT              ,_param->_nb_front_end, _param->_nb_context[it1]); 
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_EVENT_ADDRESS_NEXT_VAL          ,_param->_nb_front_end, _param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_EVENT_IS_DS_TAKE                ,_param->_nb_front_end, _param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_Commit_unit,out_NB_INST_COMMIT_ALL             ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_NB_INST_COMMIT_MEM             ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_DEPTH_MAX                      ,_param->_nb_front_end,_param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_Commit_unit, in_SPR_READ_SR_OVE                ,_param->_nb_front_end,_param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_Commit_unit,out_SPR_WRITE_VAL                  ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit, in_SPR_WRITE_ACK                  ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_SPR_WRITE_SR_F_VAL             ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_SPR_WRITE_SR_F                 ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_SPR_WRITE_SR_CY_VAL            ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_SPR_WRITE_SR_CY                ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_SPR_WRITE_SR_OV_VAL            ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_Commit_unit,out_SPR_WRITE_SR_OV                ,_param->_nb_front_end,_param->_nb_context[it1]);

  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    for (uint32_t j=0; j<_param->_nb_context[i]; j++)
      if (_param->_have_port_depth)
	INSTANCE_SC_SIGNAL(_Commit_unit, in_DEPTH_MIN  [i][j]);
  
  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  const  int32_t percent_transaction_insert = 75;
  const  int32_t percent_transaction_retire = 75;
  const  int32_t percent_transaction_commit = 75;

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");
  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);
      uint32_t        nb_transaction      = 512;
      uint32_t        address_insert_min  = 0xa000;
      uint32_t        address_insert_max  = address_insert_min + nb_transaction;
      uint32_t        address_insert_next = address_insert_min;
      Taddress_t      tab_address_insert     [_param->_nb_rename_unit][max<uint32_t>(_param->_nb_inst_insert,_param->_nb_rename_unit)];
      list<Tpacket_t> tab_address_commit;

      uint32_t        nb_transaction_insert      = 0;
      uint32_t        nb_transaction_retire      = 0;
      uint32_t        nb_transaction_commit      = 0;


      uint32_t        packet_id_head_grp  = 0;
      uint32_t        packet_id_head_elt  = 0;

      uint32_t        packet_id_tail_grp  = 0;
      uint32_t        packet_id_tail_elt  = 0;

      rob_entry_t      rob [_param->_nb_bank*_param->_size_bank];

      for (uint32_t i=0; i<_param->_nb_bank*_param->_size_bank; i++)
	rob[i].val = false;

      for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
	  tab_address_insert [i][j] = address_insert_next ++;

//       while ((address_insert_next < address_insert_max) or
// 	     (not tab_address_commit.empty()) or
// 	     (nb_transaction_retire < (address_insert_max-address_insert_min)))
      while (nb_transaction_retire < nb_transaction)
	{
	  LABEL("Condition d'arrt :");
	  LABEL(" * total of transaction      : %d",nb_transaction);
	  LABEL(" * nb_transaction_insert     : %d",nb_transaction_insert);
	  LABEL(" * nb_transaction_commit     : %d",nb_transaction_commit);
	  LABEL(" * nb_transaction_retire     : %d",nb_transaction_retire);

	  for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	    {
	      bool     val    = ((rand()%100)<percent_transaction_insert);
	      uint32_t nb_val = (rand()%_param->_nb_inst_insert[i]);
	      for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
		{
		  Taddress_t addr = tab_address_insert [i][j];
		  in_INSERT_VAL                     [i][j]->write(val and (i <= nb_val) and ((nb_transaction_insert+i*_param->_nb_rename_unit+j)<nb_transaction));
		  in_INSERT_FRONT_END_ID            [i][j]->write(0);
		  in_INSERT_CONTEXT_ID              [i][j]->write(0);
		  in_INSERT_DEPTH                   [i][j]->write(0);
		  in_INSERT_TYPE                    [i][j]->write(0);
		  in_INSERT_OPERATION               [i][j]->write(0);
		  in_INSERT_IS_DELAY_SLOT           [i][j]->write(0);
		  in_INSERT_NO_EXECUTE              [i][j]->write(0);
		  in_INSERT_ADDRESS                 [i][j]->write(addr);
		  in_INSERT_EXCEPTION               [i][j]->write(0);
		  in_INSERT_EXCEPTION_USE           [i][j]->write(0);
		  in_INSERT_STORE_QUEUE_PTR_WRITE   [i][j]->write(0);
		  in_INSERT_LOAD_QUEUE_PTR_WRITE    [i][j]->write(0);
		  in_INSERT_READ_RA                 [i][j]->write(0);
		  in_INSERT_NUM_REG_RA_LOG          [i][j]->write(0);
		  in_INSERT_NUM_REG_RA_PHY          [i][j]->write(0);
		  in_INSERT_READ_RB                 [i][j]->write(0);
		  in_INSERT_NUM_REG_RB_LOG          [i][j]->write(0);
		  in_INSERT_NUM_REG_RB_PHY          [i][j]->write(0);
		  in_INSERT_READ_RC                 [i][j]->write(0);
		  in_INSERT_NUM_REG_RC_LOG          [i][j]->write(0);
		  in_INSERT_NUM_REG_RC_PHY          [i][j]->write(0);
		  in_INSERT_WRITE_RD                [i][j]->write(0);
		  in_INSERT_NUM_REG_RD_LOG          [i][j]->write(0);
		  in_INSERT_NUM_REG_RD_PHY_OLD      [i][j]->write(0);
		  in_INSERT_NUM_REG_RD_PHY_NEW      [i][j]->write(0);
		  in_INSERT_WRITE_RE                [i][j]->write(0);
		  in_INSERT_NUM_REG_RE_LOG          [i][j]->write(0);
		  in_INSERT_NUM_REG_RE_PHY_OLD      [i][j]->write(0);
		  in_INSERT_NUM_REG_RE_PHY_NEW      [i][j]->write(0);
		}
	    }

	  for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	    {
	      bool     ack    = ((rand()%100)<percent_transaction_retire);
	      uint32_t nb_ack = rand()%_param->_nb_inst_retire[i];
	      for (uint32_t j=0; j<_param->_nb_inst_retire[i]; j++)
		{
		  in_RETIRE_ACK [i][j]->write(ack and (i <= nb_ack));
		  
		}
	    }

	  {
	    list<Tpacket_t>::iterator it=tab_address_commit.begin();

            for (uint32_t j=0; j<_param->_nb_inst_commit; j++)
              {
                Tcontrol_t val = ((rand()%100)<percent_transaction_commit) and (it!=tab_address_commit.end());
                
                in_COMMIT_VAL [j]->write(val);
                
                if (val)
                  {
                    Tpacket_t packet = *(it);
                    
                    in_COMMIT_WEN         [j]->write(1);
                    in_COMMIT_PACKET_ID   [j]->write(packet);
		    //in_COMMIT_OPERATION   [j]->write(0);
		    //in_COMMIT_TYPE        [j]->write(0);
                    in_COMMIT_FLAGS       [j]->write(0);
                    in_COMMIT_EXCEPTION   [j]->write(0);
                    in_COMMIT_NO_SEQUENCE [j]->write(0);
                    in_COMMIT_ADDRESS     [j]->write(0);
                  }
                
                if (it != tab_address_commit.end())
                  it++;
              }
	  }

	  SC_START(0);

	  for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	    for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
	      {
		LABEL("INSERT            [%d][%d] - %d %d",i,j,in_INSERT_VAL [i][j]->read(),out_INSERT_ACK [i][j]->read());
		if ( in_INSERT_VAL [i][j]->read() and 
		    out_INSERT_ACK [i][j]->read())
		  {
		    LABEL("INSERT            [%d][%d] Transaction Accepted",i,j);
		    LABEL("  * packet_id_tail_grp (old) : %d",packet_id_tail_grp);
		    LABEL("  * packet_id_tail_elt (old) : %d",packet_id_tail_elt);

		    Tpacket_t packet = (_param->_have_port_rob_ptr  )?out_INSERT_PACKET_ID [i][j]->read():0;

		    TEST(Tpacket_t, packet, (packet_id_tail_grp << _param->_shift_num_bank) + packet_id_tail_elt);

		    TEST(bool, rob[packet].val, false);

		    rob[packet].val     = true;
		    rob[packet].address = tab_address_insert [i][j];

		    tab_address_commit.push_back(packet);
		    tab_address_insert [i][j] = address_insert_next ++;

		    packet_id_tail_grp ++;

		    if (packet_id_tail_grp >= _param->_nb_bank)
		      {
			packet_id_tail_grp = 0;
			packet_id_tail_elt = (packet_id_tail_elt+1)%_param->_size_bank;
		      }

		    LABEL("  * packet_id_tail_grp (new) : %d",packet_id_tail_grp);
		    LABEL("  * packet_id_tail_elt (new) : %d",packet_id_tail_elt);

		    nb_transaction_insert ++;
		  }
	      }
	  
	  for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	    for (uint32_t j=0; j<_param->_nb_inst_retire[i]; j++)
	      {
		LABEL("RETIRE            [%d][%d] - %d %d",i,j,out_RETIRE_VAL [i][j]->read(),in_RETIRE_ACK [i][j]->read());
		if (out_RETIRE_VAL [i][j]->read() and 
		     in_RETIRE_ACK [i][j]->read())
		  {
		    LABEL("RETIRE            [%d][%d] Transaction Accepted",i,j);
		    LABEL("  * packet_id_head_grp (old) : %d",packet_id_head_grp);
		    LABEL("  * packet_id_head_elt (old) : %d",packet_id_head_elt);

		    Tpacket_t packet = ((packet_id_head_grp << _param->_shift_num_bank) + packet_id_head_elt);

		    TEST(bool, rob[packet].val, true);

		    rob[packet].val     = false;

		    packet_id_head_grp ++;
		    
		    if (packet_id_head_grp >= _param->_nb_bank)
		      {
			packet_id_head_grp = 0;
			packet_id_head_elt = (packet_id_head_elt+1)%_param->_size_bank;
		      }

		    LABEL("  * packet_id_head_grp (new) : %d",packet_id_head_grp);
		    LABEL("  * packet_id_head_elt (new) : %d",packet_id_head_elt);

		    nb_transaction_retire ++;
		  }
	      }

	  LABEL("Dump tab_address_commit (before)");
	  for (list<Tpacket_t>::iterator it=tab_address_commit.begin();
	       it!=tab_address_commit.end();
	       ++it)
	    LABEL(" * %d",*it);

	  {
	    list<Tpacket_t>::iterator it=tab_address_commit.begin();
	    
            for (uint32_t j=0; j<_param->_nb_inst_commit; j++)
              {
                if ( in_COMMIT_VAL [j]->read() and
                     out_COMMIT_ACK [j]->read())
                  {
                    LABEL("COMMIT      [%d] Transaction Accepted",j);
                    
                    it = tab_address_commit.erase(it);
                    
                    nb_transaction_commit ++;
                  }
                else
                  if (it != tab_address_commit.end())
                    it++;
              }
	  }

	  LABEL("Dump tab_address_commit (after )");
	  for (list<Tpacket_t>::iterator it=tab_address_commit.begin();
	       it!=tab_address_commit.end();
	       ++it)
	    LABEL(" * %d",*it);


	  SC_START(1);
	}

    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_INSERT_VAL                     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ACK                     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_FRONT_END_ID            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_CONTEXT_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_PACKET_ID               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
//DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_ID          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_DEPTH                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_TYPE                    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_OPERATION               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NO_EXECUTE              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_IS_DELAY_SLOT           ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_ADDRESS                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_EXCEPTION               ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_EXCEPTION_USE           ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_STORE_QUEUE_PTR_WRITE   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_LOAD_QUEUE_PTR_WRITE    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_READ_RA                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RA_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RA_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_READ_RB                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RB_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RB_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_READ_RC                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RC_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RC_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_WRITE_RD                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RD_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RD_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RD_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_WRITE_RE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RE_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RE_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_NUM_REG_RE_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_VAL                     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL( in_RETIRE_ACK                     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_FRONT_END_ID            ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_CONTEXT_ID              ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_ID          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_EVENT_STATE             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_USE_STORE_QUEUE         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_USE_LOAD_QUEUE          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_STORE_QUEUE_PTR_WRITE   ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_LOAD_QUEUE_PTR_WRITE    ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_READ_RA                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RA_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_READ_RB                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RB_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_READ_RC                 ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RC_PHY          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_WRITE_RD                ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RD_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RD_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RD_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_WRITE_RE                ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RE_LOG          ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RE_PHY_OLD      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE2_SC_SIGNAL(out_RETIRE_NUM_REG_RE_PHY_NEW      ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
  DELETE1_SC_SIGNAL( in_COMMIT_VAL               ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_ACK               ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_WEN               ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_PACKET_ID         ,_param->_nb_inst_commit);
//DELETE1_SC_SIGNAL( in_COMMIT_OPERATION         ,_param->_nb_inst_commit);
//DELETE1_SC_SIGNAL( in_COMMIT_TYPE              ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_FLAGS             ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_EXCEPTION         ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_NO_SEQUENCE       ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL( in_COMMIT_ADDRESS           ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_COMMIT_NUM_REG_RD        ,_param->_nb_inst_commit);
  DELETE1_SC_SIGNAL(out_REEXECUTE_VAL                  ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_ACK                  ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_CONTEXT_ID           ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_FRONT_END_ID         ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_PACKET_ID            ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_OPERATION            ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_TYPE                 ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ID   ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_NO_SEQUENCE    ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  DELETE_SC_SIGNAL (out_UPDATE_VAL                      );
  DELETE_SC_SIGNAL ( in_UPDATE_ACK                      );
  DELETE_SC_SIGNAL (out_UPDATE_CONTEXT_ID               );
  DELETE_SC_SIGNAL (out_UPDATE_FRONT_END_ID             );
  DELETE_SC_SIGNAL (out_UPDATE_DEPTH                    );
  DELETE_SC_SIGNAL (out_UPDATE_TYPE                     );
  DELETE_SC_SIGNAL (out_UPDATE_IS_DELAY_SLOT            );
  DELETE_SC_SIGNAL (out_UPDATE_ADDRESS                  );
  DELETE_SC_SIGNAL (out_UPDATE_ADDRESS_EPCR             );
  DELETE_SC_SIGNAL (out_UPDATE_ADDRESS_EEAR_VAL         );
  DELETE_SC_SIGNAL (out_UPDATE_ADDRESS_EEAR             );

  DELETE2_SC_SIGNAL( in_EVENT_VAL                       ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_EVENT_ACK                       ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_EVENT_ADDRESS                   ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT              ,_param->_nb_front_end, _param->_nb_context[it1]); 
  DELETE2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL          ,_param->_nb_front_end, _param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_EVENT_IS_DS_TAKE                ,_param->_nb_front_end, _param->_nb_context[it1]);

  DELETE2_SC_SIGNAL(out_NB_INST_COMMIT_ALL             ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_NB_INST_COMMIT_MEM             ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_DEPTH_MIN                      ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_DEPTH_MAX                      ,_param->_nb_front_end,_param->_nb_context[it1]);

  DELETE2_SC_SIGNAL( in_SPR_READ_SR_OVE                ,_param->_nb_front_end,_param->_nb_context[it1]);
  
  DELETE2_SC_SIGNAL(out_SPR_WRITE_VAL                  ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_WRITE_ACK                  ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_WRITE_SR_F_VAL             ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_WRITE_SR_F                 ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_WRITE_SR_CY_VAL            ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_WRITE_SR_CY                ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_WRITE_SR_OV_VAL            ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_WRITE_SR_OV                ,_param->_nb_front_end,_param->_nb_context[it1]);
    }
#endif

  delete _Commit_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
