/*
 * Test_009
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.add
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait)CY OV (SR = r6, mask SR = r5)
                                       (r4)                (r7)
          1) 0x00000000 0x00000000 - 0x00000000 0  0
         
         */

        /* Mask to read OV (SR[11]), CY (SR[10]) and F (SR[9]) */
	l.movhi r5,     hi(0x000000e0)
	l.ori   r5, r5, lo(0x000000e0)

        /**********/
        /* Test 1 */
        /**********/
	l.movhi r1,     hi(0x00000000) /* RA */
	l.ori   r1, r1, lo(0x00000000)
	l.movhi r2,     hi(0x00000000) /* RB */
	l.ori   r2, r2, lo(0x00000000)
	l.movhi r3,     hi(0x00000000) /* RD wait */
	l.ori   r3, r3, lo(0x00000000)
	l.movhi r6,     hi(0x00000000) /* SR wait */
	l.ori   r6, r6, lo(0x00000000)
        
        l.add   r4, r1, r2

        /* Test flag */
        l.mfspr r7, r0, 17
        l.and   r7, r7, r5

        l.sfeq  r6, r7
        l.bnf   _end_ko
        l.nop

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        l.j     _end_ok
        l.nop

