#ifdef SYSTEMC
/*
 * $Id: Branch_Target_Buffer_Glue_genMealy_predict.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Branch_Target_Buffer_Glue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::genMealy_predict"
  void Branch_Target_Buffer_Glue::genMealy_predict (void)
  {
    log_begin(Branch_Target_Buffer_Glue,FUNCTION);
    log_function(Branch_Target_Buffer_Glue,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
      {
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"  * PREDICT [%d]",i);
	Tptr_t          index       = (_param->_have_port_victim)?PORT_READ(in_PREDICT_SORT_INDEX [i]):0;
	Tcontrol_t      hit         = PORT_READ(in_PREDICT_REGISTER_HIT         [i][index]);
	Tgeneral_data_t address_src = PORT_READ(in_PREDICT_REGISTER_ADDRESS_SRC [i][index]);

        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * index        : %d"  ,index      );
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * hit          : %d"  ,hit        );
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * address_src  : %.8x",address_src);

	// Multiplexor
	PORT_WRITE(out_PREDICT_HIT          [i],hit);
	PORT_WRITE(out_PREDICT_ADDRESS_SRC  [i],address_src);
	PORT_WRITE(out_PREDICT_ADDRESS_DEST [i],PORT_READ(in_PREDICT_REGISTER_ADDRESS_DEST  [i][index]));
	PORT_WRITE(out_PREDICT_CONDITION    [i],PORT_READ(in_PREDICT_REGISTER_CONDITION     [i][index]));
	PORT_WRITE(out_PREDICT_LAST_TAKE    [i],PORT_READ(in_PREDICT_REGISTER_LAST_TAKE     [i][index]));
	PORT_WRITE(out_PREDICT_IS_ACCURATE  [i],PORT_READ(in_PREDICT_REGISTER_IS_ACCURATE   [i][index]));

	Tcontrol_t val          = PORT_READ(in_PREDICT_VAL          [i]);
	Tcontrol_t register_ack = PORT_READ(in_PREDICT_REGISTER_ACK [i]);
	Tcontrol_t sort_val     = (_param->_have_port_victim)?PORT_READ(in_PREDICT_SORT_VAL   [i]):true;
	Tcontrol_t victim_ack   = (_param->_have_port_victim)?PORT_READ(in_PREDICT_VICTIM_ACK [i]):true;

        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * val          : %d",val         );
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * register_ack : %d",register_ack);
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * sort_val     : %d",sort_val    );
        log_printf(TRACE,Branch_Target_Buffer_Glue,FUNCTION,"    * victim_ack   : %d",victim_ack  );
	
	PORT_WRITE(out_PREDICT_ACK            [i], (
//                                                  val          and 
                                                    register_ack and
                                                    sort_val     and
                                                    victim_ack
                                                    ));
	PORT_WRITE(out_PREDICT_REGISTER_VAL   [i], (
                                                    val          and 
//                                                  register_ack and
                                                    sort_val     and
                                                    victim_ack
                                                    ));

	if (_param->_have_port_victim)
	  {
	PORT_WRITE(out_PREDICT_VICTIM_VAL     [i], (
                                                    val          and 
                                                    register_ack and
                                                    sort_val     // and
//                                                  victim_ack
                                                    ));
	PORT_WRITE(out_PREDICT_VICTIM_HIT     [i], hit);
	if (not _param->_is_full_associative)
	PORT_WRITE(out_PREDICT_VICTIM_ADDRESS [i], (address_src >> _param->_shift_bank)&_param->_mask_bank);
	PORT_WRITE(out_PREDICT_VICTIM_INDEX   [i], index);
	  }
      }

    log_end(Branch_Target_Buffer_Glue,FUNCTION);
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
