/*
 * $Id: Prediction_unit_deallocation.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/include/Prediction_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {


#undef  FUNCTION
#define FUNCTION "Prediction_unit::deallocation"
  void Prediction_unit::deallocation (void)
  {
    log_printf(FUNC,Prediction_unit,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	DELETE1_SIGNAL( in_PREDICT_VAL                        ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_PREDICT_ACK                        ,_param->_nb_context,1);
	DELETE1_SIGNAL( in_PREDICT_PC_PREVIOUS                ,_param->_nb_context,_param->_size_instruction_address);
	DELETE1_SIGNAL( in_PREDICT_PC_CURRENT                 ,_param->_nb_context,_param->_size_instruction_address);
	DELETE1_SIGNAL( in_PREDICT_PC_CURRENT_IS_DS_TAKE      ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_PREDICT_PC_NEXT                    ,_param->_nb_context,_param->_size_instruction_address);
	DELETE1_SIGNAL(out_PREDICT_PC_NEXT_IS_DS_TAKE         ,_param->_nb_context,1);
	DELETE1_SIGNAL(out_PREDICT_INST_IFETCH_PTR            ,_param->_nb_context,_param->_size_inst_ifetch_ptr);
	DELETE1_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_context,_param->_size_branch_state);
	DELETE1_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_context,_param->_size_depth );

	DELETE2_SIGNAL(out_PREDICT_INSTRUCTION_ENABLE       ,_param->_nb_context,_param->_nb_instruction[it1],1);
	DELETE2_SIGNAL( in_DECOD_VAL                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],1);
	DELETE2_SIGNAL(out_DECOD_ACK                        ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],1);
	DELETE2_SIGNAL( in_DECOD_CONTEXT_ID                 ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_context_id      );
	DELETE2_SIGNAL( in_DECOD_MATCH_INST_IFETCH_PTR      ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],1                             );
	DELETE2_SIGNAL( in_DECOD_BRANCH_STATE               ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_branch_state    );
	DELETE2_SIGNAL( in_DECOD_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_depth           );
	DELETE2_SIGNAL( in_DECOD_BRANCH_CONDITION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_branch_condition);
	DELETE2_SIGNAL( in_DECOD_BRANCH_DIRECTION           ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],1                             );
	DELETE2_SIGNAL( in_DECOD_ADDRESS_SRC                ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_instruction_address         );
	DELETE2_SIGNAL( in_DECOD_ADDRESS_DEST               ,_param->_nb_decod_unit,_param->_nb_inst_decod[it1],_param->_size_instruction_address         );
      
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete,_param->_size_context_id);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete,_param->_size_depth);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_BRANCH_COMPLETE_NO_SEQUENCE    ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_TAKE           ,_param->_nb_inst_branch_complete,1);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_SRC    ,_param->_nb_inst_branch_complete,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_DEST   ,_param->_nb_inst_branch_complete,_param->_size_instruction_address);

        DELETE1_SIGNAL(out_BRANCH_EVENT_VAL              ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_BRANCH_EVENT_ACK              ,_param->_nb_context,1);
//      DELETE1_SIGNAL(out_BRANCH_EVENT_CONTEXT_ID       ,_param->_nb_context,_param->_size_context_id);
//      DELETE1_SIGNAL(out_BRANCH_EVENT_DEPTH            ,_param->_nb_context,_param->_size_depth);
//      DELETE1_SIGNAL(out_BRANCH_EVENT_MISS_PREDICTION  ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_BRANCH_EVENT_ADDRESS_SRC      ,_param->_nb_context,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_BRANCH_EVENT_ADDRESS_DEST_VAL ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_BRANCH_EVENT_ADDRESS_DEST     ,_param->_nb_context,_param->_size_instruction_address);

        DELETE1_SIGNAL( in_EVENT_VAL    ,_param->_nb_context,1);
        DELETE1_SIGNAL(out_EVENT_ACK    ,_param->_nb_context,1);
        DELETE1_SIGNAL( in_EVENT_TYPE   ,_param->_nb_context,_param->_size_event_type );
        DELETE1_SIGNAL( in_EVENT_DEPTH  ,_param->_nb_context,_param->_size_depth      );

        DELETE1_SIGNAL(out_DEPTH_CURRENT      ,_param->_nb_context,_param->_size_depth);
        DELETE1_SIGNAL(out_DEPTH_MIN          ,_param->_nb_context,_param->_size_depth);
        DELETE1_SIGNAL(out_DEPTH_MAX          ,_param->_nb_context,_param->_size_depth+1);
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    delete _component_btb;
    delete _component_dir;
    delete _component_ras;
    delete _component_upt;
    delete _component_glue;

    log_printf(FUNC,Prediction_unit,FUNCTION,"End");
  };

}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
