/*
 * $Id: test.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  OOO_Engine * _OOO_Engine = new OOO_Engine 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL( in_RENAME_VAL                       ," in_RENAME_VAL                       ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL(out_RENAME_ACK                       ,"out_RENAME_ACK                       ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_FRONT_END_ID              ," in_RENAME_FRONT_END_ID              ",Tcontext_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_CONTEXT_ID                ," in_RENAME_CONTEXT_ID                ",Tcontext_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_DEPTH                     ," in_RENAME_DEPTH                     ",Tdepth_t          ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_TYPE                      ," in_RENAME_TYPE                      ",Ttype_t           ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_OPERATION                 ," in_RENAME_OPERATION                 ",Toperation_t      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_NO_EXECUTE                ," in_RENAME_NO_EXECUTE                ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IS_DELAY_SLOT             ," in_RENAME_IS_DELAY_SLOT             ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_ADDRESS                   ," in_RENAME_ADDRESS                   ",Taddress_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_HAS_IMMEDIAT              ," in_RENAME_HAS_IMMEDIAT              ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_IMMEDIAT                  ," in_RENAME_IMMEDIAT                  ",Tgeneral_data_t   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_READ_RA                   ," in_RENAME_READ_RA                   ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_NUM_REG_RA                ," in_RENAME_NUM_REG_RA                ",Tgeneral_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_READ_RB                   ," in_RENAME_READ_RB                   ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_NUM_REG_RB                ," in_RENAME_NUM_REG_RB                ",Tgeneral_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_READ_RC                   ," in_RENAME_READ_RC                   ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_NUM_REG_RC                ," in_RENAME_NUM_REG_RC                ",Tspecial_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_WRITE_RD                  ," in_RENAME_WRITE_RD                  ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_NUM_REG_RD                ," in_RENAME_NUM_REG_RD                ",Tgeneral_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_WRITE_RE                  ," in_RENAME_WRITE_RE                  ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_NUM_REG_RE                ," in_RENAME_NUM_REG_RE                ",Tspecial_address_t,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_EXCEPTION_USE             ," in_RENAME_EXCEPTION_USE             ",Texception_t      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  ALLOC2_SC_SIGNAL( in_RENAME_EXCEPTION                 ," in_RENAME_EXCEPTION                 ",Texception_t      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);

  ALLOC1_SC_SIGNAL(out_ISSUE_VAL                        ,"out_ISSUE_VAL                        ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL( in_ISSUE_ACK                        ," in_ISSUE_ACK                        ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_FRONT_END_ID               ,"out_ISSUE_FRONT_END_ID               ",Tcontext_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_CONTEXT_ID                 ,"out_ISSUE_CONTEXT_ID                 ",Tcontext_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_PACKET_ID                  ,"out_ISSUE_PACKET_ID                  ",Tpacket_t         ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_TYPE                       ,"out_ISSUE_TYPE                       ",Ttype_t           ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OPERATION                  ,"out_ISSUE_OPERATION                  ",Toperation_t      ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_STORE_QUEUE_PTR_WRITE      ,"out_ISSUE_STORE_QUEUE_PTR_WRITE      ",Tlsq_ptr_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_LOAD_QUEUE_PTR_WRITE       ,"out_ISSUE_LOAD_QUEUE_PTR_WRITE       ",Tlsq_ptr_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_HAS_IMMEDIAT               ,"out_ISSUE_HAS_IMMEDIAT               ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_IMMEDIAT                   ,"out_ISSUE_IMMEDIAT                   ",Tgeneral_data_t   ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_READ_RA                    ,"out_ISSUE_READ_RA                    ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_NUM_REG_RA                 ,"out_ISSUE_NUM_REG_RA                 ",Tgeneral_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_READ_RB                    ,"out_ISSUE_READ_RB                    ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_NUM_REG_RB                 ,"out_ISSUE_NUM_REG_RB                 ",Tgeneral_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_READ_RC                    ,"out_ISSUE_READ_RC                    ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_NUM_REG_RC                 ,"out_ISSUE_NUM_REG_RC                 ",Tspecial_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_WRITE_RD                   ,"out_ISSUE_WRITE_RD                   ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_NUM_REG_RD                 ,"out_ISSUE_NUM_REG_RD                 ",Tgeneral_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_WRITE_RE                   ,"out_ISSUE_WRITE_RE                   ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_NUM_REG_RE                 ,"out_ISSUE_NUM_REG_RE                 ",Tspecial_address_t,_param->_nb_inst_issue);

  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_VAL                 ," in_EXECUTE_LOOP_VAL                 ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL(out_EXECUTE_LOOP_ACK                 ,"out_EXECUTE_LOOP_ACK                 ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_FRONT_END_ID        ," in_EXECUTE_LOOP_FRONT_END_ID        ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_CONTEXT_ID          ," in_EXECUTE_LOOP_CONTEXT_ID          ",Tcontext_t        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_PACKET_ID           ," in_EXECUTE_LOOP_PACKET_ID           ",Tpacket_t         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_TYPE                ," in_EXECUTE_LOOP_TYPE                ",Ttype_t           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_OPERATION           ," in_EXECUTE_LOOP_OPERATION           ",Toperation_t      ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_FLAGS               ," in_EXECUTE_LOOP_FLAGS               ",Tspecial_data_t   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_EXCEPTION           ," in_EXECUTE_LOOP_EXCEPTION           ",Texception_t      ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_NO_SEQUENCE         ," in_EXECUTE_LOOP_NO_SEQUENCE         ",Tcontrol_t        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_ADDRESS             ," in_EXECUTE_LOOP_ADDRESS             ",Taddress_t        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  ALLOC2_SC_SIGNAL( in_EXECUTE_LOOP_DATA                ," in_EXECUTE_LOOP_DATA                ",Tgeneral_data_t   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

  ALLOC1_SC_SIGNAL(out_INSERT_VAL                       ,"out_INSERT_VAL                       ",Tcontrol_t        ,_param->_sum_inst_insert);
  ALLOC1_SC_SIGNAL( in_INSERT_ACK                       ," in_INSERT_ACK                       ",Tcontrol_t        ,_param->_sum_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RD_USE                    ,"out_INSERT_RD_USE                    ",Tcontrol_t        ,_param->_sum_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RD_NUM_REG                ,"out_INSERT_RD_NUM_REG                ",Tgeneral_address_t,_param->_sum_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RE_USE                    ,"out_INSERT_RE_USE                    ",Tcontrol_t        ,_param->_sum_inst_insert);
  ALLOC1_SC_SIGNAL(out_INSERT_RE_NUM_REG                ,"out_INSERT_RE_NUM_REG                ",Tspecial_address_t,_param->_sum_inst_insert);

//   ALLOC1_SC_SIGNAL(out_RETIRE_VAL                       ,"out_RETIRE_VAL                       ",Tcontrol_t        ,_param->_sum_inst_retire);
//   ALLOC1_SC_SIGNAL( in_RETIRE_ACK                       ," in_RETIRE_ACK                       ",Tcontrol_t        ,_param->_sum_inst_retire);
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_OLD_USE                ,"out_RETIRE_RD_OLD_USE                ",Tcontrol_t        ,_param->_sum_inst_retire); 
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_OLD_NUM_REG            ,"out_RETIRE_RD_OLD_NUM_REG            ",Tgeneral_address_t,_param->_sum_inst_retire);
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_NEW_USE                ,"out_RETIRE_RD_NEW_USE                ",Tcontrol_t        ,_param->_sum_inst_retire);
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_NEW_NUM_REG            ,"out_RETIRE_RD_NEW_NUM_REG            ",Tgeneral_address_t,_param->_sum_inst_retire);
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_OLD_USE                ,"out_RETIRE_RE_OLD_USE                ",Tcontrol_t        ,_param->_sum_inst_retire); 
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_OLD_NUM_REG            ,"out_RETIRE_RE_OLD_NUM_REG            ",Tspecial_address_t,_param->_sum_inst_retire);
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_NEW_USE                ,"out_RETIRE_RE_NEW_USE                ",Tcontrol_t        ,_param->_sum_inst_retire);
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_NEW_NUM_REG            ,"out_RETIRE_RE_NEW_NUM_REG            ",Tspecial_address_t,_param->_sum_inst_retire);

  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_VAL              ,"out_BRANCH_COMPLETE_VAL              ",Tcontrol_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ACK              ," in_BRANCH_COMPLETE_ACK              ",Tcontrol_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ID     ,"out_BRANCH_COMPLETE_FRONT_END_ID     ",Tcontext_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_ID       ,"out_BRANCH_COMPLETE_CONTEXT_ID       ",Tcontext_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_DEPTH            ,"out_BRANCH_COMPLETE_DEPTH            ",Tdepth_t          ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS          ,"out_BRANCH_COMPLETE_ADDRESS          ",Taddress_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_NO_SEQUENCE      ,"out_BRANCH_COMPLETE_NO_SEQUENCE      ",Tcontrol_t        ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION  ," in_BRANCH_COMPLETE_MISS_PREDICTION  ",Tcontrol_t        ,_param->_nb_inst_branch_complete);

  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_VAL                 ,"out_COMMIT_EVENT_VAL                 ",Tcontrol_t        );
  ALLOC_SC_SIGNAL ( in_COMMIT_EVENT_ACK                 ," in_COMMIT_EVENT_ACK                 ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_FRONT_END_ID        ,"out_COMMIT_EVENT_FRONT_END_ID        ",Tcontext_t        );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_CONTEXT_ID          ,"out_COMMIT_EVENT_CONTEXT_ID          ",Tcontext_t        );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_DEPTH               ,"out_COMMIT_EVENT_DEPTH               ",Tdepth_t          );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_TYPE                ,"out_COMMIT_EVENT_TYPE                ",Tevent_type_t     );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_IS_DELAY_SLOT       ,"out_COMMIT_EVENT_IS_DELAY_SLOT       ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_ADDRESS             ,"out_COMMIT_EVENT_ADDRESS             ",Taddress_t        );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_ADDRESS_EPCR        ,"out_COMMIT_EVENT_ADDRESS_EPCR        ",Taddress_t        );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_ADDRESS_EEAR_VAL    ,"out_COMMIT_EVENT_ADDRESS_EEAR_VAL    ",Tcontrol_t        );
  ALLOC_SC_SIGNAL (out_COMMIT_EVENT_ADDRESS_EEAR        ,"out_COMMIT_EVENT_ADDRESS_EEAR        ",Tgeneral_data_t   );

  ALLOC2_SC_SIGNAL( in_EVENT_VAL                        ," in_EVENT_VAL                        ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_EVENT_ACK                        ,"out_EVENT_ACK                        ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_EVENT_ADDRESS                    ," in_EVENT_ADDRESS                    ",Taddress_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT               ," in_EVENT_ADDRESS_NEXT               ",Taddress_t        ,_param->_nb_front_end,_param->_nb_context[it1]); 
  ALLOC2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL           ," in_EVENT_ADDRESS_NEXT_VAL           ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_EVENT_IS_DS_TAKE                 ," in_EVENT_IS_DS_TAKE                 ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL( in_SPR_EVENT_VAL                    ," in_SPR_EVENT_VAL                    ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_EVENT_ACK                    ,"out_SPR_EVENT_ACK                    ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_EPCR                   ," in_SPR_EVENT_EPCR                   ",Tspr_t            ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_EEAR_WEN               ," in_SPR_EVENT_EEAR_WEN               ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_EEAR                   ," in_SPR_EVENT_EEAR                   ",Tspr_t            ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_SR_DSX                 ," in_SPR_EVENT_SR_DSX                 ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_SPR_EVENT_SR_TO_ESR              ," in_SPR_EVENT_SR_TO_ESR              ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL(out_NB_INST_COMMIT_ALL               ,"out_NB_INST_COMMIT_ALL               ",Tcounter_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_NB_INST_COMMIT_MEM               ,"out_NB_INST_COMMIT_MEM               ",Tcounter_t        ,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL( in_DEPTH_MIN                        ," in_DEPTH_MIN                        ",Tdepth_t          ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL( in_DEPTH_MAX                        ," in_DEPTH_MAX                        ",Tdepth_t          ,_param->_nb_front_end,_param->_nb_context[it1]);

  ALLOC2_SC_SIGNAL(out_SPR_SR_IEE                       ,"out_SPR_SR_IEE                       ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  ALLOC2_SC_SIGNAL(out_SPR_SR_EPH                       ,"out_SPR_SR_EPH                       ",Tcontrol_t        ,_param->_nb_front_end,_param->_nb_context[it1]);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _OOO_Engine.\n"),name.c_str());

  (*(_OOO_Engine->in_CLOCK))        (*(in_CLOCK));
  (*(_OOO_Engine->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_VAL                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_RENAME_ACK                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_FRONT_END_ID              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_CONTEXT_ID                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  if (_param->_have_port_depth)
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_DEPTH                     ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_TYPE                      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_OPERATION                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_NO_EXECUTE                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_IS_DELAY_SLOT             ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_ADDRESS                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_HAS_IMMEDIAT              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_IMMEDIAT                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_READ_RA                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_NUM_REG_RA                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_READ_RB                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_NUM_REG_RB                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_READ_RC                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_NUM_REG_RC                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_WRITE_RD                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_NUM_REG_RD                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_WRITE_RE                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_NUM_REG_RE                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_EXCEPTION_USE             ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_RENAME_EXCEPTION                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);

  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_VAL                        ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine, in_ISSUE_ACK                        ,_param->_nb_inst_issue);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_FRONT_END_ID               ,_param->_nb_inst_issue);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_CONTEXT_ID                 ,_param->_nb_inst_issue);
  if (_param->_have_port_rob_ptr)
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_PACKET_ID                  ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_TYPE                       ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_OPERATION                  ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_STORE_QUEUE_PTR_WRITE      ,_param->_nb_inst_issue);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_LOAD_QUEUE_PTR_WRITE       ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_HAS_IMMEDIAT               ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_IMMEDIAT                   ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_READ_RA                    ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_NUM_REG_RA                 ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_READ_RB                    ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_NUM_REG_RB                 ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_READ_RC                    ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_NUM_REG_RC                 ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_WRITE_RD                   ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_NUM_REG_RD                 ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_WRITE_RE                   ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_ISSUE_NUM_REG_RE                 ,_param->_nb_inst_issue);

  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_VAL                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_EXECUTE_LOOP_ACK                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_FRONT_END_ID        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_CONTEXT_ID          ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  if (_param->_have_port_rob_ptr)
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_PACKET_ID           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_TYPE                ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_OPERATION           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_FLAGS               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_EXCEPTION           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_NO_SEQUENCE         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_ADDRESS             ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EXECUTE_LOOP_DATA                ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_INSERT_VAL                       ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine, in_INSERT_ACK                       ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_INSERT_RD_USE                    ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_INSERT_RD_NUM_REG                ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_INSERT_RE_USE                    ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_INSERT_RE_NUM_REG                ,_param->_sum_inst_insert);

//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_VAL                       ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine, in_RETIRE_ACK                       ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RD_OLD_USE                ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RD_OLD_NUM_REG            ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RD_NEW_USE                ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RD_NEW_NUM_REG            ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RE_OLD_USE                ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RE_OLD_NUM_REG            ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RE_NEW_USE                ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine,out_RETIRE_RE_NEW_NUM_REG            ,_param->_sum_inst_retire);

  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_BRANCH_COMPLETE_VAL              ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_OOO_Engine, in_BRANCH_COMPLETE_ACK              ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_BRANCH_COMPLETE_FRONT_END_ID     ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_BRANCH_COMPLETE_CONTEXT_ID       ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_BRANCH_COMPLETE_DEPTH            ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_BRANCH_COMPLETE_ADDRESS          ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_OOO_Engine,out_BRANCH_COMPLETE_NO_SEQUENCE      ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_OOO_Engine, in_BRANCH_COMPLETE_MISS_PREDICTION  ,_param->_nb_inst_branch_complete);

  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_VAL                 );
  INSTANCE_SC_SIGNAL (_OOO_Engine, in_COMMIT_EVENT_ACK                 );
  if (_param->_have_port_front_end_id)
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_FRONT_END_ID        );
  if (_param->_have_port_context_id)
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_CONTEXT_ID          );
  if (_param->_have_port_depth)
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_DEPTH               );
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_TYPE                );
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_IS_DELAY_SLOT       );
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_ADDRESS             );
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_ADDRESS_EPCR        );
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_ADDRESS_EEAR_VAL    );
  INSTANCE_SC_SIGNAL (_OOO_Engine,out_COMMIT_EVENT_ADDRESS_EEAR        );

  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EVENT_VAL                        ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_EVENT_ACK                        ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EVENT_ADDRESS                    ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EVENT_ADDRESS_NEXT               ,_param->_nb_front_end,_param->_nb_context[it1]); 
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EVENT_ADDRESS_NEXT_VAL           ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_EVENT_IS_DS_TAKE                 ,_param->_nb_front_end,_param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_SPR_EVENT_VAL                    ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_SPR_EVENT_ACK                    ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_SPR_EVENT_EPCR                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_SPR_EVENT_EEAR_WEN               ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_SPR_EVENT_EEAR                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_SPR_EVENT_SR_DSX                 ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_SPR_EVENT_SR_TO_ESR              ,_param->_nb_front_end,_param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_NB_INST_COMMIT_ALL               ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_NB_INST_COMMIT_MEM               ,_param->_nb_front_end,_param->_nb_context[it1]);
  
  for (uint32_t i=0; i<_param->_nb_front_end; i++)
    for (uint32_t j=0; j<_param->_nb_context[i]; j++)
      if (_param->_have_port_depth)
        INSTANCE_SC_SIGNAL(_OOO_Engine, in_DEPTH_MIN  [i][j]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine, in_DEPTH_MAX                        ,_param->_nb_front_end,_param->_nb_context[it1]);

  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_SPR_SR_IEE                       ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine,out_SPR_SR_EPH                       ,_param->_nb_front_end,_param->_nb_context[it1]);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_RENAME_VAL                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL(out_RENAME_ACK                       ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_FRONT_END_ID              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_CONTEXT_ID                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_DEPTH                     ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_TYPE                      ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_OPERATION                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_NO_EXECUTE                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IS_DELAY_SLOT             ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_ADDRESS                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_HAS_IMMEDIAT              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_IMMEDIAT                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_READ_RA                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_NUM_REG_RA                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_READ_RB                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_NUM_REG_RB                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_READ_RC                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_NUM_REG_RC                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_WRITE_RD                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_NUM_REG_RD                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_WRITE_RE                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_NUM_REG_RE                ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_EXCEPTION_USE             ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL( in_RENAME_EXCEPTION                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  
  DELETE1_SC_SIGNAL(out_ISSUE_VAL                        ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL( in_ISSUE_ACK                        ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_FRONT_END_ID               ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_CONTEXT_ID                 ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_PACKET_ID                  ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_TYPE                       ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OPERATION                  ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_STORE_QUEUE_PTR_WRITE      ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_LOAD_QUEUE_PTR_WRITE       ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_HAS_IMMEDIAT               ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_IMMEDIAT                   ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_READ_RA                    ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_NUM_REG_RA                 ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_READ_RB                    ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_NUM_REG_RB                 ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_READ_RC                    ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_NUM_REG_RC                 ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_WRITE_RD                   ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_NUM_REG_RD                 ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_WRITE_RE                   ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_NUM_REG_RE                 ,_param->_nb_inst_issue);
  
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_VAL                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL(out_EXECUTE_LOOP_ACK                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_FRONT_END_ID        ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_CONTEXT_ID          ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_PACKET_ID           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_TYPE                ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_OPERATION           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_FLAGS               ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_EXCEPTION           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_NO_SEQUENCE         ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_ADDRESS             ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  DELETE2_SC_SIGNAL( in_EXECUTE_LOOP_DATA                ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
  
  DELETE1_SC_SIGNAL(out_INSERT_VAL                       ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_ACK                       ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RD_USE                    ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RD_NUM_REG                ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RE_USE                    ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RE_NUM_REG                ,_param->_sum_inst_insert);
  
//DELETE1_SC_SIGNAL(out_RETIRE_VAL                       ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL( in_RETIRE_ACK                       ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RD_OLD_USE                ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RD_OLD_NUM_REG            ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RD_NEW_USE                ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RD_NEW_NUM_REG            ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RE_OLD_USE                ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RE_OLD_NUM_REG            ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RE_NEW_USE                ,_param->_sum_inst_retire);
//DELETE1_SC_SIGNAL(out_RETIRE_RE_NEW_NUM_REG            ,_param->_sum_inst_retire);
  
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_VAL              ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_ACK              ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_FRONT_END_ID     ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_CONTEXT_ID       ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_DEPTH            ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS          ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL(out_BRANCH_COMPLETE_NO_SEQUENCE      ,_param->_nb_inst_branch_complete);
  DELETE1_SC_SIGNAL( in_BRANCH_COMPLETE_MISS_PREDICTION  ,_param->_nb_inst_branch_complete);
  
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_VAL                 );
  DELETE_SC_SIGNAL  ( in_COMMIT_EVENT_ACK                 );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_FRONT_END_ID        );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_CONTEXT_ID          );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_DEPTH               );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_TYPE                );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_IS_DELAY_SLOT       );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_ADDRESS             );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_ADDRESS_EPCR        );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_ADDRESS_EEAR_VAL    );
  DELETE_SC_SIGNAL  (out_COMMIT_EVENT_ADDRESS_EEAR        );
  
  DELETE2_SC_SIGNAL( in_EVENT_VAL                        ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_EVENT_ACK                        ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_EVENT_ADDRESS                    ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT               ,_param->_nb_front_end,_param->_nb_context[it1]); 
  DELETE2_SC_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL           ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_EVENT_IS_DS_TAKE                 ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_VAL                    ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_EVENT_ACK                    ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_EPCR                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_EEAR_WEN               ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_EEAR                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_SR_DSX                 ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_EVENT_SR_TO_ESR              ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_NB_INST_COMMIT_ALL               ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_NB_INST_COMMIT_MEM               ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_DEPTH_MIN                        ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_DEPTH_MAX                        ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_SR_IEE                       ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_SR_EPH                       ,_param->_nb_front_end,_param->_nb_context[it1]);
    }
#endif

  delete _OOO_Engine;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
