/*
 * $Id: Register_translation_unit_allocation.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/include/Register_translation_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {



#undef  FUNCTION
#define FUNCTION "Register_translation_unit::allocation"
  void Register_translation_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Register_translation_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Register_translation_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("rename", IN, EAST, "Instruction with logical register", _param->_nb_inst_insert);

      ALLOC1_VALACK_IN ( in_RENAME_VAL           ,VAL);
      ALLOC1_VALACK_OUT(out_RENAME_ACK           ,ACK);
      ALLOC1_SIGNAL_IN ( in_RENAME_FRONT_END_ID  ,"front_end_id"  ,Tcontext_t        ,_param->_size_front_end_id          );
      ALLOC1_SIGNAL_IN ( in_RENAME_CONTEXT_ID    ,"context_id"    ,Tcontext_t        ,_param->_size_context_id            );
      ALLOC1_SIGNAL_IN ( in_RENAME_READ_RA       ,"read_ra"       ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RENAME_NUM_REG_RA_LOG,"num_reg_ra_log",Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_RENAME_READ_RB       ,"read_rb"       ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RENAME_NUM_REG_RB_LOG,"num_reg_rb_log",Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_RENAME_READ_RC       ,"read_rc"       ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RENAME_NUM_REG_RC_LOG,"num_reg_rc_log",Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_IN ( in_RENAME_WRITE_RD      ,"write_rd"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RENAME_NUM_REG_RD_LOG,"num_reg_rd_log",Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_RENAME_WRITE_RE      ,"write_re"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RENAME_NUM_REG_RE_LOG,"num_reg_re_log",Tspecial_address_t,_param->_size_special_register_logic);
    }

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("insert",OUT,WEST , "Instruction with physical register", _param->_nb_inst_insert);
      
      ALLOC1_VALACK_OUT(out_INSERT_VAL               ,VAL);
      ALLOC1_VALACK_IN ( in_INSERT_ACK               ,ACK);
      ALLOC1_SIGNAL_OUT(out_INSERT_FRONT_END_ID      ,"front_end_id"      ,Tcontext_t        ,_param->_size_front_end_id          );
      ALLOC1_SIGNAL_OUT(out_INSERT_CONTEXT_ID        ,"context_id"        ,Tcontext_t        ,_param->_size_context_id            );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RA_LOG    ,"num_reg_ra_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RB_LOG    ,"num_reg_rb_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RC_LOG    ,"num_reg_rc_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_LOG    ,"num_reg_rd_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_LOG    ,"num_reg_re_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_OUT(out_INSERT_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register      );
    }

    // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("retire",IN ,NORTH, "Retire instruction, update renaming structure.", _param->_nb_inst_retire);
      ALLOC1_VALACK_IN ( in_RETIRE_VAL               ,VAL);
      ALLOC1_VALACK_OUT(out_RETIRE_ACK               ,ACK);
      ALLOC1_SIGNAL_IN ( in_RETIRE_FRONT_END_ID      ,"front_end_id"      ,Tcontext_t        ,_param->_size_front_end_id          );
      ALLOC1_SIGNAL_IN ( in_RETIRE_CONTEXT_ID        ,"context_id"        ,Tcontext_t        ,_param->_size_context_id            );
      ALLOC1_SIGNAL_IN ( in_RETIRE_EVENT_STATE       ,"event_state"       ,Tevent_state_t    ,_param->_size_event_state           );
      ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_LOG    ,"num_reg_rd_log"    ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_LOG    ,"num_reg_re_log"    ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register      );
      ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register      );
    }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string name;
     {
       name = _name+"_dependency_checking_unit";
       log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());

       _component_dependency_checking_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::dependency_checking_unit::Dependency_checking_unit
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_dependency_checking_unit
	  ,_usage);
       
       _component->set_component (_component_dependency_checking_unit->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     {
       name = _name+"_free_list_unit";
       log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
       
       _component_free_list_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::free_list_unit::Free_List_unit
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_free_list_unit
	  ,_usage);
       
       _component->set_component (_component_free_list_unit->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     {
       name = _name+"_register_address_translation_unit";
       log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
       
       _component_register_address_translation_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_address_translation_unit::Register_Address_Translation_unit
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_register_address_translation_unit
	  ,_usage);
       
       _component->set_component (_component_register_address_translation_unit->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     {
       name = _name+"_stat_list_unit";
       log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
       
       _component_stat_list_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::stat_list_unit::Stat_List_unit
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_stat_list_unit
	  ,_usage);
       
       _component->set_component (_component_stat_list_unit->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

     {
       name = _name+"_register_translation_unit_glue";
       log_printf(INFO,Core,FUNCTION,_("Create   : %s"),name.c_str());
       
       _component_register_translation_unit_glue = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::register_translation_unit_glue::Register_translation_unit_Glue
	 (name.c_str()
#ifdef STATISTICS
	  ,param_statistics
#endif
	  ,_param->_param_register_translation_unit_glue
	  ,_usage);
       
       _component->set_component (_component_register_translation_unit_glue->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;

    // ===================================================================
    // =====[ register_address_translation_unit ]=========================
    // ===================================================================
    {
      src = _name+"_register_address_translation_unit";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"rename_"+toString(i)
				     dest,"rename_"+toString(i));
#endif
	  
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_VAL"               ,
		              dest, "in_RENAME_"+toString(i)+"_VAL"               );
	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_FRONT_END_ID"      ,
		              dest, "in_RENAME_"+toString(i)+"_FRONT_END_ID"      );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_CONTEXT_ID"        ,
		              dest, "in_RENAME_"+toString(i)+"_CONTEXT_ID"        );
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_NUM_REG_RA_LOG"    ,
		              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RA_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_NUM_REG_RB_LOG"    ,
		              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RB_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_NUM_REG_RC_LOG"    ,
		              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RC_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_NUM_REG_RD_LOG"    ,
		              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RD_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_NUM_REG_RE_LOG"    ,
		              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RE_LOG"    );

	  dest = _name+"_register_translation_unit_glue";
	  COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(i)+"_ACK",
		                   dest, "in_INSERT_"+toString(i)+"_RAT_RENAME_ACK");
	  
	  dest = _name+"_dependency_checking_unit";
	  COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(i)+"_NUM_REG_RA_PHY"    ,
		                   dest, "in_RENAME_IN_"+toString(i)+"_NUM_REG_RA_PHY"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(i)+"_NUM_REG_RB_PHY"    ,
		                   dest, "in_RENAME_IN_"+toString(i)+"_NUM_REG_RB_PHY"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(i)+"_NUM_REG_RC_PHY"    ,
		                   dest, "in_RENAME_IN_"+toString(i)+"_NUM_REG_RC_PHY"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(i)+"_NUM_REG_RD_PHY_OLD",
		                   dest, "in_RENAME_IN_"+toString(i)+"_NUM_REG_RD_PHY_OLD");
	  COMPONENT_MAP(_component,src ,"out_RENAME_"+toString(i)+"_NUM_REG_RE_PHY_OLD",
		                   dest, "in_RENAME_IN_"+toString(i)+"_NUM_REG_RE_PHY_OLD");
	}

      // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name+"_register_translation_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"rename_"+toString(i)
				     dest,"rename_in_"+toString(i));
#endif
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_VAL",
		                   dest,"out_INSERT_"+toString(i)+"_RAT_INSERT_VAL");
	  COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_ACK",
		                   dest, "in_INSERT_"+toString(i)+"_RAT_INSERT_ACK");
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_WRITE_RD"      ,
			           dest,"out_INSERT_"+toString(i)+"_RAT_WRITE_RD"      );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_WRITE_RE"      ,
		                   dest,"out_INSERT_"+toString(i)+"_RAT_WRITE_RE"      );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RD_LOG",
		                   dest,"out_INSERT_"+toString(i)+"_RAT_NUM_REG_RD_LOG");
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RE_LOG",
		                   dest,"out_INSERT_"+toString(i)+"_RAT_NUM_REG_RE_LOG");
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RD_PHY",
		                   dest,"out_INSERT_"+toString(i)+"_RAT_NUM_REG_RD_PHY_NEW");
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RE_PHY",
		                   dest,"out_INSERT_"+toString(i)+"_RAT_NUM_REG_RE_PHY_NEW");
	}

      // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"retire_"+toString(i)
				     dest,"retire_"+toString(i));
#endif

	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_FRONT_END_ID"      ,
		              dest, "in_RETIRE_"+toString(i)+"_FRONT_END_ID"      );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_CONTEXT_ID"        ,
		              dest, "in_RETIRE_"+toString(i)+"_CONTEXT_ID"        );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_EVENT_STATE"       ,
		              dest, "in_RETIRE_"+toString(i)+"_EVENT_STATE"       );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_WRITE_RD"          ,
		              dest, "in_RETIRE_"+toString(i)+"_WRITE_RD"          );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_WRITE_RE"          ,
		              dest, "in_RETIRE_"+toString(i)+"_WRITE_RE"          );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RD_LOG"    ,
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RD_LOG"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RE_LOG"    ,
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RE_LOG"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_OLD",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_OLD");
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_OLD",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_OLD");

	  dest = _name+"_register_translation_unit_glue";
	  COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_VAL"          ,
			           dest,"out_RETIRE_"+toString(i)+"_RAT_VAL"      );
	  COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_ACK"          ,
		                   dest, "in_RETIRE_"+toString(i)+"_RAT_ACK"      );

	  dest = _name+"_stat_list_unit";
	  COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RESTORE_RD_PHY_OLD",
		                   dest, "in_RETIRE_"+toString(i)+"_RESTORE_RD_PHY_OLD");
	  COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RESTORE_RE_PHY_OLD",
		                   dest, "in_RETIRE_"+toString(i)+"_RESTORE_RE_PHY_OLD");
	}
    }
    
    // ===================================================================
    // =====[ free_list_unit ]============================================
    // ===================================================================
    {
      src = _name+"_free_list_unit";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ interface : "pop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"pop_"+toString(i)
				     dest,"rename_"+toString(i));
#endif
	  
	  dest = _name+"_register_translation_unit_glue";
	  COMPONENT_MAP(_component,src , "in_POP_"+toString(i)+"_VAL" ,
			           dest,"out_INSERT_"+toString(i)+"_FREE_LIST_VAL" );
	  COMPONENT_MAP(_component,src ,"out_POP_"+toString(i)+"_ACK" ,
		                   dest, "in_INSERT_"+toString(i)+"_FREE_LIST_ACK" );
	  COMPONENT_MAP(_component,src , "in_POP_"+toString(i)+"_GPR_VAL"    ,
			           dest,"out_INSERT_"+toString(i)+"_FREE_LIST_GPR_VAL");
	  COMPONENT_MAP(_component,src , "in_POP_"+toString(i)+"_SPR_VAL"    ,
			           dest,"out_INSERT_"+toString(i)+"_FREE_LIST_SPR_VAL");

	  dest = _name+"_dependency_checking_unit";

	  COMPONENT_MAP(_component,src ,"out_POP_"+toString(i)+"_GPR_NUM_REG",
			           dest, "in_RENAME_IN_"+toString(i)+"_NUM_REG_RD_PHY_NEW");
	  COMPONENT_MAP(_component,src ,"out_POP_"+toString(i)+"_SPR_NUM_REG",
			           dest, "in_RENAME_IN_"+toString(i)+"_NUM_REG_RE_PHY_NEW");
	}

      // ~~~~~[ interface : "push_gpr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // ~~~~~[ interface : "push_spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_reg_free; i++)
	{
	  dest = _name+"_stat_list_unit";
#ifdef POSITION
	  _component->interface_map (src ,"push_gpr_"+toString(i)
				     dest,"push_gpr_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src , "in_PUSH_GPR_"+toString(i)+"_VAL"    ,
			           dest,"out_PUSH_GPR_"+toString(i)+"_VAL"    );
	  COMPONENT_MAP(_component,src ,"out_PUSH_GPR_"+toString(i)+"_ACK"    ,
		                   dest, "in_PUSH_GPR_"+toString(i)+"_ACK"    );
	  COMPONENT_MAP(_component,src , "in_PUSH_GPR_"+toString(i)+"_NUM_REG",
		                   dest,"out_PUSH_GPR_"+toString(i)+"_NUM_REG");

#ifdef POSITION
	  _component->interface_map (src ,"push_spr_"+toString(i)
				     dest,"push_spr_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src , "in_PUSH_SPR_"+toString(i)+"_VAL"    ,
		                   dest,"out_PUSH_SPR_"+toString(i)+"_VAL"    );
	  COMPONENT_MAP(_component,src ,"out_PUSH_SPR_"+toString(i)+"_ACK"    ,
		                   dest, "in_PUSH_SPR_"+toString(i)+"_ACK"    );
	  COMPONENT_MAP(_component,src , "in_PUSH_SPR_"+toString(i)+"_NUM_REG",
		                   dest,"out_PUSH_SPR_"+toString(i)+"_NUM_REG");
	}
    }


    // ===================================================================
    // =====[ dependency_checking_unit ]==================================
    // ===================================================================
    {
      src = _name+"_dependency_checking_unit";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }
 
      // ~~~~~[ Interface "rename_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"rename_in_"+toString(i)
				     dest,"rename_"+toString(i));
#endif

// // 	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_VAL"               ,dest,);
// // 	  PORT_MAP(_component,src ,"out_RENAME_IN_"+toString(i)+"_ACK"               ,dest,);
	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_FRONT_END_ID"      ,
	  	              dest, "in_RENAME_"+toString(i)+"_FRONT_END_ID"      );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_CONTEXT_ID"        ,
	  	              dest, "in_RENAME_"+toString(i)+"_CONTEXT_ID"        );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_READ_RA"           ,
	  	              dest, "in_RENAME_"+toString(i)+"_READ_RA"           );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_NUM_REG_RA_LOG"    ,
	  	              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RA_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_READ_RB"           ,
	  	              dest, "in_RENAME_"+toString(i)+"_READ_RB"           );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_NUM_REG_RB_LOG"    ,
	  	              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RB_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_READ_RC"           ,
	  	              dest, "in_RENAME_"+toString(i)+"_READ_RC"           );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_NUM_REG_RC_LOG"    ,
	  	              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RC_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_WRITE_RD"          ,
	  	              dest, "in_RENAME_"+toString(i)+"_WRITE_RD"          );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_NUM_REG_RD_LOG"    ,
	  	              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RD_LOG"    );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_WRITE_RE"          ,
	  	              dest, "in_RENAME_"+toString(i)+"_WRITE_RE"          );
	  PORT_MAP(_component,src , "in_RENAME_IN_"+toString(i)+"_NUM_REG_RE_LOG"    ,
	  	              dest, "in_RENAME_"+toString(i)+"_NUM_REG_RE_LOG"    );
	  
	  // in_RENAME_IN_NUM_REG_RA_PHY     - register_address_translation_unit
	  // in_RENAME_IN_NUM_REG_RB_PHY     - register_address_translation_unit
	  // in_RENAME_IN_NUM_REG_RC_PHY     - register_address_translation_unit
	  // in_RENAME_IN_NUM_REG_RD_PHY_OLD - register_address_translation_unit
	  // in_RENAME_IN_NUM_REG_RE_PHY_OLD - register_address_translation_unit
	  
	  // in_RENAME_IN_NUM_REG_RD_PHY_NEW - free_list_unit
	  // in_RENAME_IN_NUM_REG_RE_PHY_NEW - free_list_unit
	}

      // ~~~~~[ Interface "rename_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"rename_out_"+toString(i),
				     dest,"insert_"+toString(i));
#endif

	  if (_param->_have_port_front_end_id)
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_FRONT_END_ID"      ,
		              dest,"out_INSERT_"+toString(i)+"_FRONT_END_ID"      );
	  if (_param->_have_port_context_id)
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_CONTEXT_ID"        ,
		              dest,"out_INSERT_"+toString(i)+"_CONTEXT_ID"        );
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RA_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RA_LOG"    );
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RB_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RB_LOG"    );
	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RC_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RC_LOG"    );

// 	  PORT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_VAL"               ,
// 		              dest,"out_INSERT_"+toString(i)+"_VAL"               );
// 	  PORT_MAP(_component,src , "in_RENAME_OUT_"+toString(i)+"_ACK"               ,
// 		              dest, "in_INSERT_"+toString(i)+"_ACK"               );

	  dest = _name+"_register_translation_unit_glue";

	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_READ_RA"           ,
			           dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_READ_RA"           );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RA_PHY"    ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RA_PHY"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_READ_RB"           ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_READ_RB"           );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RB_PHY"    ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RB_PHY"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_READ_RC"           ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_READ_RC"           );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RC_PHY"    ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RC_PHY"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_WRITE_RD"          ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_WRITE_RD"          );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RD_LOG"    ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RD_LOG"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RD_PHY_OLD",
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RD_PHY_NEW",
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_WRITE_RE"          ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_WRITE_RE"          );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RE_LOG"    ,
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RE_LOG"    );
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RE_PHY_OLD",
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD");
	  COMPONENT_MAP(_component,src ,"out_RENAME_OUT_"+toString(i)+"_NUM_REG_RE_PHY_NEW",
		                   dest, "in_INSERT_"+toString(i)+"_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW");
 	}
    }

    // ===================================================================
    // =====[ stat_list_unit ]============================================
    // ===================================================================
    {
      src = _name+"_stat_list_unit";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name+"_register_translation_unit_glue";
#ifdef POSITION
	  _component->interface_map (src ,"insert_"+toString(i)
				     dest,"insert_stat_list_"+toString(i));
#endif

	  COMPONENT_MAP(_component,src ,  "in_INSERT_"+toString(i)+"_VAL" ,
			           dest,"out_INSERT_"+toString(i)+"_STAT_LIST_VAL");
	  COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_ACK" ,
		                   dest, "in_INSERT_"+toString(i)+"_STAT_LIST_ACK" );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_READ_RA"           ,
			           dest,"out_INSERT_"+toString(i)+"_STAT_LIST_READ_RA"           );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RA_PHY"    ,
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_NUM_REG_RA_PHY"    );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_READ_RB"           ,
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_READ_RB"           );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RB_PHY"    ,
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_NUM_REG_RB_PHY"    );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_READ_RC"           ,
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_READ_RC"           );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RC_PHY"    ,
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_NUM_REG_RC_PHY"    );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_WRITE_RD"          ,
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_WRITE_RD"          );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_NEW",
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_NUM_REG_RD_PHY_NEW");
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_WRITE_RE"          ,
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_WRITE_RE"          );
	  COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_NEW",
		                   dest,"out_INSERT_"+toString(i)+"_STAT_LIST_NUM_REG_RE_PHY_NEW");
	}

      // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"retire_"+toString(i)
				     dest,"retire_"+toString(i));
#endif

	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_READ_RA"           ,
		              dest, "in_RETIRE_"+toString(i)+"_READ_RA"           );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RA_PHY"    ,
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RA_PHY"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_READ_RB"           ,
		              dest, "in_RETIRE_"+toString(i)+"_READ_RB"           );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RB_PHY"    ,
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RB_PHY"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_READ_RC"           ,
		              dest, "in_RETIRE_"+toString(i)+"_READ_RC"           );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RC_PHY"    ,
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RC_PHY"    );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_WRITE_RD"          ,
		              dest, "in_RETIRE_"+toString(i)+"_WRITE_RD"          );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_OLD",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_OLD");
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_NEW",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RD_PHY_NEW");
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_WRITE_RE"          ,
		              dest, "in_RETIRE_"+toString(i)+"_WRITE_RE"          );
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_OLD",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_OLD");
	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_NEW",
		              dest, "in_RETIRE_"+toString(i)+"_NUM_REG_RE_PHY_NEW");

	  // in_RETIRE_RESTORE_RD_PHY_OLD - register_address_translation_unit.out_RETIRE_RESTORE_RD_PHY_OLD
	  // in_RETIRE_RESTORE_RE_PHY_OLD - register_address_translation_unit.out_RETIRE_RESTORE_RE_PHY_OLD

	  dest = _name+"_register_translation_unit_glue";
	  COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_VAL",
		                   dest,"out_RETIRE_"+toString(i)+"_STAT_LIST_VAL");
	  COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_ACK",
			           dest, "in_RETIRE_"+toString(i)+"_STAT_LIST_ACK");
	}

      // ~~~~~[ interface : "push_gpr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // ~~~~~[ interface : "push_spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_reg_free; i++)
	{
	  dest = _name+"_free_list_unit";
#ifdef POSITION
	  _component->interface_map (src ,"push_gpr_"+toString(i)
				     dest,"push_gpr_"+toString(i));
#endif

	  //out_PUSH_GPR_VAL     - free_list_unit
	  // in_PUSH_GPR_ACK     - free_list_unit
	  //out_PUSH_GPR_NUM_REG - free_list_unit

#ifdef POSITION
	  _component->interface_map (src ,"push_spr_"+toString(i)
				     dest,"push_spr_"+toString(i));
#endif

	  //out_PUSH_SPR_VAL     - free_list_unit
	  // in_PUSH_SPR_ACK     - free_list_unit
	  //out_PUSH_SPR_NUM_REG - free_list_unit
	}
    }

    // ===================================================================
    // =====[ register_translation_unit_glue ]============================
    // ===================================================================
    {
      src = _name+"_register_translation_unit_glue";
      log_printf(INFO,Core,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"insert_"+toString(i),
				     dest,"insert_"+toString(i));
#endif

	  PORT_MAP(_component,src , "in_INSERT_"+toString(i)+"_RENAME_VAL"    ,
		              dest, "in_RENAME_"+toString(i)+"_VAL"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_RENAME_ACK"    ,
		              dest,"out_RENAME_"+toString(i)+"_ACK"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_INSERT_VAL"    ,
		              dest,"out_INSERT_"+toString(i)+"_VAL"    );
	  PORT_MAP(_component,src , "in_INSERT_"+toString(i)+"_INSERT_ACK"    ,
		              dest, "in_INSERT_"+toString(i)+"_ACK"    );

	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_READ_RA"           ,
		              dest,"out_INSERT_"+toString(i)+"_READ_RA"           );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RA_PHY"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RA_PHY"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_READ_RB"           ,
		              dest,"out_INSERT_"+toString(i)+"_READ_RB"           );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RB_PHY"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RB_PHY"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_READ_RC"           ,
		              dest,"out_INSERT_"+toString(i)+"_READ_RC"           );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RC_PHY"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RC_PHY"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_WRITE_RD"          ,
		              dest,"out_INSERT_"+toString(i)+"_WRITE_RD"          );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RD_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RD_LOG"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_OLD",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_OLD");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_NEW",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RD_PHY_NEW");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_WRITE_RE"          ,
		              dest,"out_INSERT_"+toString(i)+"_WRITE_RE"          );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RE_LOG"    ,
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RE_LOG"    );
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_OLD",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_OLD");
	  PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_NEW",
		              dest,"out_INSERT_"+toString(i)+"_NUM_REG_RE_PHY_NEW");

	  // out_INSERT_RAT_INSERT_VAL - register_address_translation_unit
	  //  in_INSERT_RAT_RENAME_ACK - register_address_translation_unit
	  //  in_INSERT_RAT_INSERT_ACK - register_address_translation_unit
	  // out_INSERT_FREE_LIST_VAL  - free_list_unit
	  //  in_INSERT_FREE_LIST_ACK  - free_list_unit
	  // out_INSERT_STAT_LIST_VAL  - stat_list_unit
	  //  in_INSERT_STAT_LIST_ACK  - stat_list_unit

	  //  in_INSERT_DEPENDENCY_CHECKING_READ_RA            - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY     - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_READ_RB            - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY     - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_READ_RC            - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY     - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_WRITE_RD           - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG     - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_WRITE_RE           - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG     - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD - dependency_checking_unit
	  //  in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW - dependency_checking_unit

	  // out_INSERT_STAT_LIST_READ_RA                      - stat_list_unit
	  // out_INSERT_STAT_LIST_NUM_REG_RA_PHY               - stat_list_unit
	  // out_INSERT_STAT_LIST_READ_RB                      - stat_list_unit
	  // out_INSERT_STAT_LIST_NUM_REG_RB_PHY               - stat_list_unit
	  // out_INSERT_STAT_LIST_READ_RC                      - stat_list_unit
	  // out_INSERT_STAT_LIST_NUM_REG_RC_PHY               - stat_list_unit
	  // out_INSERT_STAT_LIST_WRITE_RD                     - stat_list_unit
	  // out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW           - stat_list_unit
	  // out_INSERT_STAT_LIST_WRITE_RE                     - stat_list_unit
	  // out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW           - stat_list_unit

	  // out_INSERT_RAT_WRITE_RD                           - register_address_translation_unit
	  // out_INSERT_RAT_NUM_REG_RD_LOG                     - register_address_translation_unit
	  // out_INSERT_RAT_NUM_REG_RD_PHY_NEW                 - register_address_translation_unit
	  // out_INSERT_RAT_WRITE_RE                           - register_address_translation_unit
	  // out_INSERT_RAT_NUM_REG_RE_LOG                     - register_address_translation_unit
	  // out_INSERT_RAT_NUM_REG_RE_PHY_NEW                 - register_address_translation_unit
	}

      // ~~~~~[ Interface : "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	{
	  dest = _name;
#ifdef POSITION
	  _component->interface_map (src ,"retire",
				     dest,"retire");
#endif

	  PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_VAL"          ,
		              dest, "in_RETIRE_"+toString(i)+"_VAL"          );
	  PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_ACK"          ,
		              dest,"out_RETIRE_"+toString(i)+"_ACK"          );

	  // out_RETIRE_RAT_VAL       - register_address_translation_unit
	  //  in_RETIRE_RAT_ACK       - register_address_translation_unit
	  // out_RETIRE_STAT_LIST_VAL - stat_list_unit
	  //  in_RETIRE_STAT_LIST_ACK - stat_list_unit
	}
     }


    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if (DEBUG_Register_translation_unit == true)
    _component->test_map();
#endif

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Register_translation_unit,FUNCTION,"End");
  };

}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
