/*
 * $Id: Special_Register_unit_deallocation.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Special_Register_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace special_register_unit {


#undef  FUNCTION
#define FUNCTION "Special_Register_unit::deallocation"
  void Special_Register_unit::deallocation (void)
  {
    log_begin(Special_Register_unit,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	DELETE1_SIGNAL( in_SPR_ACCESS_VAL          ,_param->_nb_inst_reexecute,1);
	DELETE1_SIGNAL(out_SPR_ACCESS_ACK          ,_param->_nb_inst_reexecute,1);
	DELETE1_SIGNAL( in_SPR_ACCESS_WEN          ,_param->_nb_inst_reexecute,1);
	DELETE1_SIGNAL( in_SPR_ACCESS_CONTEXT_ID   ,_param->_nb_inst_reexecute,_param->_size_context_id  );
	DELETE1_SIGNAL( in_SPR_ACCESS_FRONT_END_ID ,_param->_nb_inst_reexecute,_param->_size_front_end_id);
	DELETE1_SIGNAL( in_SPR_ACCESS_NUM_GROUP    ,_param->_nb_inst_reexecute,_param->_size_special_address_group   );
	DELETE1_SIGNAL( in_SPR_ACCESS_NUM_REG      ,_param->_nb_inst_reexecute,_param->_size_special_address_register);
	DELETE1_SIGNAL( in_SPR_ACCESS_WDATA        ,_param->_nb_inst_reexecute,_param->_size_spr);
	DELETE1_SIGNAL(out_SPR_ACCESS_RDATA        ,_param->_nb_inst_reexecute,_param->_size_spr);
	DELETE1_SIGNAL(out_SPR_ACCESS_INVALID      ,_param->_nb_inst_reexecute,1);
	
	DELETE2_SIGNAL(out_SPR_READ_SR             ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_spr);
	
	DELETE2_SIGNAL( in_SPR_COMMIT_VAL          ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL(out_SPR_COMMIT_ACK          ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL( in_SPR_COMMIT_SR_F_VAL     ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL( in_SPR_COMMIT_SR_F         ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL( in_SPR_COMMIT_SR_CY_VAL    ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL( in_SPR_COMMIT_SR_CY        ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL( in_SPR_COMMIT_SR_OV_VAL    ,_param->_nb_front_end, _param->_nb_context[it1],1);
	DELETE2_SIGNAL( in_SPR_COMMIT_SR_OV        ,_param->_nb_front_end, _param->_nb_context[it1],1);

        DELETE2_SIGNAL( in_SPR_EVENT_VAL           ,_param->_nb_front_end, _param->_nb_context[it1],1);
        DELETE2_SIGNAL(out_SPR_EVENT_ACK           ,_param->_nb_front_end, _param->_nb_context[it1],1);
        DELETE2_SIGNAL( in_SPR_EVENT_EPCR          ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_spr);
        DELETE2_SIGNAL( in_SPR_EVENT_EEAR_WEN      ,_param->_nb_front_end, _param->_nb_context[it1],1);
        DELETE2_SIGNAL( in_SPR_EVENT_EEAR          ,_param->_nb_front_end, _param->_nb_context[it1],_param->_size_spr);
        DELETE2_SIGNAL( in_SPR_EVENT_SR_DSX        ,_param->_nb_front_end, _param->_nb_context[it1],1);
        DELETE2_SIGNAL( in_SPR_EVENT_SR_TO_ESR     ,_param->_nb_front_end, _param->_nb_context[it1],1);

        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        delete [] internal_SPR_ACCESS_ACK;
        for (uint32_t i=0; i<_param->_nb_front_end; i++)
          {
            delete [] internal_SPR_COMMIT_ACK [i];
            delete [] internal_SPR_EVENT_ACK  [i];
          }
        delete [] internal_SPR_COMMIT_ACK;
        delete [] internal_SPR_EVENT_ACK;
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    for (uint32_t i=0; i<_param->_nb_front_end; i++)
      {
	for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	  {
	    for (uint32_t k=0; k<NB_GROUP; k++)
	      {
                if (_spr [i][j][k] != NULL)
		  {
		    for (uint32_t l=0; l<NB_REG_GROUP[k]; l++)
		      if (_spr [i][j][k][l] != NULL)
			delete _spr [i][j][k][l];
		    delete [] _spr [i][j][k];
		  }
	      }
	    delete [] _spr [i][j];
	  }	
	delete [] _spr [i];
      }
    delete [] _spr;

    for (uint32_t i=0; i<_param->_nb_front_end; i++)
      {
	for (uint32_t j=0; j<_param->_nb_context[i]; j++)
	  delete _spr_access_mode [i][j];
	delete [] _spr_access_mode [i];
      }
    delete [] _spr_access_mode;

    delete    _component;

    log_end(Special_Register_unit,FUNCTION);
  };

}; // end namespace special_register_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
