/*
 * $Id: Update_Prediction_Table.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Update_Prediction_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::Update_Prediction_Table"
  Update_Prediction_Table::Update_Prediction_Table 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    usage_environment(_usage);

#if DEBUG_Update_Prediction_Table == true
    log_printf(INFO,Update_Prediction_Table,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Update_Prediction_Table,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Update_Prediction_Table,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Update_Prediction_Table,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        // Constant
	for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
	  {
	    internal_BRANCH_COMPLETE_ACK [i] = 1;
	    PORT_WRITE(out_BRANCH_COMPLETE_ACK [i], internal_BRANCH_COMPLETE_ACK [i]);
	  }
        for (uint32_t i=0; i<_param->_nb_context; ++i)
          {
            internal_EVENT_ACK [i] = 1;
            PORT_WRITE(out_EVENT_ACK [i], internal_EVENT_ACK [i]);
          }

	log_printf(INFO,Update_Prediction_Table,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Update_Prediction_Table,FUNCTION,"Method - genMoore");

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Update_Prediction_Table,FUNCTION,"Method - genMealy_predict");

	SC_METHOD (genMealy_predict);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    if (_param->_have_port_context_id)
	      sensitive << (*(in_PREDICT_CONTEXT_ID [i]));
// 	    sensitive << (*(in_PREDICT_BTB_IS_ACCURATE [i]));
	  }
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    (*(out_PREDICT_ACK                  [i])) (*(in_PREDICT_BTB_IS_ACCURATE [i]));
	    if (_param->_have_port_context_id)
	    (*(out_PREDICT_ACK                  [i])) (*(in_PREDICT_CONTEXT_ID      [i]));
	  }
# endif    

	log_printf(INFO,Update_Prediction_Table,FUNCTION,"Method - genMealy_decod");

	SC_METHOD (genMealy_decod);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    if (_param->_have_port_context_id)
	      sensitive << (*(in_DECOD_CONTEXT_ID [i]));
	  }
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    if (_param->_have_port_context_id)
	    (*(out_DECOD_ACK                  [i])) (*(in_DECOD_CONTEXT_ID  [i]));
	  }
# endif    

	log_printf(INFO,Update_Prediction_Table,FUNCTION,"Method - genMealy_branch_complete");

	SC_METHOD (genMealy_branch_complete);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
	  {
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_BRANCH_COMPLETE_CONTEXT_ID [i]));
	    if (_param->_have_port_depth)
	    sensitive << (*(in_BRANCH_COMPLETE_DEPTH [i]));
	    sensitive << (*(in_BRANCH_COMPLETE_NO_SEQUENCE [i]))
		      << (*(in_BRANCH_COMPLETE_ADDRESS [i]));
	  }
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
	  {
	    if (_param->_have_port_context_id)
	    (*(out_BRANCH_COMPLETE_MISS_PREDICTION [i])) (*(in_BRANCH_COMPLETE_CONTEXT_ID [i]));
	    if (_param->_have_port_depth)
	    (*(out_BRANCH_COMPLETE_MISS_PREDICTION [i])) (*(in_BRANCH_COMPLETE_DEPTH      [i]));
	    (*(out_BRANCH_COMPLETE_MISS_PREDICTION [i])) (*(in_BRANCH_COMPLETE_NO_SEQUENCE[i]));
	    (*(out_BRANCH_COMPLETE_MISS_PREDICTION [i])) (*(in_BRANCH_COMPLETE_ADDRESS    [i]));

	    if (_param->_have_port_context_id)
	    (*(out_BRANCH_COMPLETE_TAKE            [i])) (*(in_BRANCH_COMPLETE_CONTEXT_ID [i]));
	    if (_param->_have_port_depth)
	    (*(out_BRANCH_COMPLETE_TAKE            [i])) (*(in_BRANCH_COMPLETE_DEPTH      [i]));
	    (*(out_BRANCH_COMPLETE_TAKE            [i])) (*(in_BRANCH_COMPLETE_NO_SEQUENCE[i]));

	    if (_param->_have_port_context_id)
	    (*(out_BRANCH_COMPLETE_ADDRESS_SRC     [i])) (*(in_BRANCH_COMPLETE_CONTEXT_ID [i]));
	    if (_param->_have_port_depth)
	    (*(out_BRANCH_COMPLETE_ADDRESS_SRC     [i])) (*(in_BRANCH_COMPLETE_DEPTH      [i]));

	    if (_param->_have_port_context_id)
	    (*(out_BRANCH_COMPLETE_ADDRESS_DEST    [i])) (*(in_BRANCH_COMPLETE_CONTEXT_ID [i]));
	    if (_param->_have_port_depth)
	    (*(out_BRANCH_COMPLETE_ADDRESS_DEST    [i])) (*(in_BRANCH_COMPLETE_DEPTH      [i]));
	    (*(out_BRANCH_COMPLETE_ADDRESS_DEST    [i])) (*(in_BRANCH_COMPLETE_ADDRESS    [i]));
	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::~Update_Prediction_Table"
  Update_Prediction_Table::~Update_Prediction_Table (void)
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Update_Prediction_Table,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
