#ifdef SYSTEMC
/*
 * $Id: Register_translation_unit_Glue_genMealy_insert.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Register_translation_unit_Glue/include/Register_translation_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace register_translation_unit_glue {


#undef  FUNCTION
#define FUNCTION "Register_translation_unit_Glue::genMealy_insert"
  void Register_translation_unit_Glue::genMealy_insert (void)
  {
    log_begin(Register_translation_unit_Glue,FUNCTION);
    log_function(Register_translation_unit_Glue,FUNCTION,_name.c_str());

    for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
      {
	Tcontrol_t         READ_RA            = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_READ_RA            [i]);
	Tgeneral_address_t NUM_REG_RA_PHY     = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RA_PHY     [i]);
	Tcontrol_t         READ_RB            = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_READ_RB            [i]);
	Tgeneral_address_t NUM_REG_RB_PHY     = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RB_PHY     [i]);
	Tcontrol_t         READ_RC            = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_READ_RC            [i]);
	Tspecial_address_t NUM_REG_RC_PHY     = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RC_PHY     [i]);
	Tcontrol_t         WRITE_RD           = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_WRITE_RD           [i]);
	Tgeneral_address_t NUM_REG_RD_LOG     = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_LOG     [i]);
	Tgeneral_address_t NUM_REG_RD_PHY_OLD = (NUM_REG_RD_LOG!=0)?PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_OLD [i]):0;
	Tgeneral_address_t NUM_REG_RD_PHY_NEW = (NUM_REG_RD_LOG!=0)?PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RD_PHY_NEW [i]):0;
	Tcontrol_t         WRITE_RE           = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_WRITE_RE           [i]);
	Tspecial_address_t NUM_REG_RE_LOG     = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_LOG     [i]);
	Tspecial_address_t NUM_REG_RE_PHY_OLD = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_OLD [i]);
	Tspecial_address_t NUM_REG_RE_PHY_NEW = PORT_READ(in_INSERT_DEPENDENCY_CHECKING_NUM_REG_RE_PHY_NEW [i]);

	PORT_WRITE(out_INSERT_FREE_LIST_GPR_VAL            [i], WRITE_RD and (NUM_REG_RD_LOG!=0));
	PORT_WRITE(out_INSERT_FREE_LIST_SPR_VAL            [i], WRITE_RE          );

	PORT_WRITE(out_INSERT_STAT_LIST_READ_RA            [i], READ_RA           );
	PORT_WRITE(out_INSERT_STAT_LIST_NUM_REG_RA_PHY     [i], NUM_REG_RA_PHY    );
	PORT_WRITE(out_INSERT_STAT_LIST_READ_RB            [i], READ_RB           );
	PORT_WRITE(out_INSERT_STAT_LIST_NUM_REG_RB_PHY     [i], NUM_REG_RB_PHY    );
	PORT_WRITE(out_INSERT_STAT_LIST_READ_RC            [i], READ_RC           );
	PORT_WRITE(out_INSERT_STAT_LIST_NUM_REG_RC_PHY     [i], NUM_REG_RC_PHY    );
	PORT_WRITE(out_INSERT_STAT_LIST_WRITE_RD           [i], WRITE_RD          );
	PORT_WRITE(out_INSERT_STAT_LIST_NUM_REG_RD_PHY_NEW [i], NUM_REG_RD_PHY_NEW);
	PORT_WRITE(out_INSERT_STAT_LIST_WRITE_RE           [i], WRITE_RE          );
	PORT_WRITE(out_INSERT_STAT_LIST_NUM_REG_RE_PHY_NEW [i], NUM_REG_RE_PHY_NEW);
	
	PORT_WRITE(out_INSERT_RAT_WRITE_RD                 [i], WRITE_RD          );
	PORT_WRITE(out_INSERT_RAT_NUM_REG_RD_LOG           [i], NUM_REG_RD_LOG    );
	PORT_WRITE(out_INSERT_RAT_NUM_REG_RD_PHY_NEW       [i], NUM_REG_RD_PHY_NEW);
	PORT_WRITE(out_INSERT_RAT_WRITE_RE                 [i], WRITE_RE          );
	PORT_WRITE(out_INSERT_RAT_NUM_REG_RE_LOG           [i], NUM_REG_RE_LOG    );
	PORT_WRITE(out_INSERT_RAT_NUM_REG_RE_PHY_NEW       [i], NUM_REG_RE_PHY_NEW);
	
	PORT_WRITE(out_INSERT_READ_RA                      [i], READ_RA           );
	PORT_WRITE(out_INSERT_NUM_REG_RA_PHY               [i], NUM_REG_RA_PHY    );
	PORT_WRITE(out_INSERT_READ_RB                      [i], READ_RB           );
	PORT_WRITE(out_INSERT_NUM_REG_RB_PHY               [i], NUM_REG_RB_PHY    );
	PORT_WRITE(out_INSERT_READ_RC                      [i], READ_RC           );
	PORT_WRITE(out_INSERT_NUM_REG_RC_PHY               [i], NUM_REG_RC_PHY    );
	PORT_WRITE(out_INSERT_WRITE_RD                     [i], WRITE_RD          );
	PORT_WRITE(out_INSERT_NUM_REG_RD_LOG               [i], NUM_REG_RD_LOG    );
	PORT_WRITE(out_INSERT_NUM_REG_RD_PHY_OLD           [i], NUM_REG_RD_PHY_OLD);
	PORT_WRITE(out_INSERT_NUM_REG_RD_PHY_NEW           [i], NUM_REG_RD_PHY_NEW);
	PORT_WRITE(out_INSERT_WRITE_RE                     [i], WRITE_RE          );
	PORT_WRITE(out_INSERT_NUM_REG_RE_LOG               [i], NUM_REG_RE_LOG    );
	PORT_WRITE(out_INSERT_NUM_REG_RE_PHY_OLD           [i], NUM_REG_RE_PHY_OLD);
	PORT_WRITE(out_INSERT_NUM_REG_RE_PHY_NEW           [i], NUM_REG_RE_PHY_NEW);
      }

    log_end(Register_translation_unit_Glue,FUNCTION);
  };

}; // end namespace register_translation_unit_glue
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
