/*
 * $Id: Parameters.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/include/Parameters.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {


#undef  FUNCTION
#define FUNCTION "Front_end::Parameters"
  Parameters::Parameters (uint32_t                nb_context                          ,
                          uint32_t                nb_decod_unit                       ,
                          uint32_t                size_general_data                   ,
                          morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void),
                          // ifetch_unit                                              
                          uint32_t              * size_ifetch_queue                   ,//[nb_context]
                          ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t
                                                * ifetch_queue_scheme                 ,//[nb_context]
                          uint32_t              * nb_inst_fetch                       ,//[nb_context]
                          bool                 ** instruction_implemeted              ,//[nb_context]
                          uint32_t              * link_context_to_decod_unit          ,//[nb_context]
                          // decod_unit                                              
                          uint32_t              * size_decod_queue                    ,//[nb_decod_unit]
                          decod_unit::decod_queue::Tdecod_queue_scheme_t
                                                * decod_queue_scheme                  ,//[nb_decod_unit]
                          uint32_t              * nb_inst_decod                       ,//[nb_decod_unit]
                          uint32_t              * nb_context_select                   ,//[nb_decod_unit]
                          Tpriority_t           * context_select_priority             ,//[nb_decod_unit]
                          Tload_balancing_t     * context_select_load_balancing       ,//[nb_decod_unit]
                          // prediction_unit                                                 
                          uint32_t                nb_inst_branch_predict              ,
                          uint32_t                nb_inst_branch_decod                ,
                          uint32_t                nb_inst_branch_update               ,
                          uint32_t                nb_inst_branch_complete             ,
                          uint32_t                btb_size_queue                      ,
                          uint32_t                btb_associativity                   ,
                          uint32_t                btb_size_counter                    ,
                          Tvictim_t               btb_victim_scheme                   ,
                          Tpredictor_t            dir_predictor_scheme                ,
                          bool                  * dir_have_bht                        ,//[3]
                          uint32_t              * dir_bht_size_shifter                ,//[3]
                          uint32_t              * dir_bht_nb_shifter                  ,//[3]
                          bool                  * dir_have_pht                        ,//[3]
                          uint32_t              * dir_pht_size_counter                ,//[3]
                          uint32_t              * dir_pht_nb_counter                  ,//[3]
                          uint32_t              * dir_pht_size_address_share          ,//[3]
                          Tpht_scheme_t         * dir_pht_scheme                      ,//[3]
                          uint32_t              * ras_size_queue                      ,
                          uint32_t              * upt_size_queue                      ,
                          uint32_t              * ufpt_size_queue                     ,
                          // context_state                                           
                          uint32_t                size_nb_inst_commit                 ,

                          uint32_t                nb_thread                           ,
                          uint32_t              * translate_num_context_to_num_thread ,//[nb_context]                    

                          bool                    is_toplevel):
    morpheo::behavioural::Parameters()
  {
    log_begin(Front_end,FUNCTION);

    _nb_context                          = nb_context                          ;
    _nb_decod_unit                       = nb_decod_unit                       ;
//  _size_general_data                   = size_general_data                   ;
    _get_custom_information              = get_custom_information              ;
    _nb_thread                           = nb_thread                           ;
    _translate_num_context_to_num_thread = translate_num_context_to_num_thread ;
    _size_ifetch_queue                   = size_ifetch_queue                   ;
    _ifetch_queue_scheme                 = ifetch_queue_scheme                 ;
    _nb_inst_fetch                       = nb_inst_fetch                       ;
    _instruction_implemeted              = instruction_implemeted              ;
    _link_context_to_decod_unit          = link_context_to_decod_unit          ;
    _size_decod_queue                    = size_decod_queue                    ;
    _decod_queue_scheme                  = decod_queue_scheme                  ;
    _nb_inst_decod                       = nb_inst_decod                       ;
    _nb_context_select                   = nb_context_select                   ;
    _context_select_priority             = context_select_priority             ;
    _context_select_load_balancing       = context_select_load_balancing       ;
    _nb_inst_branch_predict              = nb_inst_branch_predict              ;
    _nb_inst_branch_decod                = nb_inst_branch_decod                ;
    _nb_inst_branch_update               = nb_inst_branch_update               ;
    _nb_inst_branch_complete             = nb_inst_branch_complete             ;
    _btb_size_queue                      = btb_size_queue                      ;
    _btb_associativity                   = btb_associativity                   ;
    _btb_size_counter                    = btb_size_counter                    ;
    _btb_victim_scheme                   = btb_victim_scheme                   ;
    _dir_predictor_scheme                = dir_predictor_scheme                ;
    for (uint32_t i=0; i<3; i++)
      {
	_dir_have_bht               [i] = dir_have_bht               [i];
	_dir_bht_size_shifter       [i] = dir_bht_size_shifter       [i];
	_dir_bht_nb_shifter         [i] = dir_bht_nb_shifter         [i];
	_dir_have_pht               [i] = dir_have_pht               [i];
	_dir_pht_size_counter       [i] = dir_pht_size_counter       [i];
	_dir_pht_nb_counter         [i] = dir_pht_nb_counter         [i];
	_dir_pht_size_address_share [i] = dir_pht_size_address_share [i];
	_dir_pht_scheme             [i] = dir_pht_scheme             [i];
      }
    _ras_size_queue                      = ras_size_queue                      ;
    _upt_size_queue                      = upt_size_queue                      ;
    _ufpt_size_queue                     = ufpt_size_queue                     ;

    test();

//  _size_context_id                     = log2(_nb_context);
    uint32_t size_instruction_address   = size_general_data - 2;

    ALLOC1(_array_size_depth            ,uint32_t,_nb_context);
    for (uint32_t i=0; i<_nb_context; i++)
      _array_size_depth [i] = log2(_upt_size_queue[i]);
    
    ALLOC1(_array_size_nb_inst_decod    ,uint32_t,_nb_decod_unit);
    for (uint32_t i=0; i<_nb_decod_unit; i++)
      _array_size_nb_inst_decod [i] = log2(_size_decod_queue[i]+1);

    uint32_t size_nb_inst_decod         = max<uint32_t>(_array_size_nb_inst_decod,_nb_decod_unit);

    _param_ifetch_unit = new behavioural::core::multi_front_end::front_end::ifetch_unit::Parameters * [_nb_context];
    for (uint32_t i=0; i<_nb_context; ++i)
      {
        _param_ifetch_unit [i] = new behavioural::core::multi_front_end::front_end::ifetch_unit::Parameters 
          (_size_ifetch_queue  [i]        ,
           _ifetch_queue_scheme[i]        ,
           _nb_inst_fetch      [i]        ,
           log2(_upt_size_queue[i])       ,
           size_instruction_address      );
      }

    _param_prediction_unit = new behavioural::core::multi_front_end::front_end::prediction_unit::Parameters 
      (_nb_context                         ,
       _nb_decod_unit                      ,
       size_instruction_address            ,
       _nb_inst_fetch                      ,
       _nb_inst_decod                      ,
       _nb_inst_branch_predict             ,
       _nb_inst_branch_decod               ,
       _nb_inst_branch_update              ,
       _nb_inst_branch_complete            ,
       _btb_size_queue                     ,
       _btb_associativity                  ,
       _btb_size_counter                   ,
       _btb_victim_scheme                  ,
       _dir_predictor_scheme               ,
       _dir_have_bht                       ,
       _dir_bht_size_shifter               ,
       _dir_bht_nb_shifter                 ,
       _dir_have_pht                       ,
       _dir_pht_size_counter               ,
       _dir_pht_nb_counter                 ,
       _dir_pht_size_address_share         ,
       _dir_pht_scheme                     ,
       _ras_size_queue                     ,
       _upt_size_queue                     ,
       _ufpt_size_queue                    ,
       _nb_thread                          ,
       _translate_num_context_to_num_thread
       );

    ALLOC1(_translate_context_id_from_decod_unit,std::vector<uint32_t>,_nb_decod_unit);

    for (uint32_t i=0; i<_nb_context; ++i)
      _translate_context_id_from_decod_unit [_link_context_to_decod_unit[i]].push_back(i);

    ALLOC1(_decod_unit_nb_context            ,uint32_t,_nb_decod_unit);
    ALLOC2(_decod_unit_nb_inst_fetch         ,uint32_t,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size());
    ALLOC2(_decod_unit_nb_branch_speculated  ,uint32_t,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size());
//  ALLOC2(_decod_unit_depth                 ,uint32_t,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size());
    ALLOC3(_decod_unit_instruction_implemeted,bool    ,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size(),NB_INSTRUCTION);
//  ALLOC2(_have_port_decod_unit_context_id  ,bool    ,_nb_decod_unit);
    _sum_inst_decod                      = 0;
    
    for (uint32_t i=0; i<_nb_decod_unit; ++i)
      {
        _sum_inst_decod += _nb_inst_decod [i];

        uint32_t size = _translate_context_id_from_decod_unit [i].size();

        _decod_unit_nb_context             [i] = size;
//      _have_port_decod_unit_context_id   [i] = size > 0;

        for (uint32_t j=0; j<size; ++j)
          {
            uint32_t x = _translate_context_id_from_decod_unit[i][j];

            _decod_unit_nb_inst_fetch          [i][j] = _nb_inst_fetch  [x];
            _decod_unit_nb_branch_speculated   [i][j] = _upt_size_queue [x];
//          _decod_unit_depth                  [i][j] = log2(_upt_size_queue[x]);

            for (uint32_t k=0; k<NB_INSTRUCTION; ++k)
              _decod_unit_instruction_implemeted [i][j][k] = _instruction_implemeted [x][k];
          }
      }

    log_printf(TRACE,Front_end,FUNCTION,_("Translate"));
    for (uint32_t i=0; i<_nb_decod_unit; ++i)
      {
        uint32_t size = _decod_unit_nb_context [i];
        log_printf(TRACE,Front_end,FUNCTION,_("Decod_unit [%d], nb_decod_unit_context : %d"),i,size);

        for (uint32_t j=0; j<size; ++j)
          {
            log_printf(TRACE,Front_end,FUNCTION,_("  Context [%d] -> Decod_unit_Context [%d]"),j,(_translate_context_id_from_decod_unit [i])[j]);
            log_printf(TRACE,Front_end,FUNCTION,_("    * decod_unit_nb_inst_fetch        : %d"),_decod_unit_nb_inst_fetch       [i][j]);
            log_printf(TRACE,Front_end,FUNCTION,_("    * decod_unit_nb_branch_speculated : %d"),_decod_unit_nb_branch_speculated[i][j]);
          }
      }

    _param_decod_unit = new behavioural::core::multi_front_end::front_end::decod_unit::Parameters * [_nb_decod_unit];
    for (uint32_t i=0; i<_nb_decod_unit; ++i)
      {
        _param_decod_unit [i] = new behavioural::core::multi_front_end::front_end::decod_unit::Parameters
          (_decod_unit_nb_context             [i],
           _decod_unit_nb_inst_fetch          [i],
           _nb_inst_decod                     [i],
           _size_decod_queue                  [i],
           _decod_queue_scheme                [i],
            size_general_data                    ,
           _decod_unit_nb_branch_speculated   [i],
//         _decod_unit_depth                  [i],
           _nb_context_select                 [i],
           _context_select_priority           [i],
           _context_select_load_balancing     [i],
           _decod_unit_instruction_implemeted [i],
           _get_custom_information               );
      }

    _param_context_state = new behavioural::core::multi_front_end::front_end::context_state::Parameters
      (_nb_context,
       _nb_decod_unit,
       _nb_inst_branch_complete,
       _upt_size_queue,                
        size_instruction_address,
       _array_size_nb_inst_decod,           
        size_nb_inst_commit,          
       _link_context_to_decod_unit);

    _param_glue = new behavioural::core::multi_front_end::front_end::front_end_glue::Parameters
      (_nb_context                           ,
       _nb_decod_unit                        ,
       _nb_inst_decod                        ,
       _nb_inst_branch_complete              ,
       _link_context_to_decod_unit           ,
       _translate_context_id_from_decod_unit ,
       size_instruction_address              ,
       _array_size_depth                     ,
       _upt_size_queue                       ,//_nb_branch_speculated
       size_nb_inst_decod
       );

    if (is_toplevel)
      {
        _size_context_id            = log2(_nb_context);
        _size_instruction_address   = size_instruction_address;
        _size_general_data          = size_general_data;
        _size_nb_inst_decod         = size_nb_inst_decod;
        _size_nb_inst_commit        = size_nb_inst_commit;
        _size_depth                 = max<uint32_t>(_array_size_depth,_nb_context);
        _size_ifetch_queue_ptr      = log2(max<uint32_t>(_size_ifetch_queue,_nb_context));
        _size_inst_ifetch_ptr       = log2(max<uint32_t>(_nb_inst_fetch    ,_nb_context));
        
        _have_port_context_id       = _size_context_id      > 0;
        _have_port_depth            = _size_depth           > 0;
        _have_port_ifetch_queue_ptr = _size_ifetch_queue_ptr> 0;
        _have_port_inst_ifetch_ptr  = _size_inst_ifetch_ptr > 0;

        copy ();
      }

    log_end(Front_end,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Front_end::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Front_end,FUNCTION);
//     test();
//     log_end(Front_end,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Front_end::~Parameters"
  Parameters::~Parameters () 
  {
    log_begin(Front_end,FUNCTION);
    
    delete    _param_glue           ;
    delete    _param_context_state  ;
    for (uint32_t i=0; i<_nb_decod_unit; i++)
    delete    _param_decod_unit [i];
    delete [] _param_decod_unit     ;
    delete    _param_prediction_unit;
    for (uint32_t i=0; i<_nb_context; i++)
    delete    _param_ifetch_unit [i];
    delete [] _param_ifetch_unit    ;

//  DELETE2(_have_port_decod_unit_context_id     ,_nb_decod_unit);
    DELETE3(_decod_unit_instruction_implemeted   ,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size(),NB_INSTRUCTION);
//  DELETE2(_decod_unit_depth                    ,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size());
    DELETE2(_decod_unit_nb_branch_speculated     ,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size());
    DELETE2(_decod_unit_nb_inst_fetch            ,_nb_decod_unit,_translate_context_id_from_decod_unit [it1].size());
    DELETE1(_decod_unit_nb_context               ,_nb_decod_unit);

    DELETE1(_translate_context_id_from_decod_unit,_nb_decod_unit);
    DELETE1(_array_size_nb_inst_decod            ,_nb_decod_unit);
    DELETE1(_array_size_depth                    ,_nb_context);

    log_end(Front_end,FUNCTION);
  };


#undef  FUNCTION
#define FUNCTION "Front_end::copy"
  void Parameters::copy (void) 
  {
    log_begin(Front_end,FUNCTION);

    COPY(_param_glue           );
    COPY(_param_context_state  );
    for (uint32_t i=0; i<_nb_decod_unit; i++)
      {
        COPY(_param_decod_unit  [i]);
      }
    COPY(_param_prediction_unit);
    for (uint32_t i=0; i<_nb_context; i++)
    COPY(_param_ifetch_unit [i]);

    log_end(Front_end,FUNCTION);
  };

}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
