#ifdef VHDL
/*
 * $Id: RegisterFile_Monolithic_vhdl_body.cpp 146 2011-02-01 20:57:54Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/RegisterFile_Monolithic/include/RegisterFile_Monolithic.h"

namespace morpheo                    {
namespace behavioural                {
namespace generic                    {
namespace registerfile               {
namespace registerfile_monolithic    {

  void RegisterFile_Monolithic::vhdl_body (Vhdl * & vhdl)
  {
#ifndef VHDL_GAISLER

    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_comment(0," Ackitement");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_body   (0,"");

    for (uint32_t i = 0; i < _param->_nb_port_read; i++)
      vhdl->set_body   (0,"out_READ_"+toString(i)+"_ACK  <= '1';");
    for (uint32_t i = 0; i < _param->_nb_port_write; i++)
      vhdl->set_body   (0,"out_WRITE_"+toString(i)+"_ACK <= '1';");

    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_comment(0," Read RegisterFile");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_body   (0,"");
    
    for (uint32_t i = 0; i < _param->_nb_port_read; i++)
      {
	std::string str_address;
	if (_param->_have_port_address)
	  str_address = "conv_integer(in_READ_"+toString(i)+"_ADDRESS)";
	else
	  str_address = "0";

	vhdl->set_body   (0,"out_READ_"+toString(i)+"_DATA <= reg_DATA ("+str_address+") when in_READ_"+toString(i)+"_VAL = '1' else "+std_logic_others(_param->_size_word,0)+";");
      }

    vhdl->set_body   (0,"");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_comment(0," Write RegisterFile");
    vhdl->set_comment(0,"---------------------------------------------------------------------------");
    vhdl->set_body   (0,"");

    vhdl->set_body   (0,"RegisterFile_write: process (in_CLOCK)");
    vhdl->set_body   (0,"begin  -- process RegisterFile_write");
    vhdl->set_body   (1,"if in_CLOCK'event and in_CLOCK = '1' then");

    if (_param->_have_init_value)
      {
        vhdl->set_body   (2,"if in_NRESET = '0' then");
        
        std::string init_value = ((_param->_size_word>1)?"\"":"'")+_param->_init_value+((_param->_size_word>1)?"\"":"'");
        
        for (uint32_t i=0; i<_param->_nb_word; ++i)
          vhdl->set_body   (3,"reg_DATA("+toString(i)+") <= "+init_value+";");

        vhdl->set_body   (2,"else");
      }
    
    for (uint32_t i = 0; i < _param->_nb_port_write; i++)
      {
	std::string str_address;
	if (_param->_have_port_address)
	  str_address = "conv_integer(in_WRITE_"+toString(i)+"_ADDRESS)";
	else
	  str_address = "0";

	vhdl->set_body   (2,"if (in_WRITE_"+toString(i)+"_VAL = '1') then");
	vhdl->set_body   (3,"reg_DATA("+str_address+") <= in_WRITE_"+toString(i)+"_DATA;");
	vhdl->set_body   (2,"end if;");
      }

    vhdl->set_body   (1,"end if;");

    if (_param->_have_init_value)
      vhdl->set_body   (1,"end if;");
    vhdl->set_body   (0,"end process RegisterFile_write;");

#else
    // vhdl->set_body   (0,"");
    // vhdl->set_comment(0,"---------------------------------------------------------------------------");
    // vhdl->set_comment(0," Ackitement");
    // vhdl->set_comment(0,"---------------------------------------------------------------------------");
    // vhdl->set_body   (0,"");

    // for (uint32_t i = 0; i < _param->_nb_port_read; i++)
    //   vhdl->set_body   (0,"out_READ_"+toString(i)+"_ACK  <= '1';");
    // for (uint32_t i = 0; i < _param->_nb_port_write; i++)
    //   vhdl->set_body   (0,"out_WRITE_"+toString(i)+"_ACK <= '1';");

    // vhdl->set_body   (0,"");
    // vhdl->set_comment(0,"---------------------------------------------------------------------------");
    // vhdl->set_comment(0," Read RegisterFile");
    // vhdl->set_comment(0,"---------------------------------------------------------------------------");
    // vhdl->set_body   (0,"");

    // for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
    //   {
    //     vhdl->set_body   (0,"with in_READ_"+toString(num_read)+"_ADDRESS select");
    //       vhdl->set_body   (1,"out_READ_"+toString(num_read)+"_DATA <=");
    //       for (uint32_t num_word=0; num_word<_param->_nb_word-1; ++num_word)
    //         vhdl->set_body   (1,"reg_DATA_"+toString(num_word)+" when "+std_logic_cst(_param->_size_address,num_word)+",");
    //       vhdl->set_body   (1,"reg_DATA_"+toString(_param->_nb_word-1)+" when others;");
    //   }

    // vhdl->set_body   (0,"");
    // vhdl->set_comment(0,"---------------------------------------------------------------------------");
    // vhdl->set_comment(0," Write RegisterFile");
    // vhdl->set_comment(0,"---------------------------------------------------------------------------");
    // vhdl->set_body   (0,"");

    // vhdl->set_body   (0,"RegisterFile_write: process (in_CLOCK)");
    // vhdl->set_body   (0,"begin  -- process RegisterFile_write");
    // vhdl->set_body   (1,"if in_CLOCK'event and in_CLOCK = '1' then");

    // for (uint32_t num_write = 0; num_write < _param->_nb_port_write; num_write++)
    //   {
    //     vhdl->set_body   (2,"if (in_WRITE_"+toString(num_write)+"_VAL = '1') then");
    //     for (uint32_t num_word=0; num_word<_param->_nb_word; ++num_word)
    //       {
    //         vhdl->set_body   (3,"if (in_WRITE_"+toString(num_write)+"_ADDRESS = "+std_logic_cst(_param->_size_address,num_word)+") then");
    //         vhdl->set_body   (4,"reg_DATA_"+toString(num_word)+" <= in_WRITE_"+toString(num_write)+"_DATA;");
    //         vhdl->set_body   (3,"end if;");
    //       }
    //     vhdl->set_body   (2,"end if;");
    //   }
    
    // vhdl->set_body   (1,"end if;");
    // vhdl->set_body   (0,"end process RegisterFile_write;");

    vhdl->set_body   (0,"combinatory : process (");
    for (uint32_t num_read=0; num_read<_param->_nb_port_read; ++num_read)
      {
        vhdl->set_body   (1,"in_READ_"+toString(num_read)+"_VAL,");
	if (_param->_have_port_address)
        vhdl->set_body   (1,"in_READ_"+toString(num_read)+"_ADDRESS,");
      }
    for (uint32_t num_write=0; num_write<_param->_nb_port_write; ++num_write)
      {
        vhdl->set_body   (1,"in_WRITE_"+toString(num_write)+"_VAL,");
	if (_param->_have_port_address)
        vhdl->set_body   (1,"in_WRITE_"+toString(num_write)+"_ADDRESS,");
        vhdl->set_body   (1,"in_WRITE_"+toString(num_write)+"_DATA,");
      }
    for (uint32_t num_write = 0; num_write < _param->_nb_port_write; num_write++)
    vhdl->set_body   (1,"in_NRESET,");
    vhdl->set_body   (1,"reg_DATA)");
    vhdl->set_body   (1,"variable sig_DATA : Treg;");
    vhdl->set_body   (0,"begin");
    vhdl->set_body   (1,"");
    vhdl->set_body   (1,"sig_DATA := reg_DATA;");

    vhdl->set_body   (1,"");
    vhdl->set_body   (1," -- ack");
    vhdl->set_body   (1,"");
    
    for (uint32_t i = 0; i < _param->_nb_port_read; i++)
      vhdl->set_body   (1,"out_READ_"+toString(i)+"_ACK  <= '1';");
    for (uint32_t i = 0; i < _param->_nb_port_write; i++)
      vhdl->set_body   (1,"out_WRITE_"+toString(i)+"_ACK <= '1';");
    vhdl->set_body   (1,"");
    vhdl->set_body   (1," -- Read");
    vhdl->set_body   (1,"");

    for (uint32_t i = 0; i < _param->_nb_port_read; i++)
      {
	std::string str_address;
	if (_param->_have_port_address)
	  str_address = "conv_integer(in_READ_"+toString(i)+"_ADDRESS)";
	else
	  str_address = "0";

        vhdl->set_body   (1,"if (in_READ_"+toString(i)+"_VAL = '1') then"),
	vhdl->set_body   (2,"out_READ_"+toString(i)+"_DATA <= sig_DATA.reg ("+str_address+");");
        vhdl->set_body   (1,"else"),
	vhdl->set_body   (2,"out_READ_"+toString(i)+"_DATA <= "+std_logic_others(_param->_size_word,0)+";");
        vhdl->set_body   (1,"end if;");
      }
    vhdl->set_body   (1,"");
    vhdl->set_body   (1," -- write");
    vhdl->set_body   (1,"");

    for (uint32_t i = 0; i < _param->_nb_port_write; i++)
      {
	std::string str_address;
	if (_param->_have_port_address)
	  str_address = "conv_integer(in_WRITE_"+toString(i)+"_ADDRESS)";
	else
	  str_address = "0";

	vhdl->set_body   (1,"if (in_WRITE_"+toString(i)+"_VAL = '1') then");
	vhdl->set_body   (2,"sig_DATA.reg("+str_address+") := in_WRITE_"+toString(i)+"_DATA;");
	vhdl->set_body   (1,"end if;");
      }

    vhdl->set_body   (1,"");
    vhdl->set_body   (1,"reg_DATA_next <= sig_DATA;");
    vhdl->set_body   (1,"");
    vhdl->set_body   (0,"end process combinatory;");


    vhdl->set_body   (0,"sequential: process (in_CLOCK)");
    vhdl->set_body   (0,"begin");
    vhdl->set_body   (1,"if rising_edge(in_CLOCK) then");
    vhdl->set_body   (2,"reg_DATA <= reg_DATA_NEXT;");
    vhdl->set_body   (1,"end if;");
    vhdl->set_body   (0,"end process sequential;");

#endif

  };

}; // end namespace registerfile_monolithic
}; // end namespace registerfile 
}; // end namespace generic
}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
