/*****************************************************************************

  timer.c -- Function dealing with the timer 


Authors:
Pierre-Edouard BEAUCAMPS, THALES COM - AAL, 2009

Copyright (C) THALES & Martin Fiedler All rights reserved.

This code is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This code is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this code (see file COPYING).  If not, see
<http://www.gnu.org/licenses/>.

This License does not grant permission to use the name of the copyright
owner, except only as required above for reproducing the content of
the copyright notice.
 *****************************************************************************/

#include "timer.h"
#include "hexo/cpu.h"

static uint32_t cycle_count_begin;

/*************************************
  Return Timer Value
 *************************************/
uint32_t get_timer_value()
{
#if defined(CONFIG_DRIVER_TIMER_EMU)
	return (uint32_t) timer_emu_getvalue(timerms_dev, 0);
#elif defined(CONFIG_DRIVER_TIMER_SOCLIB)
	return (uint32_t) cpu_cycle_count() - cycle_count_begin;
#else
	return -1;
#endif
}

/*************************************
  Set Timer Value
 *************************************/
void set_timer_value(uint32_t value)
{
#if defined(CONFIG_DRIVER_TIMER_EMU)
	timer_emu_setvalue(timerms_dev, 0, value);
#elif defined(CONFIG_DRIVER_TIMER_SOCLIB)
  cycle_count_begin = cpu_cycle_count();
#endif
}
