#ifndef SRL_ENDIANNESS_H_
#define SRL_ENDIANNESS_H_

#include <sys/endian.h>

static inline uint32_t srl_uint32_le_to_machine(uint32_t x)
{
	return le32toh(x);
}

static inline uint32_t srl_uint32_machine_to_le(uint32_t x)
{
	return htole32(x);
}

static inline uint32_t srl_uint32_be_to_machine(uint32_t x)
{
	return be32toh(x);
}

static inline uint32_t srl_uint32_machine_to_be(uint32_t x)
{
	return htobe32(x);
}

static inline uint16_t srl_uint16_le_to_machine(uint16_t x)
{
	return le16toh(x);
}

static inline uint16_t srl_uint16_machine_to_le(uint16_t x)
{
	return htole16(x);
}

static inline uint16_t srl_uint16_be_to_machine(uint16_t x)
{
	return be16toh(x);
}

static inline uint16_t srl_uint16_machine_to_be(uint16_t x)
{
	return htobe16(x);
}


#endif
