/* 	$NetBSD: cpuvar.h,v 1.27.16.2 2011/05/20 08:11:24 matt Exp $ */

/*-
 * Copyright (c) 2000, 2007 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by RedBack Networks Inc.
 *
 * Author: Bill Sommerfeld
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Copyright (c) 1999 Stefan Grefen
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the NetBSD
 *      Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.  
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR AND CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _X86_CPUVAR_H_
#define	_X86_CPUVAR_H_

struct cpu_functions {
	int (*start)(struct cpu_info *, paddr_t);
	int (*stop)(struct cpu_info *);
	void (*cleanup)(struct cpu_info *);
};

extern const struct cpu_functions mp_cpu_funcs;

#define CPU_ROLE_SP	0
#define CPU_ROLE_BP	1
#define CPU_ROLE_AP	2

struct cpu_attach_args {
	int cpu_number;
	int cpu_role;
	const struct cpu_functions *cpu_func;
};

#ifdef _KERNEL

#include "opt_multiprocessor.h"
#ifndef XEN
#include "opt_enhanced_speedstep.h"
#include "opt_intel_coretemp.h"
#include "opt_intel_odcm.h"
#include "opt_via_c7temp.h"
#endif

#ifdef MULTIPROCESSOR
extern uint32_t cpus_running;
#endif

int x86_ipi(int, int, int);
void x86_self_ipi(int);
int x86_ipi_init(int);
int x86_ipi_startup(int, int);
void x86_errata(void);

void identifycpu(struct cpu_info *);
void identifycpu_cpuids(struct cpu_info *);
void cpu_init(struct cpu_info *);
void cpu_init_tss(struct cpu_info *);
void cpu_init_first(void);

void x86_cpu_idle_init(void);
void x86_cpu_idle_halt(void);
void x86_cpu_idle_mwait(void);
#ifdef XEN
void x86_cpu_idle_xen(void);
#endif

#ifdef VIA_C7TEMP
void viac7temp_register(struct cpu_info *);
#endif

#ifdef INTEL_CORETEMP
void coretemp_register(struct cpu_info *);
#endif

#ifdef INTEL_ONDEMAND_CLOCKMOD
void clockmod_init(void);
#endif

#ifdef ENHANCED_SPEEDSTEP
void	est_init(int);
int	via_get_bus_clock(struct cpu_info *);
int	viac7_get_bus_clock(struct cpu_info *);
int	p3_get_bus_clock(struct cpu_info *);
int	p4_get_bus_clock(struct cpu_info *);
#endif

void	cpu_get_tsc_freq(struct cpu_info *);

extern int cpu_vendor;
extern bool x86_mp_online;

extern uint32_t cpu_feature;
extern uint32_t cpu_feature2;
extern uint32_t cpu_feature3;
extern uint32_t cpu_feature4;
extern uint32_t cpu_feature_padlock;
#endif

#endif /* !_X86_CPUVAR_H_ */
