/*	$NetBSD: types.h,v 1.25 2008/01/20 18:09:08 joerg Exp $	*/

#ifndef _TSARMIPS_TYPES_H_
#define _TSARMIPS_TYPES_H_
#ifndef _STANDALONE
#define _MIPS_PADDR_T_64BIT
#endif

#define __CPUSET_MAXNUMCPU 4096
	

#include <mips/types.h>

typedef __uint32_t __cpuset_e;
#define __CPUSET_E_NUMCPU 32

#define __CPUSET_E_IDX(cpu) ((cpu) / __CPUSET_E_NUMCPU)
#define __CPUSET_E_SHIFT(cpu) ((cpu) % __CPUSET_E_NUMCPU)

typedef struct __cpuset {
	volatile __cpuset_e cpuset[__CPUSET_E_IDX(__CPUSET_MAXNUMCPU)];
} __cpuset_t;


/* MIPS specific options */
/* #define	__HAVE_BOOTINFO_H not yet */
#endif /* _TSARMIPS_TYPES_H_ */
